/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.model.BaseObject;
import io.odilon.model.ObjectMetadata;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.service.ObjectStorageService;
import io.odilon.traffic.TrafficControlService;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.MediaType;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseApiController
extends BaseObject
implements ApplicationContextAware {
    @JsonIgnore
    private ApplicationContext applicationContext;
    @JsonIgnore
    @Autowired
    private SystemMonitorService monitoringService;
    @JsonIgnore
    @Autowired
    protected ObjectStorageService objectStorageService;
    @JsonIgnore
    @Autowired
    protected VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    @Autowired
    TrafficControlService trafficControlService;

    @Autowired
    public BaseApiController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService) {
        this(objectStorageService, virtualFileSystemService, systemMonitorService, null);
    }

    @Autowired
    public BaseApiController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, TrafficControlService trafficControlService) {
        this.objectStorageService = objectStorageService;
        this.virtualFileSystemService = virtualFileSystemService;
        this.monitoringService = systemMonitorService;
    }

    @PostConstruct
    protected void init() {
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public TrafficControlService getTrafficControlService() {
        return this.trafficControlService;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        return this.virtualFileSystemService;
    }

    public void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public SystemMonitorService getSystemMonitorService() {
        return this.monitoringService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ObjectStorageService getObjectStorageService() {
        return this.objectStorageService;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    protected long getSrcFileLength(ObjectMetadata objectMetadata) {
        long l = 0L;
        if (objectMetadata.getSourceLength() > 0L) {
            l = objectMetadata.getSourceLength();
            return l;
        }
        if (!objectMetadata.isEncrypt()) {
            l = objectMetadata.getLength();
            return l;
        }
        l = -1L;
        return l;
    }

    protected MediaType estimateContentType(String string) {
        if (string == null) {
            return MediaType.valueOf((String)"application/octet-stream");
        }
        if (BaseApiController.isPdf((String)string)) {
            return MediaType.valueOf((String)"application/pdf");
        }
        if (BaseApiController.isAudio((String)string)) {
            return MediaType.valueOf((String)"audio/mpeg");
        }
        if (BaseApiController.isVideo((String)string)) {
            return MediaType.valueOf((String)"video/mpeg");
        }
        if (BaseApiController.isJpeg((String)string)) {
            return MediaType.valueOf((String)"image/jpeg");
        }
        if (BaseApiController.isPng((String)string)) {
            return MediaType.valueOf((String)"image/png");
        }
        if (BaseApiController.isSvg((String)string)) {
            return MediaType.valueOf((String)"image/svg+xml");
        }
        if (BaseApiController.isGif((String)string)) {
            return MediaType.valueOf((String)"image/gif");
        }
        if (BaseApiController.isWebp((String)string)) {
            return MediaType.valueOf((String)"image/webp");
        }
        if (BaseApiController.isExcel((String)string)) {
            return MediaType.valueOf((String)"application/vnd.ms-excel");
        }
        if (BaseApiController.isWord((String)string)) {
            return MediaType.valueOf((String)"application/msword");
        }
        if (BaseApiController.isPowerPoint((String)string)) {
            return MediaType.valueOf((String)"application/vnd.ms-powerpoint");
        }
        return MediaType.valueOf((String)"application/octet-stream");
    }

    protected void mark() {
        this.getSystemMonitorService().getAllAPICallMeter().mark();
    }

    protected String getMessage(Throwable throwable) {
        if (throwable == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable.getClass().getName());
        if (throwable.getMessage() != null) {
            stringBuilder.append(" | " + throwable.getMessage());
        }
        if (throwable.getCause() != null) {
            stringBuilder.append(" | " + String.valueOf(throwable.getCause()));
        }
        return stringBuilder.toString();
    }

    public static boolean isPowerPoint(String string) {
        return string.toLowerCase().matches("^.*\\.(ppt|pptx)$");
    }

    public static boolean isWord(String string) {
        return string.toLowerCase().matches("^.*\\.(doc|docx|rtf)$");
    }

    public static boolean isVideo(String string) {
        return string.toLowerCase().matches("^.*\\.(mp4|flv|aac|ogg|wmv|3gp|avi|swf|svi|wtv|fla|mpeg|mpg|mov|m4v)$");
    }

    public static boolean isAudio(String string) {
        return string.toLowerCase().matches("^.*\\.(mp3|wav|ogga|ogg|aac|m4a|m4a|aif|wma)$");
    }

    public static boolean isExcel(String string) {
        return string.toLowerCase().matches("^.*\\.(xls|xlsx|xlsm)$");
    }

    public static boolean isJpeg(String string) {
        return string.toLowerCase().matches("^.*\\.(jpg|jpeg)$");
    }

    public static boolean isPdf(String string) {
        return string.toLowerCase().matches("^.*\\.(pdf)$");
    }

    public static boolean isGif(String string) {
        return string.toLowerCase().matches("^.*\\.(gif)$");
    }

    public static boolean isWebp(String string) {
        return string.toLowerCase().matches("^.*\\.(webp)$");
    }

    public static boolean isPng(String string) {
        return string.toLowerCase().matches("^.*\\.(png)$");
    }

    public static boolean isSvg(String string) {
        return string.toLowerCase().matches("^.*\\.(svg)$");
    }

    public static boolean isGeneralImage(String string) {
        return string.toLowerCase().matches("^.*\\.(png|jpg|jpeg|gif|bmp|heic)$");
    }

    public static boolean isImage(String string) {
        return BaseApiController.isGeneralImage((String)string) || string.toLowerCase().matches("^.*\\.(webp)$") || string.toLowerCase().matches("^.*\\.(svg)$");
    }
}

