/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import io.odilon.api.BaseApiController;
import io.odilon.error.OdilonInternalErrorException;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.error.OdilonServerAPIException;
import io.odilon.log.Logger;
import io.odilon.model.Bucket;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.net.ErrorCode;
import io.odilon.net.ODHttpStatus;
import io.odilon.service.ObjectStorageService;
import io.odilon.traffic.TrafficControlService;
import io.odilon.traffic.TrafficPass;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bucket"})
public class BucketController
extends BaseApiController {
    private static Logger logger = Logger.getLogger((String)BucketController.class.getName());

    @Autowired
    public BucketController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, TrafficControlService trafficControlService) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService, trafficControlService);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/list"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Bucket>> getBuckets() {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            ArrayList arrayList = new ArrayList();
            this.getObjectStorageService().findAllBuckets().forEach(serverBucket -> arrayList.add(new Bucket(serverBucket.getName(), serverBucket.getId(), serverBucket.getCreationDate(), serverBucket.getLastModifiedDate(), serverBucket.getStatus())));
            responseEntity = new ResponseEntity(arrayList, (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonInternalErrorException odilonInternalErrorException) {
            try {
                throw odilonInternalErrorException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/objects/{name}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataList<Item<ObjectMetadata>>> queryObjects(@PathVariable(value="name") String string, @RequestParam(value="offset") Optional<Long> optional, @RequestParam(value="pageSize") Optional<Integer> optional2, @RequestParam(value="prefix") Optional<String> optional3, @RequestParam(value="serverAgentId") Optional<String> optional4) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            DataList dataList = this.getObjectStorageService().listObjects(string, optional, optional2, optional3, optional4);
            responseEntity = new ResponseEntity((Object)dataList, (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonInternalErrorException odilonInternalErrorException) {
            try {
                throw odilonInternalErrorException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/get/{name}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Bucket> get(@PathVariable(value="name") String string) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            ServerBucket serverBucket = this.getObjectStorageService().findBucketName(string);
            if (serverBucket == null) {
                throw new OdilonObjectNotFoundException(ErrorCode.BUCKET_NOT_EXISTS, String.format("bucket does not exist -> %s", string));
            }
            responseEntity = new ResponseEntity((Object)new Bucket(serverBucket.getName(), serverBucket.getId(), serverBucket.getCreationDate(), serverBucket.getLastModifiedDate(), serverBucket.getStatus()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/exists/{name}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> exists(@PathVariable(value="name") String string) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            responseEntity = new ResponseEntity((Object)(this.getObjectStorageService().existsBucket(string) ? 1 : 0), (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/isempty/{name}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> isEmpty(@PathVariable(value="name") String string) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            ServerBucket serverBucket = this.getObjectStorageService().findBucketName(string);
            if (serverBucket == null) {
                throw new OdilonObjectNotFoundException(ErrorCode.BUCKET_NOT_EXISTS, String.format("bucket does not exist -> %s", string));
            }
            responseEntity = new ResponseEntity((Object)(this.getObjectStorageService().isEmptyBucket(string) ? 1 : 0), (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/create/{name}"}, produces={"application/json"}, method={RequestMethod.POST})
    public void create(@PathVariable(value="name") String string) {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (this.getObjectStorageService().existsBucket(string)) {
                throw new OdilonServerAPIException(ODHttpStatus.CONFLICT, ErrorCode.OBJECT_ALREADY_EXIST, new String[]{String.format("bucket already exist -> %s", Optional.ofNullable(string).orElse("null"))});
            }
            this.getObjectStorageService().createBucket(string);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/rename/{name}/{newname}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Bucket> rename(@PathVariable(value="name") String string, @PathVariable(value="newname") String string2) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            ServerBucket serverBucket = this.getObjectStorageService().findBucketName(string);
            if (serverBucket == null) {
                throw new OdilonObjectNotFoundException(ErrorCode.BUCKET_NOT_EXISTS, String.format("bucket does not exist -> %s", string));
            }
            if (this.getObjectStorageService().existsBucket(string2)) {
                throw new OdilonServerAPIException(ODHttpStatus.CONFLICT, ErrorCode.OBJECT_ALREADY_EXIST, new String[]{String.format("new bucket name already exist -> %s", Optional.ofNullable(string2).orElse("null"))});
            }
            serverBucket = this.getObjectStorageService().updateBucketName(serverBucket, string2);
            responseEntity = new ResponseEntity((Object)new Bucket(serverBucket.getName(), serverBucket.getId(), serverBucket.getCreationDate(), serverBucket.getLastModifiedDate(), serverBucket.getStatus()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/delete/{name}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="name") String string) {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getObjectStorageService().existsBucket(string)) {
                throw new OdilonObjectNotFoundException(ErrorCode.BUCKET_NOT_EXISTS, String.format("bucket does not exist -> %s", Optional.ofNullable(string).orElse("null")));
            }
            if (!this.getObjectStorageService().isEmptyBucket(string)) {
                throw new OdilonServerAPIException(ODHttpStatus.CONFLICT, ErrorCode.BUCKET_NOT_EMPTY, new String[]{String.format("bucket is not empty -> %s", Optional.ofNullable(string).orElse("null"))});
            }
            this.getObjectStorageService().deleteBucketByName(string);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/forcedelete/{name}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public void forceDelete(@PathVariable(value="name") String string) {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getObjectStorageService().existsBucket(string)) {
                throw new OdilonObjectNotFoundException(ErrorCode.BUCKET_NOT_EXISTS, String.format("bucket does not exist -> %s", Optional.ofNullable(string).orElse("null")));
            }
            this.getObjectStorageService().deleteBucketByName(string);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/deleteallpreviousversion/{name}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteAllPreviousVersions(@PathVariable(value="name") String string) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            if (!this.getObjectStorageService().existsBucket(string)) {
                throw new OdilonObjectNotFoundException(ErrorCode.BUCKET_NOT_EXISTS, String.format("bucket does not exist -> %s", Optional.ofNullable(string).orElse("null")));
            }
            if (!this.getObjectStorageService().isEmptyBucket(string)) {
                this.getObjectStorageService().deleteBucketAllPreviousVersions(string);
            }
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    @PostConstruct
    public void init() {
    }
}

