/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private final InputStream in;
    private long remaining;

    public LimitedInputStream(InputStream inputStream, long l) {
        this.in = inputStream;
        this.remaining = l;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            --this.remaining;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n3 = (int)Math.min((long)n2, this.remaining);
        int n4 = this.in.read(byArray, n, n3);
        if (n4 != -1) {
            this.remaining -= (long)n4;
        }
        return n4;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

