/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import io.odilon.api.BaseApiController;
import io.odilon.model.MetricsValues;
import io.odilon.model.SystemInfo;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import io.odilon.traffic.TrafficPass;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetricsController
extends BaseApiController {
    @Autowired
    private final ServerSettings serverSettings;

    @Autowired
    public MetricsController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, ServerSettings serverSettings) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService);
        this.serverSettings = serverSettings;
    }

    @RequestMapping(value={"/status"}, produces={"application/json"}, method={RequestMethod.GET})
    public Map<String, Object> getStatus() {
        Map map;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            map = this.serverSettings.toMap();
        }
        catch (Throwable throwable) {
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            throw throwable;
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return map;
    }

    @RequestMapping(value={"/systeminfo"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<SystemInfo> getSystemInfo() {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.objectStorageService.getSystemInfo());
        }
        catch (Throwable throwable) {
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            throw throwable;
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    @RequestMapping(value={"/metricscolloquial"}, produces={"text/plain"}, method={RequestMethod.GET})
    public ResponseEntity<String> getMetricsColloquial() {
        return this.getMetricsInformal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/metricsinformal"}, produces={"text/plain"}, method={RequestMethod.GET})
    public ResponseEntity<String> getMetricsInformal() {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            StringBuilder stringBuilder = new StringBuilder();
            MetricsValues metricsValues = this.getSystemMonitorService().getMetricsValues();
            stringBuilder.append("\n");
            stringBuilder.append("\n");
            for (String string3 : this.serverSettings.getAppCharacterName()) {
                stringBuilder.append("    " + string3 + "\n");
            }
            Map map = metricsValues.getColloquial();
            stringBuilder.append("\n");
            stringBuilder.append("\n");
            map.forEach((string, string2) -> stringBuilder.append("    " + string + " -> " + string2 + "\n\n"));
            stringBuilder.append("\n");
            stringBuilder.append("\n");
            responseEntity = new ResponseEntity((Object)stringBuilder.toString(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Throwable throwable) {
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            throw throwable;
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    @RequestMapping(value={"/metrics"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<MetricsValues> getMetrics() {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.getSystemMonitorService().getMetricsValues());
        }
        catch (Throwable throwable) {
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            throw throwable;
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }
}

