/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.api.BaseApiController;
import io.odilon.api.LimitedInputStream;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.error.OdilonServerAPIException;
import io.odilon.log.Logger;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.net.ErrorCode;
import io.odilon.net.ODHttpStatus;
import io.odilon.security.AuthToken;
import io.odilon.security.TokenService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import io.odilon.traffic.TrafficControlService;
import io.odilon.traffic.TrafficPass;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/presigned/object"})
public class ObjectControllerPresigned
extends BaseApiController {
    private static Logger logger = Logger.getLogger((String)ObjectControllerPresigned.class.getName());
    @JsonIgnore
    @Autowired
    private final TokenService tokenService;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;

    public ObjectControllerPresigned(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, TrafficControlService trafficControlService, TokenService tokenService, ServerSettings serverSettings) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService, trafficControlService);
        this.tokenService = tokenService;
        this.serverSettings = serverSettings;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<InputStreamResource> getPresignedObjectStream(@RequestParam(value="token") String string, @RequestHeader(value="Range", required=false) String string2) {
        ResponseEntity responseEntity;
        int n;
        long l;
        MediaType mediaType;
        HttpHeaders httpHeaders;
        InputStream inputStream;
        TrafficPass trafficPass;
        block16: {
            block15: {
                trafficPass = null;
                inputStream = null;
                trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
                if (string == null) {
                    throw new OdilonServerAPIException("token is null");
                }
                AuthToken authToken = this.getTokenService().decrypt(string);
                if (authToken == null) {
                    throw new OdilonServerAPIException(AuthToken.class.getSimpleName() + " is null");
                }
                if (!authToken.isValid()) {
                    logger.error(new String[]{String.format("token expired -> t: %s", authToken.toString())});
                    throw new OdilonServerAPIException(String.format("token expired -> t: %s", authToken.toString()));
                }
                String string3 = authToken.getBucketName();
                String string4 = authToken.getObjectName();
                VirtualFileSystemObject virtualFileSystemObject = this.getObjectStorageService().getObject(string3, string4);
                if (virtualFileSystemObject == null) {
                    throw new OdilonObjectNotFoundException(String.format("not found -> b: %s | o:%s", Optional.ofNullable(string3).orElse("null"), Optional.ofNullable(string4).orElse("null")));
                }
                httpHeaders = new HttpHeaders();
                String string5 = virtualFileSystemObject.getObjectMetadata().getFileName().replace("[", "").replace("]", "");
                httpHeaders.set("Content-Disposition", "inline; filename=\"" + string5 + "\"");
                if (virtualFileSystemObject.getObjectMetadata().getFileName() != null && virtualFileSystemObject.getObjectMetadata().getFileName().toLowerCase().endsWith(".svg")) {
                    virtualFileSystemObject.getObjectMetadata().setContentType("image/svg+xml");
                }
                mediaType = MediaType.valueOf((String)virtualFileSystemObject.getObjectMetadata().getContentType());
                if (virtualFileSystemObject.getObjectMetadata().contentType() == null || virtualFileSystemObject.getObjectMetadata().getContentType().equals("application/octet-stream")) {
                    mediaType = this.estimateContentType(string5);
                }
                logger.debug(virtualFileSystemObject.getObjectMetadata().getFileName() + " " + mediaType.toString());
                l = this.getSrcFileLength(virtualFileSystemObject.getObjectMetadata());
                inputStream = virtualFileSystemObject.getInputStream();
                this.getSystemMonitorService().getGetObjectMeter().mark();
                n = authToken.getObjectCacheDurationSecs() > 0 ? authToken.getObjectCacheDurationSecs() : this.getServerSettings().getserverObjectstreamCacheSecs();
                httpHeaders.set("Accept-Ranges", "bytes");
                if (string2 == null || !string2.startsWith("bytes=")) break block15;
                String[] stringArray = string2.substring(6).split("-");
                long l2 = Long.parseLong(stringArray[0]);
                long l3 = stringArray.length > 1 && !stringArray[1].isEmpty() ? Long.parseLong(stringArray[1]) : l - 1L;
                long l4 = l3 - l2 + 1L;
                inputStream.skip(l2);
                httpHeaders.setContentLength(l4);
                httpHeaders.add("Content-Range", "bytes " + l2 + "-" + l3 + "/" + l);
                ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.PARTIAL_CONTENT).headers(httpHeaders)).contentType(mediaType).contentLength(l4).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).body((Object)new InputStreamResource((InputStream)new LimitedInputStream(inputStream, l4)));
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                return responseEntity2;
            }
            httpHeaders.setContentLength(l);
            if (l != -1L) break block16;
            ResponseEntity responseEntity3 = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).contentType(mediaType).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).body((Object)new InputStreamResource(inputStream));
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            return responseEntity3;
        }
        try {
            responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).contentType(mediaType).contentLength(l).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).body((Object)new InputStreamResource(inputStream));
        }
        catch (Exception exception) {
            try {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                    }
                }
                throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    public TokenService getTokenService() {
        return this.tokenService;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }
}

