/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.cache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import io.odilon.cache.CacheEvent;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
@ThreadSafe
public class FileCacheService
extends BaseService
implements ApplicationListener<CacheEvent> {
    private static Logger logger = Logger.getLogger((String)FileCacheService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private AtomicLong cacheSizeBytes = new AtomicLong(0L);
    @JsonIgnore
    @Autowired
    private final LockService vfsLockService;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    private VirtualFileSystemService vfs;
    @JsonIgnore
    private List<Drive> listDrives;
    @JsonIgnore
    private Cache<String, File> cache;

    public FileCacheService(ServerSettings serverSettings, LockService lockService) {
        this.serverSettings = serverSettings;
        this.vfsLockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Long l, String string, Optional<Integer> optional) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + l.toString()));
        this.getLockService().getFileCacheLock(l, string, optional).readLock().lock();
        try {
            boolean bl = this.getCache().getIfPresent((Object)this.getKey(l, string, optional)) != null;
            return bl;
        }
        finally {
            this.getLockService().getFileCacheLock(l, string, optional).readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File get(Long l, String string, Optional<Integer> optional) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + l.toString()));
        this.getLockService().getFileCacheLock(l, string, optional).readLock().lock();
        try {
            File file;
            File file2 = file = (File)this.getCache().getIfPresent((Object)this.getKey(l, string, optional));
            return file2;
        }
        finally {
            this.getLockService().getFileCacheLock(l, string, optional).readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Long l, String string, Optional<Integer> optional, File file, boolean bl) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + l.toString()));
        Check.requireNonNullArgument((Object)file, (String)"file is null");
        if (bl) {
            this.getLockService().getFileCacheLock(l, string, optional).writeLock().lock();
        }
        try {
            this.getCache().put((Object)this.getKey(l, string, optional), (Object)file);
            this.cacheSizeBytes.getAndAdd(file.length());
        }
        finally {
            if (bl) {
                this.getLockService().getFileCacheLock(l, string, optional).writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Long l, String string, Optional<Integer> optional) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + l.toString()));
        this.getLockService().getFileCacheLock(l, string, optional).writeLock().lock();
        try {
            File file = (File)this.getCache().getIfPresent((Object)this.getKey(l, string, optional));
            this.getCache().invalidate((Object)this.getKey(l, string, optional));
            if (file != null) {
                FileUtils.deleteQuietly((File)file);
                this.cacheSizeBytes.getAndAdd(-file.length());
            }
        }
        finally {
            this.getLockService().getFileCacheLock(l, string, optional).writeLock().unlock();
        }
    }

    public String getFileCachePath(Long l, String string, Optional<Integer> optional) {
        String string2 = this.getKey(l, string, optional);
        return ((Drive)this.getDrivesAll().get(Math.abs(string2.hashCode()) % this.getDrivesAll().size())).getCacheDirPath() + File.separator + string2;
    }

    public long size() {
        return this.getCache().estimatedSize();
    }

    public long hardDiskUsage() {
        return this.cacheSizeBytes.get();
    }

    public synchronized void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        try {
            this.vfs = virtualFileSystemService;
        }
        finally {
            this.setStatus(ServiceStatus.RUNNING);
            startuplogger.debug("Started -> " + FileCacheService.class.getSimpleName());
        }
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        if (this.vfs == null) {
            logger.error(new String[]{"The instance of " + VirtualFileSystemService.class.getSimpleName() + " must be setted during the @PostConstruct method of the " + this.getClass().getName() + " instance. It can not be injected via AutoWired beacause of circular dependencies."});
            throw new IllegalStateException(VirtualFileSystemService.class.getSimpleName() + " instance is null. it must be setted during the @PostConstruct method of the " + this.getClass().getName() + " instance");
        }
        return this.vfs;
    }

    public LockService getLockService() {
        return this.vfsLockService;
    }

    public void onApplicationEvent(CacheEvent cacheEvent) {
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.CREATE_OBJECT) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.empty());
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.of(cacheEvent.getOperation().getVersion()));
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.UPDATE_OBJECT) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.empty());
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.of(cacheEvent.getOperation().getVersion()));
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.RESTORE_OBJECT_PREVIOUS_VERSION) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.empty());
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.of(cacheEvent.getOperation().getVersion()));
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.DELETE_OBJECT) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.empty());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.DELETE_OBJECT_PREVIOUS_VERSIONS) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.empty());
            if (this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                for (int i = 0; i < cacheEvent.getOperation().getVersion(); ++i) {
                    this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.of(i));
                }
            }
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.SYNC_OBJECT_NEW_DRIVE) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.empty());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.INTEGRITY_CHECK) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName(), Optional.empty());
            return;
        }
    }

    @PostConstruct
    protected synchronized void onInitialize() {
        this.setStatus(ServiceStatus.STARTING);
        this.cache = Caffeine.newBuilder().initialCapacity(this.getServerSettings().getFileCacheInitialCapacity()).maximumSize(this.getServerSettings().getFileCacheMaxCapacity()).expireAfterWrite(this.getServerSettings().getFileCacheDurationDays(), TimeUnit.DAYS).evictionListener((object, object2, removalCause) -> this.onRemoval(object, object2, removalCause)).removalListener((object, object2, removalCause) -> this.onRemoval(object, object2, removalCause)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRemoval(Object object, Object object2, RemovalCause removalCause) {
        if (removalCause.wasEvicted() && object != null && object2 != null) {
            String string = Pattern.quote(File.separator);
            String[] stringArray = ((String)object).split(string);
            String[] stringArray2 = stringArray[1].split("$");
            Long l = Long.valueOf(stringArray[0]);
            String string2 = stringArray2.length == 1 ? stringArray[1] : stringArray2[0];
            Optional optional = stringArray2.length == 1 ? Optional.empty() : Optional.of(Integer.valueOf(Integer.valueOf(stringArray2[1])));
            this.getLockService().getFileCacheLock(l, string2, optional).writeLock().lock();
            try {
                logger.debug("delete cached file -> b:" + l.toString() + " o:" + string2 + " v: " + String.valueOf(optional));
                FileUtils.deleteQuietly((File)((File)object2));
                this.cacheSizeBytes.getAndAdd(-((File)object2).length());
            }
            finally {
                this.getLockService().getFileCacheLock(l, string2, optional).writeLock().unlock();
            }
        }
    }

    private String getKey(Long l, String string, Optional<Integer> optional) {
        return l.toString() + File.separator + string + (String)(optional.isEmpty() ? "" : "$" + String.valueOf(optional.get()));
    }

    private synchronized List<Drive> getDrivesAll() {
        if (this.listDrives == null) {
            this.listDrives = new ArrayList(this.getVirtualFileSystemService().getMapDrivesAll().values());
        }
        this.listDrives.sort(new /* Unavailable Anonymous Inner Class!! */);
        return this.listDrives;
    }

    private Cache<String, File> getCache() {
        return this.cache;
    }

    private ServerSettings getServerSettings() {
        return this.serverSettings;
    }
}

