/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.cache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.odilon.cache.CacheEvent;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class ObjectMetadataCacheService
extends BaseService
implements ApplicationListener<CacheEvent> {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static Logger logger = Logger.getLogger((String)ObjectMetadataCacheService.class.getName());
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    private Cache<String, ObjectMetadata> cache;

    public ObjectMetadataCacheService(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public long size() {
        return this.getCache().estimatedSize();
    }

    public boolean containsKey(ServerBucket serverBucket, String string) {
        return this.getCache().getIfPresent((Object)this.getKey(serverBucket.getId(), string)) != null;
    }

    public ObjectMetadata get(ServerBucket serverBucket, String string) {
        return (ObjectMetadata)this.getCache().getIfPresent((Object)this.getKey(serverBucket.getId(), string));
    }

    public void put(ServerBucket serverBucket, String string, ObjectMetadata objectMetadata) {
        this.getCache().put((Object)this.getKey(serverBucket.getId(), string), (Object)objectMetadata);
    }

    public void remove(Long l, String string) {
        this.getCache().invalidate((Object)this.getKey(l, string));
    }

    public void onApplicationEvent(CacheEvent cacheEvent) {
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.CREATE_OBJECT) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.UPDATE_OBJECT) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.RESTORE_OBJECT_PREVIOUS_VERSION) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.DELETE_OBJECT) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.DELETE_OBJECT_PREVIOUS_VERSIONS) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.SYNC_OBJECT_NEW_DRIVE) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName());
            return;
        }
        if (cacheEvent.getOperation().getOperationCode() == OperationCode.INTEGRITY_CHECK) {
            this.remove(cacheEvent.getOperation().getBucketId(), cacheEvent.getOperation().getObjectName());
            return;
        }
    }

    @PostConstruct
    protected void onInitialize() {
        try {
            this.setStatus(ServiceStatus.STARTING);
            this.cache = Caffeine.newBuilder().initialCapacity(this.getServerSettings().getObjectCacheInitialCapacity()).maximumSize(this.getServerSettings().getObjectCacheCapacity()).expireAfterWrite(this.getServerSettings().getObjectCacheExpireDays(), TimeUnit.DAYS).build();
        }
        finally {
            this.setStatus(ServiceStatus.RUNNING);
            startuplogger.debug("Started -> " + ObjectMetadataCacheService.class.getSimpleName());
        }
    }

    private String getKey(Long l, String string) {
        return l.toString() + File.separator + string;
    }

    private Cache<String, ObjectMetadata> getCache() {
        return this.cache;
    }

    private ServerSettings getServerSettings() {
        return this.serverSettings;
    }
}

