/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import io.odilon.encryption.CountingInputStream;
import java.io.InputStream;

public class EncryptedResult {
    private final InputStream inputStream;
    private final boolean totalLengthKnown;
    private final long totalLength;
    private final CountingInputStream countingStream;

    public EncryptedResult(InputStream inputStream, long l) {
        this.inputStream = inputStream;
        this.totalLengthKnown = true;
        this.totalLength = l;
        this.countingStream = null;
    }

    public EncryptedResult(InputStream inputStream, CountingInputStream countingInputStream) {
        this.inputStream = inputStream;
        this.totalLengthKnown = false;
        this.totalLength = -1L;
        this.countingStream = countingInputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean isTotalLengthKnown() {
        return this.totalLengthKnown;
    }

    public long getTotalLengthIfKnown() {
        if (!this.totalLengthKnown) {
            throw new IllegalStateException("Total length not known up front");
        }
        return this.totalLength;
    }

    public CountingInputStream getCountingStream() {
        if (this.countingStream == null) {
            throw new IllegalStateException("Counting stream not available");
        }
        return this.countingStream;
    }
}

