/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.encryption.CountingInputStream;
import io.odilon.encryption.EncryptedInputStream;
import io.odilon.encryption.EncryptedResult;
import io.odilon.encryption.EncryptionService;
import io.odilon.encryption.JCipherStreamEncryptor;
import io.odilon.encryption.KeyEncriptorWrapper;
import io.odilon.encryption.KeyEncryptor;
import io.odilon.encryption.StreamEncryptor;
import io.odilon.encryption.StreamEncryptorInfo;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OdilonEncryptionService
extends BaseService
implements EncryptionService {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    @Autowired
    private final SystemMonitorService monitoringService;
    @JsonIgnore
    @Autowired
    private final KeyEncriptorWrapper odilonKeyEncriptorWrapper;

    public OdilonEncryptionService(ServerSettings serverSettings, SystemMonitorService systemMonitorService, KeyEncriptorWrapper keyEncriptorWrapper) {
        this.serverSettings = serverSettings;
        this.monitoringService = systemMonitorService;
        this.odilonKeyEncriptorWrapper = keyEncriptorWrapper;
    }

    public EncryptedResult encryptStream(InputStream inputStream) {
        try {
            JCipherStreamEncryptor jCipherStreamEncryptor = new JCipherStreamEncryptor("AES/GCM/NoPadding", "AES", (KeyEncryptor)this.odilonKeyEncriptorWrapper);
            String string = jCipherStreamEncryptor.getNewKey();
            String string2 = jCipherStreamEncryptor.getIV();
            CountingInputStream countingInputStream = new CountingInputStream(inputStream);
            EncryptedInputStream encryptedInputStream = jCipherStreamEncryptor.encrypt((InputStream)countingInputStream, string, string2);
            String string3 = this.getObjectMapper().writeValueAsString((Object)encryptedInputStream.getStreamEncryptorInfo());
            byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, (InputStream)encryptedInputStream);
            this.getSystemMonitorService().getEncrpytFileMeter().mark();
            return new EncryptedResult((InputStream)sequenceInputStream, countingInputStream);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "encryptStream");
        }
    }

    public InputStream decryptStream(InputStream inputStream) {
        try {
            MappingJsonFactory mappingJsonFactory = new MappingJsonFactory();
            mappingJsonFactory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            JsonParser jsonParser = mappingJsonFactory.createParser(inputStream);
            String string = jsonParser.readValueAsTree().toString();
            StreamEncryptorInfo streamEncryptorInfo = (StreamEncryptorInfo)new ObjectMapper().readValue(string, StreamEncryptorInfo.class);
            String string2 = streamEncryptorInfo.getEncryptedKey();
            String string3 = streamEncryptorInfo.getIV();
            StreamEncryptor streamEncryptor = streamEncryptorInfo.getStreamEncryption();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            jsonParser.releaseBuffered((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream);
            this.getSystemMonitorService().getDecryptFileMeter().mark();
            return streamEncryptor.decrypt((InputStream)sequenceInputStream, string2, string3);
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, "decryptStream");
        }
    }

    public SystemMonitorService getSystemMonitorService() {
        return this.monitoringService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        OdilonEncryptionService odilonEncryptionService = this;
        synchronized (odilonEncryptionService) {
            this.setStatus(ServiceStatus.STARTING);
            startuplogger.debug("Started -> " + EncryptionService.class.getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }

    public EncryptedResult encryptStream(InputStream inputStream, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("plainSize must be >= 0");
        }
        try {
            JCipherStreamEncryptor jCipherStreamEncryptor = new JCipherStreamEncryptor("AES/GCM/NoPadding", "AES", (KeyEncryptor)this.odilonKeyEncriptorWrapper);
            String string = jCipherStreamEncryptor.getNewKey();
            String string2 = jCipherStreamEncryptor.getIV();
            EncryptedInputStream encryptedInputStream = jCipherStreamEncryptor.encrypt(inputStream, string, string2);
            String string3 = this.getObjectMapper().writeValueAsString((Object)jCipherStreamEncryptor.getStreamEncryptionInfo(string, string2));
            byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, (InputStream)encryptedInputStream);
            this.getSystemMonitorService().getEncrpytFileMeter().mark();
            return new EncryptedResult((InputStream)sequenceInputStream, l);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "encryptStream");
        }
    }
}

