/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.encryption.KeyEncryptor;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.security.VaultService;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VaultKeyEncryptorService
extends BaseService
implements KeyEncryptor {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonProperty(value="keyId")
    private String keyID;
    @Autowired
    @JsonIgnore
    private VaultService vaultService;
    @Autowired
    @JsonIgnore
    ServerSettings serverSettings;

    public VaultKeyEncryptorService(VaultService vaultService, ServerSettings serverSettings) {
        this.vaultService = vaultService;
        this.serverSettings = serverSettings;
    }

    public byte[] encryptKey(byte[] byArray) {
        return this.getVaultService().encrypt(this.getKeyID(), Base64.getEncoder().encodeToString(byArray)).getBytes(StandardCharsets.UTF_8);
    }

    public byte[] decryptKey(byte[] byArray) {
        return Base64.getDecoder().decode(this.getVaultService().decrypt(this.getKeyID(), new String(byArray, StandardCharsets.UTF_8)));
    }

    public byte[] encryptKey(byte[] byArray, byte[] byArray2) {
        return this.encryptKey(byArray);
    }

    public byte[] decryptKey(byte[] byArray, byte[] byArray2) {
        return this.decryptKey(byArray);
    }

    public String getKeyID() {
        return this.keyID;
    }

    public void setKeyID(String string) {
        this.keyID = string;
    }

    public VaultService getVaultService() {
        return this.vaultService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        VaultKeyEncryptorService vaultKeyEncryptorService = this;
        synchronized (vaultKeyEncryptorService) {
            this.setStatus(ServiceStatus.STARTING);
            this.keyID = "transit/" + this.serverSettings.getVaultKeyId();
            startuplogger.debug("Started -> " + VaultKeyEncryptorService.class.getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }
}

