/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.file;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.file.FileCopyAgent;
import io.odilon.log.Logger;
import io.odilon.util.Check;
import io.odilon.util.DateTimeUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ParallelFileCoypAgent
extends FileCopyAgent {
    private static Logger logger = Logger.getLogger((String)ParallelFileCoypAgent.class.getName());
    @JsonIgnore
    private final byte[][] source;
    @JsonIgnore
    private final List<File> destination;
    @JsonIgnore
    private final Boolean[] requiresCopy;
    @JsonIgnore
    private ExecutorService executor;
    @JsonIgnore
    private OffsetDateTime start;
    @JsonIgnore
    private OffsetDateTime end;

    public ParallelFileCoypAgent(byte[][] byArray, List<File> list, Boolean[] booleanArray) {
        Check.requireNonNull((Object)byArray);
        Check.requireNonNull(list);
        Check.requireTrue((booleanArray.length == byArray.length ? 1 : 0) != 0, (String)"Error not true -> requiresCopy.length == source.length");
        Check.requireTrue((byArray.length >= list.size() ? 1 : 0) != 0, (String)"Error not true -> source.length >= destination.size()");
        if (logger.isDebugEnabled()) {
            int n = 0;
            for (int i = 0; i < booleanArray.length; ++i) {
                if (!booleanArray[i].booleanValue()) continue;
                ++n;
            }
            Check.requireTrue((n == list.size() ? 1 : 0) != 0, (String)"Error toCopy must be equal to destination.size()");
        }
        this.source = byArray;
        this.destination = list;
        this.requiresCopy = booleanArray;
    }

    public long durationMillisecs() {
        if (this.getStart() == null || this.getEnd() == null) {
            return -1L;
        }
        return DateTimeUtil.dateTimeDifference((Temporal)this.getStart(), (Temporal)this.getEnd(), (ChronoUnit)ChronoUnit.MILLIS);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executorService) {
        this.executor = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        int n;
        try {
            boolean bl;
            this.setStart(OffsetDateTime.now());
            int n2 = this.getDestination().size();
            n = this.source.length;
            if (this.getExecutor() == null) {
                this.setExecutor(Executors.newFixedThreadPool(n2));
            }
            ArrayList<Callable<Boolean>> arrayList = new ArrayList<Callable<Boolean>>(n2);
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                if (!this.requiresCopy[i].booleanValue()) continue;
                int n3 = i;
                bl = bl2++;
                arrayList.add(() -> this.lambda$execute$0((int)(bl ? 1 : 0), n3));
            }
            try {
                List list = this.getExecutor().invokeAll(arrayList, 15L, TimeUnit.MINUTES);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (((Boolean)iterator.next().get()).booleanValue()) continue;
                    bl = false;
                    return bl;
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            n = 0;
            return n != 0;
        }
        finally {
            this.setEnd(OffsetDateTime.now());
        }
    }

    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime offsetDateTime) {
        this.start = offsetDateTime;
    }

    public OffsetDateTime getEnd() {
        return this.end;
    }

    public void setEnd(OffsetDateTime offsetDateTime) {
        this.end = offsetDateTime;
    }

    public byte[][] getSource() {
        return this.source;
    }

    public List<File> getDestination() {
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Boolean lambda$execute$0(int n, int n2) throws Exception {
        try {
            Object object;
            File file = (File)this.getDestination().get(n);
            try {
                object = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    ((OutputStream)object).write(this.source[n2]);
                }
                finally {
                    ((OutputStream)object).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InternalCriticalException((Exception)fileNotFoundException, "f: " + file.getName());
            }
            catch (IOException iOException) {
                throw new InternalCriticalException((Exception)iOException, "f: " + file.getName());
            }
            object = true;
            return object;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            Boolean bl = false;
            return bl;
        }
    }
}

