/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.monitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.replication.ReplicationService;
import io.odilon.service.BaseService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class PingService
extends BaseService
implements ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)PingService.class.getName());
    static final int defaultThreshold = Runtime.getRuntime().availableProcessors() + 2;
    @JsonIgnore
    private ApplicationContext applicationContext;
    @JsonIgnore
    private OffsetDateTime lastVaultReconnect = OffsetDateTime.now();

    public synchronized List<String> pingList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ReplicationService replicationService;
            String string;
            String string2 = this.pingCPULoad();
            if (string2 == null || !string2.equals("ok")) {
                arrayList.add(string2 == null ? "cpu load null" : string2);
            }
            if ((string2 = ((ObjectStorageService)this.getApplicationContext().getBean(ObjectStorageService.class)).ping()) == null || !string2.equals("ok")) {
                arrayList.add(string2 == null ? "null" : string2);
            }
            if ((string2 = (ServerSettings)this.getApplicationContext().getBean(ServerSettings.class)).isStandByEnabled() && ((string = (replicationService = (ReplicationService)this.getApplicationContext().getBean(ReplicationService.class)).ping()) == null || !string.equals("ok"))) {
                arrayList.add(string == null ? "replication ping null" : string);
            }
        }
        catch (Throwable throwable) {
            logger.error(throwable, new String[]{"---- not thrown ----"});
            arrayList.add(throwable.getClass().getName() + " | " + throwable.getMessage());
        }
        return arrayList;
    }

    public String pingString() {
        try {
            List list = this.pingList();
            String string2 = list.stream().map(string -> string).collect(Collectors.joining(" | "));
            return string2 == null || string2.length() == 0 ? "ok" : string2;
        }
        catch (Exception exception) {
            return exception.getClass().getName() + " | pingString";
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private String pingCPULoad() {
        Double d;
        int n = Runtime.getRuntime().availableProcessors();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        double d2 = operatingSystemMXBean.getSystemLoadAverage();
        if (n > 0 && d2 > 0.0 && (d = Double.valueOf(Double.valueOf(d2) / Double.valueOf(n))) > (double)defaultThreshold) {
            return "CPU load -> " + String.format("%6.2f", d * 100.0) + "%";
        }
        return "ok";
    }
}

