/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.query.BucketIteratorService;
import io.odilon.service.BaseService;
import io.odilon.service.Timer;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.BucketIterator;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Service;

@Service
public class OdilonBucketIteratorService
extends BaseService
implements BucketIteratorService {
    private static Logger logger = Logger.getLogger((String)OdilonBucketIteratorService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    private Timer cleaner;
    @JsonIgnore
    private ConcurrentMap<String, BucketIterator> walkers = new ConcurrentHashMap();
    @JsonIgnore
    private ConcurrentMap<String, OffsetDateTime> lastAccess = new ConcurrentHashMap();

    public boolean exists(String string) {
        Check.requireNonNullArgument((Object)string, (String)"agentId can not be null");
        return this.getWalkers().keySet().contains(string);
    }

    public synchronized BucketIterator get(String string) {
        Check.requireNonNullArgument((Object)string, (String)"agentId can not be null");
        if (this.getWalkers().keySet().contains(string)) {
            this.lastAccess.put(string, OffsetDateTime.now());
            return (BucketIterator)this.getWalkers().get(string);
        }
        return null;
    }

    public synchronized String register(BucketIterator bucketIterator) {
        Check.requireNonNullArgument((Object)bucketIterator, (String)"walker can not be null");
        String string = this.newAgentId();
        bucketIterator.setAgentId(string);
        this.getWalkers().put(string, bucketIterator);
        this.lastAccess.put(string, OffsetDateTime.now());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String string) {
        if (string == null) {
            return;
        }
        BucketIterator bucketIterator = null;
        try {
            this.lastAccess.remove(string);
            bucketIterator = (BucketIterator)this.getWalkers().get(string);
            this.getWalkers().remove(string);
        }
        finally {
            if (bucketIterator != null) {
                try {
                    bucketIterator.close();
                }
                catch (IOException iOException) {
                    throw new InternalCriticalException((Exception)iOException, "remove -> " + string);
                }
            }
        }
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        if (this.virtualFileSystemService == null) {
            throw new IllegalStateException("The member of " + VirtualFileSystemService.class.getName() + " must be asigned during the @PostConstruct method of the " + VirtualFileSystemService.class.getName() + " instance. It can not be injected via AutoWired beacause of circular dependencies.");
        }
        return this.virtualFileSystemService;
    }

    public void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public ConcurrentMap<String, BucketIterator> getWalkers() {
        return this.walkers;
    }

    public void setWalkers(ConcurrentMap<String, BucketIterator> concurrentMap) {
        this.walkers = concurrentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        OdilonBucketIteratorService odilonBucketIteratorService = this;
        synchronized (odilonBucketIteratorService) {
            try {
                this.setStatus(ServiceStatus.STARTING);
                this.cleaner = new /* Unavailable Anonymous Inner Class!! */;
                Thread thread = new Thread((Runnable)this.cleaner);
                thread.setDaemon(true);
                thread.setName(BucketIteratorService.class.getSimpleName() + "Cleaner-" + Double.valueOf(Math.abs(Math.random() * 1000000.0)).intValue());
                thread.start();
                startuplogger.debug("Started -> " + BucketIteratorService.class.getSimpleName());
                this.setStatus(ServiceStatus.RUNNING);
            }
            catch (Exception exception) {
                this.setStatus(ServiceStatus.STOPPED);
                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                throw exception;
            }
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.cleaner.sendExitSignal();
    }

    private String newAgentId() {
        return System.currentTimeMillis() + "-" + String.valueOf(Double.valueOf(Math.abs(Math.random() * 1000000.0)).intValue());
    }
}

