/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.replication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.client.ODClient;
import io.odilon.client.OdilonClient;
import io.odilon.client.error.ODClientException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.ServiceStatus;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.replication.ReplicationService;
import io.odilon.replication.StandByInitialSync;
import io.odilon.scheduler.SchedulerService;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.scheduler.StandByReplicaServiceRequest;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.OdilonJournalService;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class ReplicationService
extends BaseService
implements ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)ReplicationService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    static final int MAX_WAIT_FOR_COMMIT_MS = 15000;
    @JsonIgnore
    private OdilonClient client;
    @JsonIgnore
    private String accessKey;
    @JsonIgnore
    private String secretKey;
    @JsonIgnore
    private String url;
    @JsonIgnore
    private int port;
    @JsonIgnore
    private AtomicBoolean initialSync = new AtomicBoolean(false);
    @Autowired
    @JsonIgnore
    private final SystemMonitorService monitoringService;
    @Autowired
    @JsonIgnore
    private volatile ApplicationContext applicationContext;
    @Autowired
    @JsonIgnore
    private final ServerSettings serverSettings;
    @Autowired
    @JsonIgnore
    private final LockService vfsLockService;
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;
    @Autowired
    @JsonIgnore
    private final SchedulerService schedulerService;

    public ReplicationService(ServerSettings serverSettings, SystemMonitorService systemMonitorService, LockService lockService, SchedulerService schedulerService) {
        this.vfsLockService = lockService;
        this.serverSettings = serverSettings;
        this.monitoringService = systemMonitorService;
        this.schedulerService = schedulerService;
    }

    public synchronized void checkStructure() {
        List list;
        if (!this.getServerSettings().isStandByEnabled()) {
            return;
        }
        if (this.getServerSettings().getServerMode().equals("standby")) {
            return;
        }
        Check.checkTrue((this.getClient() != null ? 1 : 0) != 0, (String)"There is no standby connection");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        try {
            list = this.getClient().listBuckets();
            list.forEach(bucket -> arrayList.add(bucket.getName()));
        }
        catch (ODClientException oDClientException) {
            throw new InternalCriticalException((Exception)((Object)oDClientException), "checkStructure");
        }
        List list2 = this.getVirtualFileSystemService().listAllBuckets();
        list2.forEach(serverBucket -> arrayList2.add(serverBucket.getName()));
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        list2.forEach(serverBucket -> {
            if (!arrayList.contains(serverBucket.getName())) {
                arrayList3.add(serverBucket.getName());
            }
        });
        list.forEach(bucket -> {
            if (!arrayList2.contains(bucket.getName())) {
                arrayList4.add(bucket.getName());
            }
        });
        arrayList4.forEach(string -> {
            try {
                logger.debug("removing standby bucket -> " + string);
                this.getClient().deleteBucket(string);
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, "removing standby bucket -> " + string);
            }
        });
        arrayList3.forEach(string -> {
            try {
                logger.debug("creating standby bucket -> " + string);
                this.getClient().createBucket(string);
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, "creating standby bucket -> " + string);
            }
        });
        this.initialSync();
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public boolean isStandByEnabled() {
        return this.getServerSettings().isStandByEnabled();
    }

    public String ping() {
        if (!this.getServerSettings().isStandByEnabled()) {
            return "ok";
        }
        if (this.getClient() == null) {
            return "client is null";
        }
        return this.getClient().ping();
    }

    public String getStandByConnection() {
        return this.url + ":" + String.valueOf(this.port);
    }

    public String pingStandBy() {
        if (this.getServerSettings().isStandByEnabled()) {
            try {
                return this.getClient().ping();
            }
            catch (Exception exception) {
                return exception.getClass().getName() + " | " + exception.getMessage();
            }
        }
        return "";
    }

    public void enqueue(VirtualFileSystemOperation virtualFileSystemOperation) {
        switch (1.$SwitchMap$io$odilon$virtualFileSystem$model$OperationCode[virtualFileSystemOperation.getOperationCode().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.getSchedulerService().enqueue((ServiceRequest)this.getApplicationContext().getBean(StandByReplicaServiceRequest.class, new Object[]{virtualFileSystemOperation}));
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                try {
                    logger.error(new String[]{virtualFileSystemOperation.getOperationCode().toString() + " -> not recognized | ---- not thrown ----"});
                    break;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                }
            }
        }
    }

    public void cancel(VirtualFileSystemOperation virtualFileSystemOperation) {
        if (virtualFileSystemOperation.isReplicates()) {
            this.getSchedulerService().cancel((Serializable)((Object)virtualFileSystemOperation.getId()));
        }
    }

    public void replicate(VirtualFileSystemOperation virtualFileSystemOperation) {
        boolean bl;
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        Check.requireTrue((this.client != null ? 1 : 0) != 0, (String)("There is no standby connection (" + this.url + ":" + this.port + ")"));
        OdilonJournalService odilonJournalService = (OdilonJournalService)this.getVirtualFileSystemService().getJournalService();
        boolean bl2 = odilonJournalService.isExecuting(virtualFileSystemOperation.getId());
        boolean bl3 = odilonJournalService.isAborted(virtualFileSystemOperation.getId());
        boolean bl4 = !bl2 && !bl3;
        boolean bl5 = false;
        long l = System.currentTimeMillis();
        boolean bl6 = bl = bl4 || bl3 || bl5;
        while (!bl) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl2 = odilonJournalService.isExecuting(virtualFileSystemOperation.getId());
            bl3 = odilonJournalService.isAborted(virtualFileSystemOperation.getId());
            bl4 = !bl2 && !bl3;
            bl5 = System.currentTimeMillis() - l > 15000L;
            bl = bl4 || bl3 || bl5;
        }
        if (bl3) {
            odilonJournalService.removeAborted(virtualFileSystemOperation.getId());
            return;
        }
        if (bl2) {
            throw new InternalCriticalException(JournalService.class.getName() + " still executing on opx after " + (System.currentTimeMillis() - l) + " ms -> " + virtualFileSystemOperation.toString());
        }
        logger.debug(virtualFileSystemOperation.getOperationCode().getName() + " " + (String)(virtualFileSystemOperation.getBucketId() != null ? " b:" + virtualFileSystemOperation.getBucketId() : "") + (String)(virtualFileSystemOperation.getBucketName() != null ? " bn:" + virtualFileSystemOperation.getBucketName() : "") + (String)(virtualFileSystemOperation.getObjectName() != null ? " o:" + virtualFileSystemOperation.getObjectName() : ""));
        switch (1.$SwitchMap$io$odilon$virtualFileSystem$model$OperationCode[virtualFileSystemOperation.getOperationCode().ordinal()]) {
            case 1: {
                this.replicateCreateBucket(virtualFileSystemOperation);
                break;
            }
            case 2: {
                this.replicateRenameBucket(virtualFileSystemOperation);
                break;
            }
            case 3: {
                this.replicateDeleteBucket(virtualFileSystemOperation);
                break;
            }
            case 4: {
                this.replicateCreateObject(virtualFileSystemOperation);
                break;
            }
            case 5: {
                this.replicateUpdateObject(virtualFileSystemOperation);
                break;
            }
            case 6: {
                this.replicateDeleteObject(virtualFileSystemOperation);
                break;
            }
            case 8: {
                this.replicateRestoreObjectPreviousVersion(virtualFileSystemOperation);
                break;
            }
            case 7: {
                this.replicateDeleteObjectPreviousVersion(virtualFileSystemOperation);
                break;
            }
            case 10: {
                logger.debug("server metadata belongs to the particular server. It is not replicated -> " + virtualFileSystemOperation.toString());
                break;
            }
            case 9: {
                logger.debug("object metadata belongs to the particular server. It is not replicated -> " + virtualFileSystemOperation.toString());
                break;
            }
            case 11: {
                logger.debug("server metadata belongs to the particular server. It is not replicated -> " + virtualFileSystemOperation.toString());
                break;
            }
            default: {
                logger.error(new String[]{virtualFileSystemOperation.getOperationCode().toString() + " -> not recognized"});
            }
        }
    }

    public LockService getLockService() {
        return this.vfsLockService;
    }

    public AtomicBoolean isInitialSync() {
        return this.initialSync;
    }

    public void setInitialSync(AtomicBoolean atomicBoolean) {
        this.initialSync = atomicBoolean;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        if (this.virtualFileSystemService == null) {
            throw new IllegalStateException("The " + VirtualFileSystemService.class.getName() + " must be setted during the @PostConstruct method of the " + VirtualFileSystemService.class.getName() + " instance. It can not be injected via AutoWired beacause of circular dependencies.");
        }
        return this.virtualFileSystemService;
    }

    public synchronized void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public SystemMonitorService getMonitoringService() {
        return this.monitoringService;
    }

    public boolean isVersionControl() {
        try {
            return this.getClient().isVersionControl();
        }
        catch (ODClientException oDClientException) {
            throw new InternalCriticalException((Exception)((Object)oDClientException));
        }
    }

    protected OdilonClient getClient() {
        return this.client;
    }

    protected SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateCreateObject(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().lock();
        try {
            this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().lock();
            try {
                ServerBucket serverBucket = this.getVirtualFileSystemService().getBucketCache().get(virtualFileSystemOperation.getBucketId());
                if (serverBucket == null || !this.getVirtualFileSystemService().existsObject(serverBucket, virtualFileSystemOperation.getObjectName())) {
                    return;
                }
                ObjectMetadata objectMetadata = this.getVirtualFileSystemService().getObjectMetadata(serverBucket, virtualFileSystemOperation.getObjectName());
                try {
                    InputStream inputStream = this.getVirtualFileSystemService().getObjectStream(serverBucket.getName(), virtualFileSystemOperation.getObjectName());
                    ((ODClient)this.getClient()).putReplicateObjectStream(serverBucket.getName(), virtualFileSystemOperation.getObjectName(), inputStream, Optional.ofNullable(objectMetadata.getFileName()), Optional.empty(), Optional.empty(), Optional.ofNullable(objectMetadata.getCustomTags()));
                    this.getMonitoringService().getReplicationObjectCreateCounter().inc();
                }
                catch (IOException iOException) {
                    throw new InternalCriticalException((Exception)iOException, virtualFileSystemOperation.toString());
                }
            }
            catch (ODClientException oDClientException) {
                logger.debug((Throwable)oDClientException, new String[]{virtualFileSystemOperation.toString()});
                throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
            }
            finally {
                this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().unlock();
            }
        }
        finally {
            this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateUpdateObject(VirtualFileSystemOperation virtualFileSystemOperation) {
        block13: {
            Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
            this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().lock();
            try {
                this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().lock();
                try {
                    ServerBucket serverBucket = this.getVirtualFileSystemService().getBucketCache().get(virtualFileSystemOperation.getBucketId());
                    ObjectMetadata objectMetadata = this.getVirtualFileSystemService().getObjectMetadata(serverBucket, virtualFileSystemOperation.getObjectName());
                    if (objectMetadata == null || objectMetadata.getVersion() < virtualFileSystemOperation.getVersion()) {
                        return;
                    }
                    if (!this.getVirtualFileSystemService().existsObject(serverBucket, virtualFileSystemOperation.getObjectName())) break block13;
                    ObjectMetadata objectMetadata2 = this.getVirtualFileSystemService().getObjectMetadata(serverBucket, virtualFileSystemOperation.getObjectName());
                    try {
                        ((ODClient)this.getClient()).putReplicateObjectStream(serverBucket.getName(), virtualFileSystemOperation.getObjectName(), this.getVirtualFileSystemService().getObjectStream(serverBucket.getName(), virtualFileSystemOperation.getObjectName()), Optional.ofNullable(objectMetadata2.getFileName()), Optional.empty(), Optional.empty(), Optional.ofNullable(objectMetadata2.getCustomTags()));
                        this.getMonitoringService().getReplicationObjectUpdateCounter().inc();
                    }
                    catch (IOException iOException) {
                        throw new InternalCriticalException((Exception)iOException, virtualFileSystemOperation.toString());
                    }
                }
                catch (ODClientException oDClientException) {
                    logger.error((Throwable)oDClientException);
                    throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
                }
                finally {
                    this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().unlock();
                }
            }
            finally {
                this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateDeleteObject(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().lock();
        try {
            this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().lock();
            try {
                ServerBucket serverBucket = this.getVirtualFileSystemService().getBucketCache().get(virtualFileSystemOperation.getBucketId());
                if (this.getVirtualFileSystemService().existsObject(serverBucket, virtualFileSystemOperation.getObjectName())) {
                    return;
                }
                if (this.getClient().existsObject(serverBucket.getName(), virtualFileSystemOperation.getObjectName())) {
                    this.getClient().deleteObject(serverBucket.getName(), virtualFileSystemOperation.getObjectName());
                    this.getMonitoringService().getReplicationObjectDeleteCounter().inc();
                }
            }
            catch (IOException iOException) {
                throw new InternalCriticalException((Exception)iOException, virtualFileSystemOperation.toString());
            }
            catch (ODClientException oDClientException) {
                throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
            }
            finally {
                this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().unlock();
            }
        }
        finally {
            this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateDeleteObjectPreviousVersion(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        try {
            if (!this.getClient().isVersionControl()) {
                return;
            }
        }
        catch (ODClientException oDClientException) {
            throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
        }
        this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().lock();
        try {
            this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().lock();
            try {
                ServerBucket serverBucket = this.getVirtualFileSystemService().getBucketCache().get(virtualFileSystemOperation.getBucketId());
                this.getClient().deleteObjectAllVersions(serverBucket.getName(), virtualFileSystemOperation.getObjectName());
                this.getMonitoringService().getReplicaDeleteObjectAllVersionsCounter().inc();
            }
            catch (ODClientException oDClientException) {
                throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
            }
            finally {
                this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().unlock();
            }
        }
        finally {
            this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateRestoreObjectPreviousVersion(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        try {
            if (!this.getClient().isVersionControl()) {
                return;
            }
        }
        catch (ODClientException oDClientException) {
            throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
        }
        this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().lock();
        try {
            this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().lock();
            try {
                ServerBucket serverBucket = this.getVirtualFileSystemService().getBucketCache().get(virtualFileSystemOperation.getBucketId());
                this.getClient().restoreObjectPreviousVersions(serverBucket.getName(), virtualFileSystemOperation.getObjectName());
                this.getMonitoringService().getReplicaRestoreObjectPreviousVersionCounter().inc();
            }
            catch (ODClientException oDClientException) {
                throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
            }
            finally {
                this.getLockService().getBucketLock(virtualFileSystemOperation.getBucketId()).readLock().unlock();
            }
        }
        finally {
            this.getLockService().getObjectLock(virtualFileSystemOperation.getBucketId(), virtualFileSystemOperation.getObjectName()).readLock().unlock();
        }
    }

    private void replicateCreateBucket(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        try {
            if (!this.getClient().existsBucket(virtualFileSystemOperation.getBucketName())) {
                logger.debug("create b: " + virtualFileSystemOperation.getBucketName());
                this.getClient().createBucket(virtualFileSystemOperation.getBucketName());
            }
        }
        catch (ODClientException oDClientException) {
            throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
        }
    }

    private void replicateDeleteBucket(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        try {
            logger.debug("delete b: " + virtualFileSystemOperation.getBucketName());
            this.getClient().deleteBucket(virtualFileSystemOperation.getBucketName());
        }
        catch (ODClientException oDClientException) {
            throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
        }
    }

    private void replicateRenameBucket(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        try {
            if (!this.getClient().existsBucket(virtualFileSystemOperation.getBucketName())) {
                throw new InternalCriticalException("bucket does not exist in Standby -> " + this.getClient().getSchemaAndHost());
            }
            logger.debug("rename b: " + virtualFileSystemOperation.getBucketName() + " -> " + virtualFileSystemOperation.getObjectName());
            this.getClient().renameBucket(virtualFileSystemOperation.getBucketName(), virtualFileSystemOperation.getObjectName());
        }
        catch (ODClientException oDClientException) {
            throw new InternalCriticalException((Exception)((Object)oDClientException), virtualFileSystemOperation.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        ReplicationService replicationService = this;
        synchronized (replicationService) {
            try {
                this.setStatus(ServiceStatus.STARTING);
                startuplogger.debug("Started -> " + this.getClass().getSimpleName());
                this.accessKey = this.serverSettings.getStandbyAccessKey();
                this.secretKey = this.serverSettings.getStandbySecretKey();
                this.url = this.serverSettings.getStandbyUrl();
                this.port = this.serverSettings.getStandbyPort();
                if (this.serverSettings.isStandByEnabled()) {
                    this.client = new ODClient(this.url, this.port, this.accessKey, this.secretKey);
                    String string = this.client.ping();
                    if (!string.equals("ok")) {
                        logger.error(new String[]{"---------------------------------"});
                        logger.error(new String[]{"Standby connection not available -> " + string});
                        logger.error(new String[]{"---------------------------------"});
                        startuplogger.error(new String[]{string});
                    }
                }
                this.setStatus(ServiceStatus.RUNNING);
            }
            catch (Exception exception) {
                this.setStatus(ServiceStatus.STOPPED);
                throw exception;
            }
        }
    }

    private void initialSync() {
        if (!this.getServerSettings().isStandByEnabled()) {
            return;
        }
        if (this.getServerSettings().getServerMode().equals("standby")) {
            return;
        }
        OdilonServerInfo odilonServerInfo = this.getVirtualFileSystemService().getOdilonServerInfo();
        if (odilonServerInfo.getStandByStartDate() == null) {
            return;
        }
        int n = this.getSchedulerService().getReplicaQueueSize();
        if (!this.getServerSettings().isStandbySyncForce() && odilonServerInfo.getStandBySyncedDate() != null && !odilonServerInfo.getStandBySyncedDate().isBefore(odilonServerInfo.getStandByStartDate()) && n == 0) {
            startuplogger.info("Standby sync is up to date");
            return;
        }
        if (n > 0) {
            startuplogger.info("Replica pending queue size -> " + String.valueOf(n));
        }
        startuplogger.info("Starting sync up to -> " + odilonServerInfo.getStandByStartDate().toString());
        StandByInitialSync standByInitialSync = new StandByInitialSync(this.getVirtualFileSystemService().createVFSIODriver());
        standByInitialSync.start();
    }
}

