/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.scheduler.StandardServiceRequest;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="afterUpdateObject")
public class AfterUpdateObjectServiceRequest
extends AbstractServiceRequest
implements StandardServiceRequest {
    private static Logger logger = Logger.getLogger((String)AfterUpdateObjectServiceRequest.class.getName());
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="bucketName")
    String bucketName;
    @JsonProperty(value="objectName")
    String objectName;
    @JsonIgnore
    private boolean isSuccess = false;

    protected AfterUpdateObjectServiceRequest() {
    }

    public AfterUpdateObjectServiceRequest(String string, String string2) {
        this.bucketName = string;
        this.objectName = string2;
    }

    public String getUUID() {
        return (this.bucketName != null ? this.bucketName : "null") + ":" + (this.objectName != null ? this.objectName : "null");
    }

    public boolean isObjectOperation() {
        return true;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void execute() {
        try {
            this.setStatus(ServiceRequestStatus.RUNNING);
            this.clean();
            this.isSuccess = true;
            this.setStatus(ServiceRequestStatus.COMPLETED);
        }
        catch (Exception exception) {
            this.setStatus(ServiceRequestStatus.ERROR);
            this.isSuccess = false;
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    public void stop() {
        this.isSuccess = true;
    }

    private void clean() {
        logger.debug(this.getClass().getName() + " -> not used yet. Clean up process for Updates is still Sync with the transaction");
    }
}

