/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.odilon.scheduler.CronExpressionDeserializer;
import io.odilon.scheduler.CronExpressionJ8;
import io.odilon.scheduler.CronExpressionSerializer;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZonedDateTime;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonSerialize(using=CronExpressionSerializer.class)
@JsonDeserialize(using=CronExpressionDeserializer.class)
public class CronExpressionJ8
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String expr;
    private final SimpleField secondField;
    private final SimpleField minuteField;
    private final SimpleField hourField;
    private final DayOfWeekField dayOfWeekField;
    private final SimpleField monthField;
    private final DayOfMonthField dayOfMonthField;

    public CronExpressionJ8(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("expr is null");
        }
        this.expr = string;
        int n = bl ? 6 : 5;
        String[] stringArray = string.split("\\s+");
        if (stringArray.length != n) {
            throw new IllegalArgumentException(String.format("Invalid cron expression [%s], expected %s field, got %s", string, n, stringArray.length));
        }
        int n2 = bl ? 1 : 0;
        this.secondField = new SimpleField(CronFieldType.SECOND, bl ? stringArray[0] : "0");
        this.minuteField = new SimpleField(CronFieldType.MINUTE, stringArray[n2++]);
        this.hourField = new SimpleField(CronFieldType.HOUR, stringArray[n2++]);
        this.dayOfMonthField = new DayOfMonthField(stringArray[n2++]);
        this.monthField = new SimpleField(CronFieldType.MONTH, stringArray[n2++]);
        this.dayOfWeekField = new DayOfWeekField(stringArray[n2++]);
    }

    public static CronExpressionJ8 create(String string) {
        return new CronExpressionJ8(string, true);
    }

    public static CronExpressionJ8 createWithoutSeconds(String string) {
        return new CronExpressionJ8(string, false);
    }

    public ZonedDateTime nextTimeAfter(ZonedDateTime zonedDateTime) {
        return this.nextTimeAfter(zonedDateTime, zonedDateTime.plusYears(4L));
    }

    public ZonedDateTime nextTimeAfter(ZonedDateTime zonedDateTime, long l) {
        return this.nextTimeAfter(zonedDateTime, zonedDateTime.plus(Duration.ofMillis(l)));
    }

    public ZonedDateTime nextTimeAfter(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2) {
        ZonedDateTime zonedDateTime3 = ZonedDateTime.from(zonedDateTime).withNano(0).plusSeconds(1L).withNano(0);
        while (true) {
            if (!this.secondField.matches(zonedDateTime3.getSecond())) {
                zonedDateTime3 = zonedDateTime3.plusSeconds(1L).withNano(0);
                continue;
            }
            if (!this.minuteField.matches(zonedDateTime3.getMinute())) {
                zonedDateTime3 = zonedDateTime3.plusMinutes(1L).withSecond(0).withNano(0);
                continue;
            }
            if (!this.hourField.matches(zonedDateTime3.getHour())) {
                zonedDateTime3 = zonedDateTime3.plusHours(1L).withMinute(0).withSecond(0).withNano(0);
                continue;
            }
            if (!this.dayOfMonthField.matches(zonedDateTime3.toLocalDate())) {
                zonedDateTime3 = zonedDateTime3.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                CronExpressionJ8.checkIfDateTimeBarrierIsReached((ZonedDateTime)zonedDateTime3, (ZonedDateTime)zonedDateTime2);
                continue;
            }
            if (!this.monthField.matches(zonedDateTime3.getMonth().getValue())) {
                zonedDateTime3 = zonedDateTime3.plusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                CronExpressionJ8.checkIfDateTimeBarrierIsReached((ZonedDateTime)zonedDateTime3, (ZonedDateTime)zonedDateTime2);
                continue;
            }
            if (this.dayOfWeekField.matches(zonedDateTime3.toLocalDate())) break;
            zonedDateTime3 = zonedDateTime3.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            CronExpressionJ8.checkIfDateTimeBarrierIsReached((ZonedDateTime)zonedDateTime3, (ZonedDateTime)zonedDateTime2);
        }
        return zonedDateTime3;
    }

    private static void checkIfDateTimeBarrierIsReached(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2) {
        if (zonedDateTime.isAfter(zonedDateTime2)) {
            throw new IllegalArgumentException("No next execution time could be determined that is before the limit of " + String.valueOf(zonedDateTime2));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.expr + "]";
    }

    public String toHTMLString() {
        return this.toHTMLString("ago");
    }

    public String toHTMLString(String string) {
        return this.getClass().getSimpleName() + "<span class=\"" + string + "\"> [ " + this.expr + " ]</span>";
    }

    public String getExpression() {
        return new String(this.expr);
    }
}

