/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.CronExpressionJ8;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public abstract class CronJobRequest
extends AbstractServiceRequest {
    private static Logger logger = Logger.getLogger((String)CronJobRequest.class.getName());
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private ZonedDateTime ztime = null;
    @JsonIgnore
    private boolean executeOldTriggers;
    @JsonIgnore
    private boolean is_user_request = false;
    @JsonIgnore
    private boolean enabled = true;
    private CronExpressionJ8 cron_expression;

    public CronJobRequest() {
        this.setTimeZone(TimeZone.getDefault().getID());
    }

    public CronJobRequest(String string) {
        this.cron_expression = new CronExpressionJ8(string, true);
        this.setTimeZone(TimeZone.getDefault().getID());
    }

    public boolean isCronJob() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public ZonedDateTime getTime() {
        if (this.ztime == null) {
            this.ztime = this.getCronExpression().nextTimeAfter(this.getTimeZone() == null ? ZonedDateTime.now() : ZonedDateTime.now(ZoneId.of(this.getTimeZone())));
        }
        return this.ztime;
    }

    public void setTime(ZonedDateTime zonedDateTime) {
        this.ztime = zonedDateTime;
    }

    public ZonedDateTime getNextTime() {
        return this.getCronExpression().nextTimeAfter(this.getTime());
    }

    public CronExpressionJ8 getCronExpression() {
        return this.cron_expression;
    }

    public void setCronExpression(CronExpressionJ8 cronExpressionJ8) {
        this.cron_expression = cronExpressionJ8;
    }

    public void stop() {
    }

    public void setUserRequest(boolean bl) {
        this.is_user_request = bl;
    }

    public boolean isUserRequest() {
        return this.is_user_request;
    }

    public void onClone(CronJobRequest cronJobRequest) {
        cronJobRequest.setCronExpression(this.getCronExpression());
        cronJobRequest.setName(this.getName());
        cronJobRequest.setDescription(this.getDescription());
        cronJobRequest.setUserRequest(this.isUserRequest());
        cronJobRequest.setTime(this.getCronExpression().nextTimeAfter(this.getTime()));
        cronJobRequest.setExecuteOldTriggers(this.getExecuteOldTriggers());
        cronJobRequest.setEnabled(this.isEnabled());
        cronJobRequest.setExecuteAfter(this.getExecuteAfter());
        cronJobRequest.setTimeZone(this.getTimeZone());
        Map map = this.getParameters();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                map.put(((String)entry.getKey()).toString(), (String)entry.getValue());
            }
            cronJobRequest.setParameters(map);
        }
    }

    public CronJobRequest clone() {
        try {
            CronJobRequest cronJobRequest = (CronJobRequest)this.getApplicationContext().getBean(this.getClass(), new Object[]{this.getCronExpression().getExpression()});
            this.onClone(cronJobRequest);
            return cronJobRequest;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{this.toString()});
            throw new InternalCriticalException(exception);
        }
    }

    public boolean getExecuteOldTriggers() {
        return this.executeOldTriggers;
    }

    public void setExecuteOldTriggers(boolean bl) {
        this.executeOldTriggers = bl;
    }
}

