/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.scheduler.CronJobList;
import io.odilon.scheduler.CronJobRequest;
import io.odilon.scheduler.SchedulerWorker;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.time.Duration;
import java.time.ZonedDateTime;

public class CronJobSchedulerWorker
extends SchedulerWorker {
    private static Logger logger = Logger.getLogger((String)CronJobSchedulerWorker.class.getName());
    @JsonIgnore
    private CronJobList cronJobs;

    public CronJobSchedulerWorker(String string, VirtualFileSystemService virtualFileSystemService) {
        super(string, virtualFileSystemService);
    }

    public void add(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)" request is null");
        Check.requireTrue((boolean)serviceRequest.isCronJob(), (String)("request is not -> " + CronJobRequest.class.getName()));
        this.getCronJobList().add((CronJobRequest)serviceRequest);
    }

    public void fail(ServiceRequest serviceRequest) {
    }

    public void cancel(ServiceRequest serviceRequest) {
    }

    public void close(ServiceRequest serviceRequest) {
    }

    public int getPoolSize() {
        return this.getVirtualFileSystemService().getServerSettings().getCronDispatcherPoolSize();
    }

    protected void doJobs() {
        boolean bl = false;
        while (!bl && !this.getCronJobList().isEmpty()) {
            ZonedDateTime zonedDateTime;
            CronJobRequest cronJobRequest = this.getCronJobList().first();
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
            if (zonedDateTime2.isAfter(zonedDateTime = cronJobRequest.getTime()) || zonedDateTime2.isEqual(zonedDateTime)) {
                try {
                    cronJobRequest = this.getCronJobList().pollFirst();
                    if (!cronJobRequest.isEnabled()) continue;
                    this.dispatch((ServiceRequest)cronJobRequest);
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    bl = true;
                }
                continue;
            }
            bl = true;
        }
    }

    protected boolean isWork() {
        return false;
    }

    protected void restNoWork() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        if (!this.getCronJobList().isEmpty()) {
            ZonedDateTime zonedDateTime2 = this.getCronJobList().first().getTime();
            if (zonedDateTime2 != null && zonedDateTime.plusSeconds(this.getSiestaMillisecs()).isAfter(zonedDateTime2)) {
                this.rest(Duration.between(zonedDateTime, zonedDateTime2).toMillis());
            } else {
                this.rest(this.getSiestaMillisecs());
            }
        } else {
            this.rest(this.getSiestaMillisecs());
        }
    }

    protected void onInitialize() {
        this.cronJobs = new CronJobList();
    }

    protected void restFullCapacity() {
        this.rest(1000L);
    }

    protected boolean isFullCapacity() {
        return false;
    }

    private CronJobList getCronJobList() {
        return this.cronJobs;
    }
}

