/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.BaseObject;
import io.odilon.scheduler.Dispatcher;
import io.odilon.scheduler.ServiceRequestExecutor;
import java.util.HashMap;
import java.util.Map;

public class Dispatcher
extends BaseObject {
    private static Logger startupLogger = Logger.getLogger((String)"StartupLogger");
    private static Logger logger = Logger.getLogger((String)Dispatcher.class.getName());
    private int priority;
    private int maxPoolSize;
    private int minPoolSize;
    private int initialSize;
    private int keeepAliveMS;
    private String id;
    private int threadsPriority = Thread.currentThread().getPriority();
    private int threadNumber = 1;
    @JsonIgnore
    private ThreadFactory threadFactory = new ThreadFactory(this);
    @JsonIgnore
    private PooledExecutor threadPool;
    @JsonIgnore
    Map<String, Thread> i_threads = new HashMap();

    public Dispatcher(String string, int n, int n2) {
        this.priority = n;
        this.maxPoolSize = n2;
        this.minPoolSize = n2;
        this.initialSize = n2 > 4 ? 4 : n2;
        this.keeepAliveMS = -1;
        this.id = string;
        startupLogger.debug("Starting Dispatcher " + this.getId());
        this.makePool();
        startupLogger.debug(this.getInfo());
    }

    public Dispatcher(int n, int n2, int n3, int n4, int n5, String string) {
        assert (n2 == n3);
        this.priority = n;
        this.maxPoolSize = n2;
        this.minPoolSize = n2;
        this.initialSize = n4;
        this.keeepAliveMS = n5;
        this.minPoolSize = n3;
        this.id = string;
        this.makePool();
        startupLogger.info(this.getInfo());
    }

    public String getId() {
        return this.id;
    }

    public void restart() {
        this.restart(false);
    }

    public void restart(boolean bl) {
        if (bl) {
            logger.info("shuting down now.");
            this.threadPool.shutdownNow();
        } else {
            logger.info("Waiting for all current processes to terminate and shutdown.");
            this.threadPool.shutdownAfterProcessingCurrentlyQueuedTasks();
        }
        logger.info("restarting threads.");
        this.makePool();
    }

    public String getInfo() {
        return "Priority: " + String.valueOf(this.getPriority()) + ". Workers: " + String.valueOf(this.getMaximumPoolSize());
    }

    public String getStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.threadPool.getPoolSize();
        stringBuilder.append("Priority: " + String.valueOf(this.getPriority()) + " | ");
        stringBuilder.append("PoolSize: " + String.valueOf(n) + " | ");
        stringBuilder.append("MaxPoolSize: " + String.valueOf(this.getMaximumPoolSize()));
        return stringBuilder.toString();
    }

    public void shutDownNow() {
        this.threadPool.shutdownNow();
    }

    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void dispatch(ServiceRequestExecutor serviceRequestExecutor) {
        try {
            this.threadPool.execute((Runnable)serviceRequestExecutor);
        }
        catch (InterruptedException interruptedException) {
            logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
        }
    }

    public void execute(Runnable runnable) {
        try {
            this.threadPool.execute(runnable);
        }
        catch (InterruptedException interruptedException) {
            logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
        }
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
        this.threadPool.setMaximumPoolSize(n);
    }

    private void makePool() {
        this.threadPool = new PooledExecutor((Channel)new LinkedQueue(), this.maxPoolSize);
        this.threadPool.setThreadFactory((EDU.oswego.cs.dl.util.concurrent.ThreadFactory)this.threadFactory);
        this.threadPool.setMinimumPoolSize(this.minPoolSize);
        this.threadPool.createThreads(this.initialSize);
        this.threadPool.setKeepAliveTime((long)this.keeepAliveMS);
        this.threadPool.setMaximumPoolSize(this.maxPoolSize);
        this.threadPool.waitWhenBlocked();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }
}

