/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.scheduler.CronJobSchedulerWorker;
import io.odilon.scheduler.SchedulerWorker;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.scheduler.StandByReplicaSchedulerWorker;
import io.odilon.scheduler.StandByReplicaServiceRequest;
import io.odilon.scheduler.StandardSchedulerWorker;
import io.odilon.scheduler.StandardServiceRequest;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.service.SystemService;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.time.OffsetDateTime;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SchedulerService
extends BaseService
implements SystemService,
ApplicationContextAware {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static Logger logger = Logger.getLogger((String)SchedulerService.class.getName());
    private OffsetDateTime started = OffsetDateTime.now();
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    @Autowired
    private ServerSettings serverSettings;
    @JsonIgnore
    @Autowired
    private SystemMonitorService monitoringService;
    @JsonIgnore
    @Autowired
    private ApplicationContext applicationContext;
    @JsonIgnore
    private StandardSchedulerWorker standardSchedulerWorker;
    @JsonIgnore
    private SchedulerWorker cronjobsWorker;
    @JsonIgnore
    private StandByReplicaSchedulerWorker replicaWorker;

    public SchedulerService(ServerSettings serverSettings, SystemMonitorService systemMonitorService) {
        this.serverSettings = serverSettings;
        this.monitoringService = systemMonitorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable enqueue(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request is null");
        long l = System.nanoTime();
        serviceRequest.setId((Serializable)Long.valueOf(l));
        serviceRequest.setTimeZone(this.getServerSettings().getTimeZone());
        if (serviceRequest.isCronJob()) {
            this.getCronjobsWorker().add(serviceRequest);
        } else if (serviceRequest instanceof StandByReplicaServiceRequest) {
            this.getReplicaWorker().add(serviceRequest);
            StandByReplicaSchedulerWorker standByReplicaSchedulerWorker = this.getReplicaWorker();
            synchronized (standByReplicaSchedulerWorker) {
                this.getReplicaWorker().notify();
            }
        } else if (serviceRequest instanceof StandardServiceRequest) {
            this.getStandardSchedulerWorker().add(serviceRequest);
            StandardSchedulerWorker standardSchedulerWorker = this.getStandardSchedulerWorker();
            synchronized (standardSchedulerWorker) {
                this.getStandardSchedulerWorker().notify();
            }
        } else {
            logger.error(new String[]{"invalid " + ServiceRequest.class.getSimpleName() + " of class -> " + serviceRequest.getClass().getName() + "---- not thrown ----"});
        }
        return serviceRequest.getId();
    }

    @PostConstruct
    protected void onInitialize() {
        this.setStatus(ServiceStatus.STARTING);
    }

    public synchronized void start() {
        try {
            this.cronjobsWorker = new CronJobSchedulerWorker("cron", this.getVirtualFileSystemService());
            this.cronjobsWorker.setApplicationContext(this.getApplicationContext());
            this.replicaWorker = new StandByReplicaSchedulerWorker("replica", this.getVirtualFileSystemService());
            this.replicaWorker.setApplicationContext(this.getApplicationContext());
            this.standardSchedulerWorker = new StandardSchedulerWorker("standard", this.getVirtualFileSystemService());
            this.standardSchedulerWorker.setApplicationContext(this.getApplicationContext());
            this.getCronjobsWorker().start();
            this.getStandardSchedulerWorker().start();
            if (this.getServerSettings().isStandByEnabled()) {
                this.getReplicaWorker().start();
            }
            this.setStatus(ServiceStatus.RUNNING);
            startuplogger.debug("Started -> " + this.getClass().getSimpleName());
        }
        catch (Exception exception) {
            this.setStatus(ServiceStatus.STOPPED);
            throw exception;
        }
    }

    public void close(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request is null");
        if (serviceRequest instanceof StandByReplicaServiceRequest) {
            this.getReplicaWorker().close(serviceRequest);
        } else if (serviceRequest instanceof StandardServiceRequest) {
            this.getStandardSchedulerWorker().close(serviceRequest);
        } else {
            logger.error(new String[]{"Class not supported -> " + serviceRequest.getClass().getName(), "---- not thrown ----"});
        }
    }

    public void fail(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request is null");
        if (serviceRequest instanceof StandByReplicaServiceRequest) {
            this.getReplicaWorker().fail(serviceRequest);
        }
    }

    public void cancel(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"opx is null");
        this.getReplicaWorker().cancel(virtualFileSystemOperation);
    }

    public void cancel(Serializable serializable) {
        Check.requireNonNullArgument((Object)serializable, (String)"id is null");
        this.getReplicaWorker().cancel(serializable);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        if (this.virtualFileSystemService == null) {
            throw new IllegalStateException("The " + VirtualFileSystemService.class.getName() + " must be setted during the @PostConstruct method of the " + VirtualFileSystemService.class.getName() + " instance. It can not be injected via @AutoWired because of circular dependencies.");
        }
        return this.virtualFileSystemService;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public OffsetDateTime getStarted() {
        return this.started;
    }

    public SystemMonitorService getSystemMonitorService() {
        return this.monitoringService;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public boolean isRunning() {
        return this.getStatus() == ServiceStatus.RUNNING;
    }

    public int getReplicaQueueSize() {
        return this.getReplicaWorker().getServiceRequestQueue().size();
    }

    public int getStandardQueueSize() {
        return this.getStandardSchedulerWorker().getServiceRequestQueue().size();
    }

    protected SchedulerWorker getCronjobsWorker() {
        return this.cronjobsWorker;
    }

    protected void setCronjobsWorker(SchedulerWorker schedulerWorker) {
        this.cronjobsWorker = schedulerWorker;
    }

    protected StandardSchedulerWorker getStandardSchedulerWorker() {
        return this.standardSchedulerWorker;
    }

    protected void setStandardWorker(StandardSchedulerWorker standardSchedulerWorker) {
        this.standardSchedulerWorker = standardSchedulerWorker;
    }

    protected StandByReplicaSchedulerWorker getReplicaWorker() {
        return this.replicaWorker;
    }

    protected void setReplicaWorker(StandByReplicaSchedulerWorker standByReplicaSchedulerWorker) {
        this.replicaWorker = standByReplicaSchedulerWorker;
    }
}

