/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.scheduler.Dispatcher;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.scheduler.ServiceRequestExecutor;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public abstract class SchedulerWorker
implements Runnable {
    private static Logger logger = Logger.getLogger((String)SchedulerWorker.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    public static final long ONE_SECOND = 1000L;
    public static final long _SIESTA_SECS = 40L;
    public static final long _STARTUP_SIESTA_MILSECS = 15000L;
    private String id;
    private int poolSize = 1;
    @JsonIgnore
    private AtomicBoolean running = new AtomicBoolean(false);
    @JsonIgnore
    private long siesta_mili = 40000L;
    @JsonIgnore
    private Thread thread;
    @JsonIgnore
    private OffsetDateTime created = OffsetDateTime.now();
    @JsonIgnore
    private Dispatcher dispatcher;
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    private Map<Serializable, ServiceRequest> executingRequests = new HashMap();
    @JsonIgnore
    private List<ServiceRequest> failedRequests = new ArrayList();
    @JsonIgnore
    private ApplicationContext applicationContext;
    @JsonIgnore
    private volatile boolean sleeping = false;

    public abstract void fail(ServiceRequest var1);

    public abstract void cancel(ServiceRequest var1);

    public abstract void close(ServiceRequest var1);

    public abstract void add(ServiceRequest var1);

    protected abstract void onInitialize();

    protected abstract void doJobs();

    protected abstract void restNoWork();

    protected abstract void restFullCapacity();

    protected abstract boolean isWork();

    protected abstract boolean isFullCapacity();

    public SchedulerWorker(String string, VirtualFileSystemService virtualFileSystemService) {
        this.id = string;
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public void start() {
        this.poolSize = this.getPoolSize();
        this.setSiestaMillisecs(this.getVirtualFileSystemService().getServerSettings().getSchedulerSiestaSecs() * 1000L);
        this.dispatcher = new Dispatcher(this.getId(), 1, this.poolSize);
        this.thread = new Thread((Runnable)this);
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName() + "_" + this.getId());
        this.thread.setPriority(1);
        this.onInitialize();
        this.thread.start();
        startuplogger.debug("Started -> " + this.getClass().getName());
    }

    public int getPoolSize() {
        return this.getVirtualFileSystemService().getServerSettings().getDispatcherPoolSize();
    }

    @Override
    public void run() {
        this.rest(15000L);
        this.running = new AtomicBoolean(true);
        while (this.isRunning()) {
            try {
                this.doJobs();
                if (this.isFullCapacity()) {
                    this.restFullCapacity();
                }
                if (this.isWork()) continue;
                this.restNoWork();
            }
            catch (Throwable throwable) {
                this.processError(throwable);
            }
        }
        this.rest(15000L);
        logger.error(new String[]{"ending main loop"});
        this.running = new AtomicBoolean(false);
    }

    public void stop() {
        this.running = new AtomicBoolean(false);
    }

    public OffsetDateTime getStarted() {
        return this.created;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getId() {
        return this.id;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        return this.virtualFileSystemService;
    }

    protected void setSiestaMillisecs(long l) {
        this.siesta_mili = l;
    }

    protected long getSiestaMillisecs() {
        return this.siesta_mili;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rest(long l) {
        block6: {
            try {
                if (l <= 0L) break block6;
                SchedulerWorker schedulerWorker = this;
                synchronized (schedulerWorker) {
                    this.setSleeping(true);
                    this.wait(l);
                    this.setSleeping(false);
                }
            }
            catch (InterruptedException interruptedException) {
                this.setSleeping(false);
            }
            catch (Throwable throwable) {
                logger.error(throwable, new String[]{"---- not thrown ----"});
                this.setSleeping(false);
            }
        }
    }

    protected void dispatch(ServiceRequest serviceRequest) {
        serviceRequest.setApplicationContext(this.getApplicationContext());
        ServiceRequestExecutor serviceRequestExecutor = new ServiceRequestExecutor(serviceRequest, this);
        this.getDispatcher().dispatch(serviceRequestExecutor);
    }

    protected Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    protected void processError(Throwable throwable) {
        logger.error(throwable, new String[]{"---- not thrown ----"});
    }

    private void setSleeping(boolean bl) {
        this.sleeping = bl;
    }

    private boolean isRunning() {
        return this.running.get();
    }
}

