/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.service.BaseService;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ServiceRequestQueue
extends BaseService
implements Queue<ServiceRequest> {
    private static Logger logger = Logger.getLogger((String)ServiceRequestQueue.class.getName());
    private String id;
    @JsonIgnore
    private Queue<ServiceRequest> queue;
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;

    public ServiceRequestQueue(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int size() {
        return this.getQueue().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getQueue().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.getQueue().contains(object);
    }

    @Override
    public Iterator<ServiceRequest> iterator() {
        return this.getQueue().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getQueue().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.getQueue().toArray(TArray);
    }

    public boolean moveOut(Object object) {
        boolean bl = this.getQueue().remove((ServiceRequest)object);
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        this.fsRemove((ServiceRequest)object);
        boolean bl = this.getQueue().remove((ServiceRequest)object);
        return bl;
    }

    public boolean removeById(Serializable serializable) {
        for (ServiceRequest serviceRequest : this.getQueue()) {
            if (!serviceRequest.getId().equals(serializable)) continue;
            return this.remove((Object)serviceRequest);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getQueue().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends ServiceRequest> collection) {
        collection.forEach(serviceRequest -> {
            this.fsStore(serviceRequest);
            this.getQueue().add(serviceRequest);
        });
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        collection.forEach(object -> {
            if (object instanceof ServiceRequest) {
                this.fsRemove((ServiceRequest)object);
                this.getQueue().remove((ServiceRequest)object);
            }
        });
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new RuntimeException("not applicable");
    }

    @Override
    public void clear() {
        this.fsRemoveAll();
        this.getQueue().clear();
    }

    @Override
    public boolean add(ServiceRequest serviceRequest) {
        this.fsStore(serviceRequest);
        return this.getQueue().add(serviceRequest);
    }

    @Override
    public boolean offer(ServiceRequest serviceRequest) {
        this.fsStore(serviceRequest);
        return this.getQueue().offer(serviceRequest);
    }

    @Override
    public ServiceRequest remove() {
        this.fsRemove(this.peek());
        return (ServiceRequest)this.getQueue().remove();
    }

    @Override
    public ServiceRequest poll() {
        return (ServiceRequest)this.getQueue().poll();
    }

    @Override
    public ServiceRequest element() {
        return (ServiceRequest)this.getQueue().element();
    }

    @Override
    public ServiceRequest peek() {
        return (ServiceRequest)this.getQueue().peek();
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        if (this.virtualFileSystemService != null) {
            return this.virtualFileSystemService;
        }
        String string = "The " + VirtualFileSystemService.class.getName() + " must be setted during the @PostConstruct method of the " + VirtualFileSystemService.class.getName() + " instance. It can not be injected via @AutoWired due to circular dependencies.";
        throw new IllegalStateException(string);
    }

    public synchronized void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        this.virtualFileSystemService = virtualFileSystemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected synchronized void onInitialize() {
        ServiceRequestQueue serviceRequestQueue = this;
        synchronized (serviceRequestQueue) {
            try {
                this.setStatus(ServiceStatus.STARTING);
                this.queue = new ConcurrentLinkedQueue();
                this.setStatus(ServiceStatus.RUNNING);
            }
            catch (Exception exception) {
                this.setStatus(ServiceStatus.STOPPED);
                throw exception;
            }
        }
    }

    protected synchronized void loadFSQueue() {
        List list = this.getVirtualFileSystemService().getSchedulerPendingRequests(this.getId());
        list.sort(new /* Unavailable Anonymous Inner Class!! */);
        for (ServiceRequest serviceRequest : list) {
            this.getQueue().add(serviceRequest);
        }
    }

    private void fsRemoveAll() {
        this.getQueue().forEach(serviceRequest -> this.fsRemove(serviceRequest));
    }

    private void fsRemove(ServiceRequest serviceRequest) {
        if (serviceRequest == null) {
            return;
        }
        this.getVirtualFileSystemService().removeScheduler(serviceRequest, this.getId());
    }

    private void fsStore(ServiceRequest serviceRequest) {
        if (serviceRequest == null) {
            return;
        }
        this.getVirtualFileSystemService().saveScheduler(serviceRequest, this.getId());
    }

    private Queue<ServiceRequest> getQueue() {
        return this.queue;
    }
}

