/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.replication.ReplicationService;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.virtualFileSystem.OdilonVirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="standByReplica")
public class StandByReplicaServiceRequest
extends AbstractServiceRequest {
    private static Logger logger = Logger.getLogger((String)StandByReplicaServiceRequest.class.getName());
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private boolean isSuccess = false;
    @JsonProperty(value="operation")
    private OdilonVirtualFileSystemOperation operation;

    protected StandByReplicaServiceRequest() {
    }

    public StandByReplicaServiceRequest(VirtualFileSystemOperation virtualFileSystemOperation) {
        this.operation = (OdilonVirtualFileSystemOperation)virtualFileSystemOperation;
    }

    public void execute() {
        try {
            this.setStatus(ServiceRequestStatus.RUNNING);
            ReplicationService replicationService = (ReplicationService)this.getApplicationContext().getBean(ReplicationService.class);
            if (replicationService.isStandByEnabled()) {
                replicationService.replicate(this.getVFSOperation());
                this.isSuccess = true;
            } else {
                this.isSuccess = true;
            }
            this.setStatus(ServiceRequestStatus.COMPLETED);
        }
        catch (Exception exception) {
            this.isSuccess = false;
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    public void stop() {
        this.isSuccess = true;
    }

    public String getUUID() {
        return this.getVFSOperation().getUUID();
    }

    public VirtualFileSystemOperation getVFSOperation() {
        return this.operation;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }
}

