/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.scheduler.SchedulerWorker;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.scheduler.ServiceRequestQueue;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.scheduler.StandardServiceRequest;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class StandardSchedulerWorker
extends SchedulerWorker {
    private static Logger logger = Logger.getLogger((String)StandardSchedulerWorker.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    static final int RETRY_FAILED_SECONDS = 15;
    static final int MAX_RETRIES = 5;
    @JsonIgnore
    private ServiceRequestQueue queue;
    @JsonIgnore
    private Map<Serializable, ServiceRequest> executing;
    @JsonIgnore
    private Map<Serializable, ServiceRequest> failed;
    @JsonIgnore
    private OffsetDateTime lastFailedTry = OffsetDateTime.MIN;

    public StandardSchedulerWorker(String string, VirtualFileSystemService virtualFileSystemService) {
        super(string, virtualFileSystemService);
    }

    public void add(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request is null");
        Check.requireTrue((boolean)(serviceRequest instanceof StandardServiceRequest), (String)("must be instance of -> " + StandardServiceRequest.class.getName() + " | request: " + serviceRequest.getClass().getName()));
        this.getServiceRequestQueue().add(serviceRequest);
    }

    public void close(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request is null");
        try {
            if (this.getExecuting().containsKey(serviceRequest.getId())) {
                this.getExecuting().remove(serviceRequest.getId());
            }
            if (this.getFailed().containsKey(serviceRequest.getId())) {
                this.getFailed().remove(serviceRequest.getId());
            }
            this.getServiceRequestQueue().remove((Object)serviceRequest);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    public void cancel(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request is null");
        try {
            if (this.getExecuting().containsKey(serviceRequest.getId())) {
                this.getExecuting().remove(serviceRequest.getId());
            }
            if (this.getFailed().containsKey(serviceRequest.getId())) {
                this.getFailed().remove(serviceRequest.getId());
            }
            this.getServiceRequestQueue().remove((Object)serviceRequest);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    public void fail(ServiceRequest serviceRequest) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request is null");
        try {
            if (this.getExecuting().containsKey(serviceRequest.getId())) {
                this.getExecuting().remove(serviceRequest.getId());
            }
            serviceRequest.setStatus(ServiceRequestStatus.ERROR);
            if (serviceRequest.getRetries() > 5) {
                this.getServiceRequestQueue().remove((Object)serviceRequest);
            } else {
                serviceRequest.setRetries(serviceRequest.getRetries() + 1);
                this.getFailed().put(serviceRequest.getId(), serviceRequest);
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    protected synchronized void onInitialize() {
        this.queue = (ServiceRequestQueue)this.getApplicationContext().getBean(ServiceRequestQueue.class, new Object[]{this.getId()});
        this.queue.setVirtualFileSystemService(this.getVirtualFileSystemService());
        this.queue.loadFSQueue();
        if (this.queue.size() > 0) {
            startuplogger.info(this.getClass().getSimpleName() + " Queue size -> " + String.valueOf(this.queue.size()));
        }
        this.executing = new ConcurrentHashMap(16, 0.9f, 1);
        this.failed = new ConcurrentSkipListMap();
    }

    protected void doJobs() {
        ServiceRequest serviceRequest;
        int n;
        if (this.isFullCapacity()) {
            logger.error(new String[]{this.getClass().getSimpleName() + " operating at full capacity -> " + String.valueOf(this.getDispatcher().getPoolSize())});
            return;
        }
        ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
        HashMap<String, ServiceRequest> hashMap = new HashMap<String, ServiceRequest>();
        int n2 = this.getDispatcher().getPoolSize() - this.getExecuting().size() + 1;
        if (!this.getFailed().isEmpty()) {
            n = 0;
            serviceRequest = this.getFailed().entrySet().iterator();
            var6_6 = false;
            while (n++ < n2 && serviceRequest.hasNext() && !var6_6) {
                var7_7 = (ServiceRequest)serviceRequest.next().getValue();
                if (this.isCompatible(var7_7, hashMap)) {
                    arrayList.add(var7_7);
                    hashMap.put(((StandardServiceRequest)var7_7).getUUID(), var7_7);
                    continue;
                }
                var6_6 = true;
            }
            this.lastFailedTry = OffsetDateTime.now();
        } else {
            n = 0;
            serviceRequest = this.getServiceRequestQueue().iterator();
            var6_6 = false;
            while (n++ < n2 && serviceRequest.hasNext() && !var6_6) {
                var7_7 = (ServiceRequest)serviceRequest.next();
                if (this.isCompatible(var7_7, hashMap)) {
                    arrayList.add(var7_7);
                    hashMap.put(((StandardServiceRequest)var7_7).getUUID(), var7_7);
                    continue;
                }
                var6_6 = true;
            }
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            serviceRequest = (ServiceRequest)arrayList.get(n);
            this.getServiceRequestQueue().moveOut((Object)serviceRequest);
            serviceRequest.setApplicationContext(this.getApplicationContext());
            this.getExecuting().put(serviceRequest.getId(), serviceRequest);
            this.dispatch(serviceRequest);
        }
    }

    protected void restFullCapacity() {
        this.rest(1000L);
    }

    protected void restNoWork() {
        this.rest(this.getSiestaMillisecs());
    }

    protected boolean isFullCapacity() {
        return this.getExecuting().size() >= this.getDispatcher().getPoolSize();
    }

    protected boolean isWork() {
        if (!this.getFailed().isEmpty()) {
            return this.lastFailedTry.plusSeconds(15L).isBefore(OffsetDateTime.now());
        }
        return !this.getServiceRequestQueue().isEmpty();
    }

    protected ServiceRequestQueue getServiceRequestQueue() {
        return this.queue;
    }

    protected Map<Serializable, ServiceRequest> getExecuting() {
        return this.executing;
    }

    protected Map<Serializable, ServiceRequest> getFailed() {
        return this.failed;
    }

    private boolean isCompatible(ServiceRequest serviceRequest, Map<String, ServiceRequest> map) {
        if (!(serviceRequest instanceof StandardServiceRequest)) {
            logger.error(new String[]{"invalid class -> " + serviceRequest.getClass().getName(), "---- not thrown ----"});
            return false;
        }
        if (map.isEmpty()) {
            return true;
        }
        StandardServiceRequest standardServiceRequest = (StandardServiceRequest)serviceRequest;
        if (!standardServiceRequest.isObjectOperation()) {
            return false;
        }
        return !map.containsKey(standardServiceRequest.getUUID());
    }
}

