/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.log.Logger;
import io.odilon.model.BaseObject;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class AuthToken
extends BaseObject
implements Serializable {
    private static Logger logger = Logger.getLogger((String)AuthToken.class.getName());
    static final int VERSION = 1;
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="bucketName")
    public String bucketName;
    @JsonProperty(value="objectName")
    public String objectName;
    @JsonProperty(value="expirationDate")
    public OffsetDateTime expirationDate;
    @JsonProperty(value="keyVersion")
    public int keyVersion;
    @JsonProperty(value="objectCacheDurationSecs")
    public int objectCacheDurationSecs = 0;
    private static final DateTimeFormatter HTTP_DATE = DateTimeFormatter.RFC_1123_DATE_TIME;

    public AuthToken() {
    }

    public AuthToken(String string, String string2) {
        this(string, string2, OffsetDateTime.now().plusSeconds(1209600L), 1, 0);
    }

    public AuthToken(String string, String string2, int n) {
        this(string, string2, n > 0 ? OffsetDateTime.now().plusSeconds(n) : OffsetDateTime.now().plusSeconds(1209600L), 1, 0);
    }

    public AuthToken(String string, String string2, OffsetDateTime offsetDateTime, int n, int n2) {
        this.bucketName = string;
        this.objectName = string2;
        this.expirationDate = offsetDateTime;
        this.keyVersion = n;
        this.objectCacheDurationSecs = n2;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String name() {
        return this.objectName;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public boolean isValid() {
        return this.expirationDate.isAfter(OffsetDateTime.now());
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public OffsetDateTime getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(OffsetDateTime offsetDateTime) {
        this.expirationDate = offsetDateTime;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public void setKeyVersion(int n) {
        this.keyVersion = n;
    }

    @JsonProperty(value="expirationDateString")
    public String expirationDateString() {
        if (this.expirationDate == null) {
            return null;
        }
        return HTTP_DATE.format(this.expirationDate);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    public int getObjectCacheDurationSecs() {
        return this.objectCacheDurationSecs;
    }

    public void setObjectCacheDurationSecs(int n) {
        this.objectCacheDurationSecs = n;
    }
}

