/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.service.ServerSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

@Configuration
@EnableWebSecurity
public class BasicAuthWebSecurityConfiguration {
    @JsonIgnore
    @Autowired
    private final BasicAuthenticationEntryPoint authenticationEntryPoint;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;

    @Autowired
    public BasicAuthWebSecurityConfiguration(ServerSettings serverSettings, BasicAuthenticationEntryPoint basicAuthenticationEntryPoint) {
        this.serverSettings = serverSettings;
        this.authenticationEntryPoint = basicAuthenticationEntryPoint;
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        httpSecurity.authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(new String[]{"/presigned/", "/presigned/object", "/public/"})).permitAll()).authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.anyRequest()).authenticated()).httpBasic(Customizer.withDefaults()).formLogin(Customizer.withDefaults()).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)httpSecurity.build();
    }

    @Bean
    public InMemoryUserDetailsManager userDetailsService() {
        UserDetails userDetails = User.withUsername((String)this.getServerSettings().getAccessKey()).password(this.passwordEncoder().encode((CharSequence)this.getServerSettings().getSecretKey())).roles(new String[]{"USER"}).build();
        return new InMemoryUserDetailsManager(new UserDetails[]{userDetails});
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    private ServerSettings getServerSettings() {
        return this.serverSettings;
    }
}

