/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class OdilonBasicAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException authenticationException) throws IOException {
        httpServletResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealmName() + "\"");
        httpServletResponse.setStatus(401);
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("HTTP Status 401 - " + authenticationException.getMessage());
    }

    public void afterPropertiesSet() {
        this.setRealmName("Odilon");
        super.afterPropertiesSet();
    }
}

