/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.odilon.encryption.EncryptionService;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.security.AuthToken;
import io.odilon.security.TokenService;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class OdilonTokenService
extends BaseService
implements TokenService,
ApplicationContextAware {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private String s_salt;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    @Autowired
    private final EncryptionService encrpytionService;
    @JsonIgnore
    @Autowired
    private final SystemMonitorService monitoringService;
    @JsonIgnore
    @Autowired
    private final VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    private ApplicationContext applicationContext;
    @JsonIgnore
    private IvParameterSpec ivspec;
    @JsonIgnore
    private SecretKeyFactory factory;
    @JsonIgnore
    private KeySpec spec;
    @JsonIgnore
    private SecretKeySpec secretKeySpec;
    @JsonIgnore
    private String secretKey;

    public OdilonTokenService(ServerSettings serverSettings, SystemMonitorService systemMonitorService, EncryptionService encryptionService, VirtualFileSystemService virtualFileSystemService) {
        this.serverSettings = serverSettings;
        this.monitoringService = systemMonitorService;
        this.encrpytionService = encryptionService;
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public String encrypt(AuthToken authToken) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)this.secretKeySpec, this.ivspec);
            return Base64.getEncoder().encodeToString(cipher.doFinal(authToken.toJSON().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            throw new InternalCriticalException(exception, "encrypt");
        }
    }

    public AuthToken decrypt(String string) {
        String string2;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)this.secretKeySpec, this.ivspec);
            string2 = new String(cipher.doFinal(Base64.getDecoder().decode(string)));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            throw new InternalCriticalException((Exception)generalSecurityException, "decrypt");
        }
        try {
            return (AuthToken)this.getObjectMapper().readValue(string2, AuthToken.class);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new InternalCriticalException((Exception)((Object)jsonProcessingException), "decrypt");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        OdilonTokenService odilonTokenService = this;
        synchronized (odilonTokenService) {
            try {
                Object object;
                this.setStatus(ServiceStatus.STARTING);
                this.s_salt = this.serverSettings.getPresignedSalt();
                Object object2 = this.serverSettings.getSecretKey();
                if (((String)object2).length() < 8) {
                    object = new StringBuilder();
                    for (int i = ((String)object2).length(); i < 8; ++i) {
                        ((StringBuilder)object).append("0");
                    }
                    object2 = (String)object2 + ((StringBuilder)object).toString();
                }
                this.secretKey = ((String)object2).substring(0, 8);
                if (this.secretKey == null || this.secretKey.length() != 8) {
                    throw new RuntimeException("Invalid key length - 8 bytes key needed -> " + Optional.ofNullable(this.secretKey).orElse("null"));
                }
                object = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.ivspec = new IvParameterSpec((byte[])object);
                this.factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
                this.spec = new PBEKeySpec(this.secretKey.toCharArray(), this.s_salt.getBytes(), 65536, 256);
                this.secretKeySpec = new SecretKeySpec(this.factory.generateSecret(this.spec).getEncoded(), "AES");
                startuplogger.debug("Started -> " + TokenService.class.getSimpleName());
                this.setStatus(ServiceStatus.RUNNING);
            }
            catch (InternalCriticalException internalCriticalException) {
                this.setStatus(ServiceStatus.STOPPED);
                throw internalCriticalException;
            }
            catch (Exception exception) {
                this.setStatus(ServiceStatus.STOPPED);
                throw new InternalCriticalException(exception, "onInitialize");
            }
        }
    }
}

