/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.service.SystemService;
import io.odilon.util.Check;
import jakarta.annotation.PostConstruct;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.vault.authentication.AppRoleAuthentication;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Service
public class VaultService
extends BaseService
implements SystemService {
    private static final Logger logger = Logger.getLogger((String)VaultService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    @Autowired
    private ServerSettings serverSettings;
    @JsonIgnore
    @Autowired
    private SystemMonitorService monitoringService;
    @JsonIgnore
    private VaultTemplate vaultTemplate = null;

    public VaultService(ServerSettings serverSettings, SystemMonitorService systemMonitorService) {
        this.serverSettings = serverSettings;
        this.monitoringService = systemMonitorService;
    }

    public String encrypt(String string, String string2) {
        return this.encrypt(string, string2, true);
    }

    public String encrypt(String string, String string2, boolean bl) {
        String[] stringArray;
        Check.requireNonNullStringArgument((String)string, (String)"Vault keyID is null");
        Check.requireNonNullStringArgument((String)string2, (String)"encrypt key is null");
        if (string.startsWith("/")) {
            string = string.substring(string.indexOf("/") + 1);
        }
        Check.checkTrue(((stringArray = string.split("/", 2)).length == 2 ? 1 : 0) != 0, (String)("Invalid Vault keyID. It must have 2 parts separated by a '/' | received keyID -> " + string));
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = this.getVaultTemplate().opsForTransit(string3).encrypt(string4, string2);
        if (bl) {
            try {
                this.getSystemMonitorService().getMeterVaultEncrypt().mark();
            }
            catch (Exception exception) {
                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            }
        }
        return string5;
    }

    public String decrypt(String string, String string2) {
        String string3;
        if (string.startsWith("/")) {
            string = string.substring(string.indexOf("/") + 1);
        }
        String[] stringArray = string.split("/", 2);
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        try {
            string3 = this.getVaultTemplate().opsForTransit(string4).decrypt(string5, string2);
            this.getSystemMonitorService().getMeterVaultDecrypt().mark();
        }
        catch (Exception exception) {
            this.vaultTemplate = null;
            throw exception;
        }
        return string3;
    }

    public Optional<String> getUrl() {
        return this.serverSettings.getVaultUrl();
    }

    public String getRoleId() {
        return this.serverSettings.getRoleId();
    }

    public String getSecretId() {
        return this.serverSettings.getSecretId();
    }

    public String ping() {
        String string = null;
        try {
            string = "transit/" + this.serverSettings.getVaultKeyId();
            String string2 = this.encrypt(string, "odilon", false);
            return "ok";
        }
        catch (Exception exception) {
            logger.error(new String[]{"Ping Vault  | Vault Key Id: " + (String)((Object)Optional.ofNullable(string).orElse((CallSite)((Object)"null")))});
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return exception.getClass().getName() + (String)(Optional.ofNullable(exception.getMessage()).isPresent() ? " | " + exception.getMessage() : "") + " | Ping Vault  | Vault Key Id: " + (String)((Object)Optional.ofNullable(string).orElse((CallSite)((Object)"null")));
        }
    }

    public SystemMonitorService getSystemMonitorService() {
        return this.monitoringService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        VaultService vaultService = this;
        synchronized (vaultService) {
            this.setStatus(ServiceStatus.STARTING);
            startuplogger.debug("Started -> " + VaultService.class.getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }

    private VaultTemplate getVaultTemplate() {
        if (this.vaultTemplate == null) {
            try {
                if (!this.getUrl().isPresent()) {
                    throw new InternalCriticalException("vaultUrl is null");
                }
                String string = this.getRoleId();
                String string2 = this.getSecretId();
                VaultEndpoint vaultEndpoint = VaultEndpoint.from((URI)new URI((String)this.getUrl().get()));
                RestTemplate restTemplate = VaultClients.createRestTemplate((VaultEndpoint)vaultEndpoint, (ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
                AppRoleAuthenticationOptions appRoleAuthenticationOptions = AppRoleAuthenticationOptions.builder().path("approle").roleId(AppRoleAuthenticationOptions.RoleId.provided((String)string)).secretId(AppRoleAuthenticationOptions.SecretId.provided((String)string2)).build();
                AppRoleAuthentication appRoleAuthentication = new AppRoleAuthentication(appRoleAuthenticationOptions, (RestOperations)restTemplate);
                this.vaultTemplate = new VaultTemplate(vaultEndpoint, (ClientAuthentication)appRoleAuthentication);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InternalCriticalException((Exception)uRISyntaxException, VaultTemplate.class.getName() + " cannot be initialized");
            }
        }
        return this.vaultTemplate;
    }
}

