/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.service;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.json.OdilonObjectMapper;
import io.odilon.log.Logger;
import io.odilon.model.JSONObject;
import io.odilon.virtualFileSystem.Action;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import org.springframework.context.ApplicationEvent;

public class BaseEvent
extends ApplicationEvent
implements JSONObject {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private static Logger logger = Logger.getLogger((String)BaseEvent.class.getName());
    @JsonIgnore
    private static final ObjectMapper mapper = new OdilonObjectMapper();
    private final VirtualFileSystemOperation operation;
    private final Action action;

    public BaseEvent(VirtualFileSystemOperation virtualFileSystemOperation, Action action) {
        super((Object)virtualFileSystemOperation);
        this.operation = virtualFileSystemOperation;
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public VirtualFileSystemOperation getOperation() {
        return this.operation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    public String toJSON() {
        try {
            return this.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.error((Throwable)jsonProcessingException, new String[]{"---- not thrown ----"});
            return "\"error\":\"" + ((Object)((Object)jsonProcessingException)).getClass().getName() + " | " + jsonProcessingException.getMessage() + "\"";
        }
    }

    @JsonIgnore
    public ObjectMapper getObjectMapper() {
        return mapper;
    }
}

