/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.service;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.json.OdilonObjectMapper;
import io.odilon.log.Logger;
import io.odilon.model.JSONObject;
import io.odilon.model.ServiceStatus;
import io.odilon.util.RandomIDGenerator;

public abstract class BaseService
implements JSONObject {
    private static Logger logger = Logger.getLogger((String)BaseService.class.getName());
    @JsonIgnore
    private static final RandomIDGenerator idGenerator = new RandomIDGenerator();
    @JsonIgnore
    private static final ObjectMapper mapper = new OdilonObjectMapper();
    @JsonIgnore
    private ServiceStatus status = ServiceStatus.STOPPED;

    protected static String randomString(int n) {
        return idGenerator.randomString(n);
    }

    public void setStatus(ServiceStatus serviceStatus) {
        this.status = serviceStatus;
    }

    public ServiceStatus getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    public String toJSON() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.error((Throwable)jsonProcessingException, new String[]{"---- not thrown ----"});
            return "\"error\":\"" + ((Object)((Object)jsonProcessingException)).getClass().getName() + " | " + jsonProcessingException.getMessage() + "\"";
        }
    }

    protected ObjectMapper getObjectMapper() {
        return mapper;
    }
}

