/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.service;

import io.odilon.OdilonVersion;
import io.odilon.log.Logger;
import io.odilon.model.DataStorage;
import io.odilon.model.JSONObject;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.RedundancyLevel;
import io.odilon.service.util.ByteToString;
import io.odilon.util.RandomIDGenerator;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:odilon.properties"})
public class ServerSettings
implements JSONObject {
    private static Logger logger = Logger.getLogger((String)ServerSettings.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static final RandomIDGenerator idGenerator = new RandomIDGenerator();
    private static final OffsetDateTime systemStarted = OffsetDateTime.now();
    protected String version = "";
    private String encryptionKey;
    private String encryptionIV;
    @Value(value="${ping.enabled:true}")
    protected boolean pingEnabled;
    @Value(value="${ping.email.enabled:false}")
    protected boolean pingEmailEnabled;
    @Value(value="${ping.email.address:null}")
    protected String pingEmailAddress;
    @Value(value="${ping.cronJobcronJobPing:45 * * * * *}")
    protected String cronJobcronJobPing;
    private RedundancyLevel redundancyLevel;
    @Value(value="${accessKey:odilon}")
    protected String accessKey;
    @Value(value="${secretKey:odilon}")
    protected String secretKey;
    @Value(value="${server.port:9234}")
    protected int port;
    @Value(value="${timezone:null}")
    protected String timeZone;
    @Value(value="${server.mode:master}")
    protected String serverMode;
    @Value(value="${server.versioncontrol:false}")
    protected boolean versionControl;
    @Value(value="${recovery:false}")
    protected boolean recovery = false;
    @Value(value="${server.ssl.enabled:false}")
    protected String ishttps;
    @Value(value="${server.objectstream.cache.secs:360}")
    protected int serverObjectstreamCacheSecs;
    @Value(value="${encryption.enabled:false}")
    protected boolean isEncrypt;
    @Value(value="${encryption.key:#{null}}")
    protected String encryptionKeyIV;
    @Value(value="${encryption.masterkey:#{null}}")
    protected String masterkey_lowercase;
    @Value(value="${encryption.masterKey:#{null}}")
    protected String masterKey;
    @Value(value="${encryption.keyAlgorithm:AES}")
    protected String keyAlgorithm;
    @Value(value="${presignedSalt:pxUrktu3oMo$dfgh9rl!}")
    protected String presignedSalt;
    @Value(value="${redundancyLevel:null}")
    protected String redundancyLevelStr;
    @Value(value="#{'${dataStorage}'.split(',')}")
    private List<String> rootDirs;
    @Value(value="${raid6.dataDrives:-1}")
    protected int raid6DataDrives;
    @Value(value="${raid6.parityDrives:-1}")
    protected int raid6ParityDrives;
    @Value(value="${dataStorageMode:rw}")
    protected String dataStorageMode;
    private DataStorage dataStorage;
    @Value(value="${lockRateMillisecs:2}")
    String s_lockRateMillisecs;
    protected double lockRateMillisecs;
    @Value(value="${scheduler.standard.threads:0}")
    protected int schedulerThreads;
    @Value(value="${scheduler.cron.threads:0}")
    protected int cronSchedulerThreads;
    @Value(value="${scheduler.siestaSecs:20}")
    protected long schedulerSiestaSecs;
    @Value(value="${scheduler.cronJobWorkDirCleanUp:15 5 * * * *}")
    protected String CronJobWorkDirCleanUp;
    @Value(value="${integrityCheck:true}")
    protected boolean integrityCheck;
    @Value(value="${integrityCheckThreads:0}")
    protected int integrityCheckThreads;
    @Value(value="${integrityCheckDays:180}")
    protected int integrityCheckDays;
    @Value(value="${integrityCheckCronExpression:15 15 5 * * *}")
    protected String integrityCheckCronExpression;
    @Value(value="${vault.enabled:false}")
    protected boolean vaultEnabled;
    @Value(value="${vault.newfiles:true}")
    protected boolean isVaultNewFiles;
    @Value(value="${vault.url:#{null}}")
    protected String vaultUrl;
    @Value(value="${vault.roleId:#{null}}")
    protected String vaultRoleId;
    @Value(value="${vault.secretId:#{null}}")
    protected String vaultSecretId;
    @Value(value="${vault.keyId:kbee-key}")
    protected String vaultKeyId;
    private Optional<String> o_vaultUrl;
    @Value(value="${standby.enabled:false}")
    protected boolean isStandByEnabled = false;
    @Value(value="${standby.sync.force:false}")
    protected boolean standbySyncForce = false;
    @Value(value="${standby.sync.threads:-1}")
    protected int standbySyncThreads = -1;
    @Value(value="${standby.url:null}")
    protected String standbyUrl;
    @Value(value="${standby.port:9234}")
    int standbyPort;
    @Value(value="${standby.accessKey:odilon}")
    protected String standbyAccessKey;
    @Value(value="${standby.secretKey:odilon}")
    protected String standbySecretKey;
    @Value(value="${traffic.tokens:32}")
    private String tokensStr;
    private int t_tokens;
    @Value(value="${objectMetadataCache.initialCapacity:10000}")
    protected int objectCacheInitialCapacity;
    @Value(value="${objectMetadataCache.enabled:true}")
    protected boolean useObjectCache;
    @Value(value="${objectMetadataCache.maxCapacity:2000000}")
    protected long objectCacheMaxCapacity;
    @Value(value="${objectMetadataCache.expireDays:15}")
    protected long objectExpireDays;
    @Value(value="${fileCache.maxCapacity:100000}")
    protected long fileCacheMaxCapacity;
    @Value(value="${fileCache.durationDays:15}")
    protected int fileCacheDurationDays;
    @Value(value="${fileCache.initialCapacity:10000}")
    protected int fileCacheIntialCapacity;
    @Value(value="${raid6.buffers:null}")
    private String raidSixBuffersStr;
    private int raidSixBuffers;
    @Value(value="${retryFailedSeconds:20}")
    protected long retryFailedSeconds;
    private int totalDisks;

    public boolean isPingEmailEnabled() {
        return this.pingEmailEnabled;
    }

    public String isPingEmailAddress() {
        return this.pingEmailAddress;
    }

    public String getCronJobcronJobPing() {
        return this.cronJobcronJobPing;
    }

    @Autowired
    public ServerSettings() {
    }

    public OffsetDateTime getSystemStartTime() {
        return systemStarted;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public List<String> getRootDirs() {
        return this.rootDirs;
    }

    public boolean isEncryptionEnabled() {
        return this.isEncrypt;
    }

    public String toJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"port\":\"" + String.valueOf(this.port) + "\"");
        stringBuilder.append(", \"accessKey\":\"" + this.accessKey + "\"");
        stringBuilder.append(", \"secretKey\":\"" + this.secretKey + "\"");
        stringBuilder.append(", \"https\":\"" + (this.isHTTPS() ? "yes" : "no") + "\"");
        stringBuilder.append(", \"Vault enabled\":\"\"" + (this.isVaultEnabled() ? "true" : "false") + "\"");
        stringBuilder.append(", \"Use Vault for new files\":\"\"" + (this.isUseVaultNewFiles() ? "true" : "false") + "\"");
        stringBuilder.append(", \"vaultUrl\":\"" + (String)(Optional.ofNullable(this.vaultUrl).isPresent() ? "\"" + this.vaultUrl + "\"" : "null"));
        stringBuilder.append(", \"vaultKeyId\":\"" + (String)(Optional.ofNullable(this.vaultKeyId).isPresent() ? "\"" + this.vaultKeyId + "\"" : "null"));
        stringBuilder.append(", \"vaultRoleId\":\"" + (String)(Optional.ofNullable(this.vaultRoleId).isPresent() ? "\"" + this.vaultRoleId + "\"" : "null"));
        stringBuilder.append(", \"redundancyLevel\":" + (String)(Optional.ofNullable(this.redundancyLevel).isPresent() ? "\"" + this.redundancyLevel.getName() + "\"" : "null"));
        if (this.redundancyLevel == RedundancyLevel.RAID_6) {
            stringBuilder.append(", \"dataDrives\":" + String.format("%3d", this.getRAID6DataDrives()).trim());
            stringBuilder.append(", \"paritytDrives\":" + String.format("%3d", this.getRAID6ParityDrives()).trim());
            stringBuilder.append(", \"R6BufferPoolSize\":" + String.format("%4d", this.getR6BufferPoolSize()).trim());
        }
        stringBuilder.append(", \"dataDirs\":[");
        if (this.rootDirs != null && this.rootDirs.size() > 0) {
            stringBuilder.append(this.rootDirs.stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(", ")));
        }
        stringBuilder.append("]");
        stringBuilder.append(", \"standby.enabled\":\"\"" + (this.isStandByEnabled() ? "true" : "false") + "\"");
        if (this.isStandByEnabled()) {
            stringBuilder.append(", \"standby.url\":" + (String)(Optional.ofNullable(this.standbyUrl).isPresent() ? "\"" + this.standbyUrl + "\"" : "null"));
            stringBuilder.append(", \"standby.accesskey\":" + (String)(Optional.ofNullable(this.standbyUrl).isPresent() ? "\"" + this.standbyAccessKey + "\"" : "null"));
            stringBuilder.append(", \"standby.secretkey\":" + (String)(Optional.ofNullable(this.standbySecretKey).isPresent() ? "\"" + this.standbySecretKey + "\"" : "null"));
            stringBuilder.append(", \"standby.port\":" + String.format("%6d", this.standbyPort).trim());
        }
        stringBuilder.append("\"dataStorage\":\"" + String.valueOf(this.getDataStorage()) + "\"");
        stringBuilder.append(", \"encrypt\":\"\"" + (this.isEncryptionEnabled() ? "true" : "false") + "\"");
        stringBuilder.append(", \"keyAlgorithm\":" + (String)(Optional.ofNullable(this.keyAlgorithm).isPresent() ? "\"" + this.keyAlgorithm + "\"" : "null"));
        stringBuilder.append(", \"lockRateMillisecs\":" + String.format("%6.2f", this.getLockRateMillisecs()).trim());
        stringBuilder.append("\"schedulerThreads\":\"" + String.valueOf(this.schedulerThreads) + "\"");
        stringBuilder.append("\"schedulerSiestaSecs\":\"" + String.valueOf(this.schedulerSiestaSecs) + "\"");
        stringBuilder.append(", \"integrityCheck\":\"\"" + (this.isIntegrityCheck() ? "true" : "false") + "\"");
        if (this.isIntegrityCheck()) {
            stringBuilder.append(", \"integrityCheckThreads\":" + String.valueOf(this.getIntegrityCheckThreads()).trim());
            stringBuilder.append(", \"integrityCheckDays\":" + String.valueOf(this.getIntegrityCheckDays()).trim());
            stringBuilder.append(", \"integrityCheckCronExpression\":\"" + this.integrityCheckCronExpression + "\"");
        }
        stringBuilder.append(", \"timeZone\":\"" + this.getTimeZone() + "\"");
        stringBuilder.append(", \"trafficTokens\":" + String.valueOf(this.t_tokens));
        stringBuilder.append(", \"versionControl\":\"" + (this.versionControl ? "true" : "false") + "\"");
        stringBuilder.append("\"objectMetadataCache.maxCapacity\":\"" + String.valueOf(this.objectCacheMaxCapacity) + "\"");
        stringBuilder.append("\"objectMetadataCache.durationDays\":\"" + String.valueOf(this.objectExpireDays) + "\"");
        stringBuilder.append("\"objectstream.cache.secs\":\"" + String.valueOf(this.getserverObjectstreamCacheSecs()) + "\"");
        stringBuilder.append("\"fileCache.maxCapacity\":\"" + String.valueOf(this.fileCacheMaxCapacity) + "\"");
        stringBuilder.append("\"fileCache.durationDays\":\"" + String.valueOf(this.fileCacheDurationDays) + "\"");
        return stringBuilder.toString();
    }

    public int getRAID6ParityDrives() {
        return this.raid6ParityDrives;
    }

    public int getRAID6DataDrives() {
        return this.raid6DataDrives;
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("server.port", this.getPort());
        treeMap.put("server.https", this.isHTTPS() ? "true" : "false");
        treeMap.put("security.accessKey", this.accessKey);
        treeMap.put("security.secretKey", this.secretKey.substring(0, 3) + "...");
        treeMap.put("raid.redundancyLevel", Optional.ofNullable(this.redundancyLevel).isPresent() ? this.redundancyLevel.getName() : "null");
        int n = 0;
        if (this.rootDirs != null && this.rootDirs.size() > 0) {
            for (String string : this.rootDirs) {
                treeMap.put("raid.rootDir_" + String.valueOf(n++), string);
            }
        }
        treeMap.put("cache.serverObjectstreamCacheSecs", String.valueOf(this.getserverObjectstreamCacheSecs()));
        treeMap.put("dataStorage.mode", this.getDataStorage().getName());
        treeMap.put("standby.enabled", this.isStandByEnabled() ? "true" : "false");
        if (this.isStandByEnabled()) {
            treeMap.put("standby.url", this.standbyUrl);
            treeMap.put("standby.accesskey", this.standbyAccessKey);
            treeMap.put("standby.secretkey", String.valueOf(this.standbySecretKey.subSequence(0, 3)) + "...");
            treeMap.put("standby.port", String.format("%6d", this.standbyPort).trim());
        }
        treeMap.put("timeZone", this.getTimeZone());
        return treeMap;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ServerSettings.class.getSimpleName() + "{");
        stringBuilder.append(this.toJSON());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @PostConstruct
    public void onInitialize() {
        Object object;
        if (this.secretKey == null) {
            this.exit("secretKey can not be null");
        }
        if (this.presignedSalt.length() < 20) {
            this.exit("presignedSalt must be at least 20 characters (it has " + String.valueOf(this.presignedSalt.length()) + ")");
        }
        if (this.presignedSalt.length() > 20) {
            this.presignedSalt = this.presignedSalt.substring(0, 20);
        }
        if (this.rootDirs == null || this.rootDirs.size() < 1) {
            startuplogger.error(new String[]{"No rootDirs are defined. \nfor RAID 0. at least 1 dataDir must be defined in file -> odilon.properties \nfor RAID 1. at least 1 dataDir must be defined in file -> odilon.properties \nfor RAID 6. 3, 6, 12, 24 or 48 dataDirs must be defined in file -> odilon.properties \nusing default values "});
            this.getDefaultRootDirs().forEach(string -> startuplogger.error(new String[]{string}));
            this.rootDirs = this.getDefaultRootDirs();
        }
        if (this.encryptionKeyIV != null) {
            this.encryptionKeyIV = this.encryptionKeyIV.trim();
            if (this.encryptionKeyIV.length() != 56) {
                this.exit("encryption key length must be -> " + String.valueOf(56));
            }
            try {
                object = ByteToString.hexStringToByte((String)this.encryptionKeyIV);
            }
            catch (Exception exception) {
                this.exit("encryption key is not a valid hex String -> " + this.encryptionKeyIV);
            }
            this.encryptionKey = this.encryptionKeyIV.substring(0, 32);
            this.encryptionIV = this.encryptionKeyIV.substring(32);
        }
        if (this.masterKey == null && this.masterkey_lowercase != null) {
            this.masterKey = this.masterkey_lowercase.trim();
        }
        if (this.masterKey != null) {
            this.masterKey = this.masterKey.trim();
            if (this.masterKey.length() != 32) {
                this.exit("masterKey key length must be -> " + String.valueOf(32));
            }
            try {
                object = ByteToString.hexStringToByte((String)this.masterKey);
            }
            catch (Exception exception) {
                this.exit("masterKey key is not a valid hex String -> " + this.masterKey);
            }
        }
        try {
            object = Integer.valueOf(this.tokensStr);
        }
        catch (Exception exception) {
            object = 12;
        }
        this.t_tokens = (Integer)object;
        try {
            this.dataStorage = this.dataStorageMode == null ? DataStorage.READ_WRITE : DataStorage.fromString((String)this.dataStorageMode);
        }
        catch (Exception exception) {
            this.exit("dataStorage must be one of {" + DataStorage.getNames().toString() + "} -> " + this.dataStorageMode);
        }
        if (this.timeZone == null || this.timeZone.equals("null") || this.timeZone.length() == 0) {
            this.timeZone = TimeZone.getDefault().getID();
        }
        if (this.getTimeZone().equals(TimeZone.getDefault().getID())) {
            TimeZone.setDefault(TimeZone.getTimeZone(this.getTimeZone()));
        }
        if (this.serverMode == null) {
            this.serverMode = "master";
        } else {
            this.serverMode = this.serverMode.toLowerCase().trim();
            if (!this.serverMode.equals("master") && !this.serverMode.equals("standby")) {
                this.exit("server.mode must be 'master' or 'standby' -> " + this.serverMode);
            }
        }
        if (this.redundancyLevelStr == null || this.redundancyLevelStr.toLowerCase().trim().equals("null")) {
            this.exit("redundancyLevel can not be null | Supported values are: RAID 0, RAID 1 or RAID 6 | example -> redundancyLevel=RAID 0");
        }
        this.redundancyLevel = RedundancyLevel.get((String)this.redundancyLevelStr);
        ArrayList arrayList = new ArrayList();
        if (this.isWindows()) {
            this.rootDirs.forEach(string -> arrayList.add(string.replace("/", File.separator).replace("\\", File.separator).replaceAll("[?;<>|]", "").trim()));
        } else {
            this.rootDirs.forEach(string -> arrayList.add(string.replace("/", File.separator).replace("\\", File.separator).replaceAll("[?;<>|]", "").trim()));
        }
        this.rootDirs = arrayList.stream().distinct().collect(Collectors.toList());
        if (this.rootDirs.size() != arrayList.size()) {
            this.exit("DataStorage can not have duplicate entries -> " + ((Object)arrayList).toString());
        }
        this.rootDirs = arrayList;
        this.o_vaultUrl = Optional.ofNullable(this.vaultUrl);
        if (this.redundancyLevel == null) {
            StringBuilder stringBuilder = new StringBuilder();
            RedundancyLevel.getValues().forEach(redundancyLevel -> stringBuilder.append((stringBuilder.length() > 0 ? ", " : "") + redundancyLevel.getName()));
            this.exit("RedundancyLevel error -> " + this.redundancyLevelStr + " | Supported values are: " + stringBuilder.toString());
        }
        if (this.redundancyLevel == RedundancyLevel.RAID_1) {
            if (this.rootDirs.size() <= 1) {
                this.exit("DataStorage must have at least 2 entries for -> " + this.redundancyLevel.getName() + " | dataStorage=" + this.rootDirs.toString() + " | you must use " + RedundancyLevel.RAID_0.getName() + "for only one mount directory");
            }
        } else if (this.redundancyLevel == RedundancyLevel.RAID_6) {
            if (this.rootDirs.size() != 3 && this.rootDirs.size() != 6 && this.rootDirs.size() != 12 && this.rootDirs.size() != 24 && this.rootDirs.size() != 48) {
                this.exit("DataStorage must have 3, 6, 12, 24, 48 entries for -> " + this.redundancyLevel.getName() + " | value provided -> " + String.valueOf(this.rootDirs.size()));
            }
            if (this.rootDirs.size() == 3) {
                if (this.raid6DataDrives == -1) {
                    this.raid6DataDrives = 2;
                }
                if (this.raid6ParityDrives == -1) {
                    this.raid6ParityDrives = 1;
                }
            } else if (this.rootDirs.size() == 6) {
                if (this.raid6DataDrives == -1) {
                    this.raid6DataDrives = 4;
                }
                if (this.raid6ParityDrives == -1) {
                    this.raid6ParityDrives = 2;
                }
            } else if (this.rootDirs.size() == 12) {
                if (this.raid6DataDrives == -1) {
                    this.raid6DataDrives = 8;
                }
                if (this.raid6ParityDrives == -1) {
                    this.raid6ParityDrives = 4;
                }
            } else if (this.rootDirs.size() == 24) {
                if (this.raid6DataDrives == -1) {
                    this.raid6DataDrives = 16;
                }
                if (this.raid6ParityDrives == -1) {
                    this.raid6ParityDrives = 8;
                }
            } else if (this.rootDirs.size() == 48) {
                if (this.raid6DataDrives == -1) {
                    this.raid6DataDrives = 32;
                }
                if (this.raid6ParityDrives == -1) {
                    this.raid6ParityDrives = 16;
                }
            }
            if (!(this.rootDirs.size() == 3 && this.raid6DataDrives == 2 && this.raid6ParityDrives == 1 || this.rootDirs.size() == 6 && this.raid6DataDrives == 4 && this.raid6ParityDrives == 2 || this.rootDirs.size() == 12 && this.raid6DataDrives == 8 && this.raid6ParityDrives == 4 || this.rootDirs.size() == 24 && this.raid6DataDrives == 16 && this.raid6ParityDrives == 8 || this.rootDirs.size() == 48 && this.raid6DataDrives == 32 && this.raid6ParityDrives == 16)) {
                this.exit(RedundancyLevel.RAID_6.getName() + " configurations supported are ->  3 dirs in DataStorage and raid6.dataDrives=2 and raid6.parityDrives=1  |  6 dirs in DataStorage and raid6.dataDrives=4 and raid6.parityDrives=2  | 12 dirs in DataStorage and raid6.dataDrives=8 and raid6.parityDrives=4  | 24 dirs in DataStorage and raid6.dataDrives=16 and raid6.parityDrives=8 |  48 dirs in DataStorage and raid6.dataDrives=32 and raid6.parityDrives=16 ");
            }
        }
        try {
            this.lockRateMillisecs = Double.valueOf(this.s_lockRateMillisecs);
            if (this.lockRateMillisecs < 0.01) {
                this.lockRateMillisecs = 0.01;
            }
            if (this.lockRateMillisecs > 10.0) {
                this.lockRateMillisecs = 10.0;
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            this.lockRateMillisecs = 2.0;
        }
        if (this.integrityCheckDays < 1) {
            this.integrityCheckDays = 180;
        }
        if (this.integrityCheckThreads < 1) {
            this.integrityCheckThreads = Double.valueOf(Double.valueOf(Runtime.getRuntime().availableProcessors() - 1) / 2.0).intValue() + 1;
        }
        if (this.schedulerThreads < 1) {
            this.schedulerThreads = Double.valueOf(Double.valueOf(Runtime.getRuntime().availableProcessors() - 1) / 2.0).intValue() + 1;
        }
        if (this.schedulerThreads < 2) {
            this.schedulerThreads = 2;
        }
        if (this.cronSchedulerThreads < 1) {
            this.cronSchedulerThreads = Double.valueOf(Double.valueOf(Runtime.getRuntime().availableProcessors() - 1) / 2.5).intValue() + 1;
        }
        if (this.cronSchedulerThreads < 2) {
            this.cronSchedulerThreads = 2;
        }
        if (this.standbyUrl == null) {
            this.isStandByEnabled = false;
        }
        if (this.fileCacheDurationDays < 1) {
            this.fileCacheDurationDays = 7;
        }
        if (this.objectCacheInitialCapacity < 1) {
            this.objectCacheInitialCapacity = 10000;
        }
        this.totalDisks = this.getRootDirs().size();
        if (this.redundancyLevel == RedundancyLevel.RAID_6) {
            try {
                if (this.raidSixBuffersStr != null && this.raidSixBuffersStr.equals("null")) {
                    this.raidSixBuffers = 20;
                    if (this.raidSixBuffers < this.rootDirs.size()) {
                        this.raidSixBuffers = this.rootDirs.size();
                    }
                } else {
                    this.raidSixBuffers = Integer.valueOf(this.raidSixBuffersStr);
                }
            }
            catch (Exception exception) {
                this.raidSixBuffers = 20;
            }
            if (this.raidSixBuffers < this.rootDirs.size()) {
                startuplogger.info(" buffers is set to " + this.raidSixBuffers + "but they must be at least " + this.rootDirs.size() + ". We will use corrected the value to this value.");
                this.raidSixBuffers = this.rootDirs.size();
            }
        } else {
            this.raidSixBuffers = 20;
        }
        startuplogger.debug("Started -> " + ServerSettings.class.getSimpleName());
    }

    public boolean isReadOnly() {
        return this.getDataStorage() == DataStorage.READONLY;
    }

    public boolean isWORM() {
        return this.getDataStorage() == DataStorage.WORM;
    }

    public int getCronDispatcherPoolSize() {
        return this.cronSchedulerThreads;
    }

    public String getCronJobWorkDirCleanUp() {
        return this.CronJobWorkDirCleanUp;
    }

    public boolean isUseObjectCache() {
        return this.useObjectCache;
    }

    public String getInternalMasterKeyEncryptor() {
        return this.masterKey;
    }

    public void setInternalMasterKeyEncryptor(String string) {
        this.masterKey = string;
    }

    public int getserverObjectstreamCacheSecs() {
        return this.serverObjectstreamCacheSecs;
    }

    public String getStandBySecretKey() {
        return this.standbySecretKey;
    }

    public String getStandByAccessKey() {
        return this.standbyAccessKey;
    }

    public String getStandByUrl() {
        return this.standbyUrl;
    }

    public boolean isStandByEnabled() {
        return this.isStandByEnabled;
    }

    public boolean isVersionControl() {
        return this.versionControl;
    }

    public boolean isHTTPS() {
        return this.ishttps != null && this.ishttps.toLowerCase().trim().equals("true");
    }

    private List<String> getDefaultRootDirs() {
        if (this.isWindows()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.getRedundancyLevel() == RedundancyLevel.RAID_1 || this.getRedundancyLevel() == RedundancyLevel.RAID_0) {
                arrayList.add("c:" + File.separator + "odilon-data" + File.separator + "drive0");
                return arrayList;
            }
            arrayList.add("c:" + File.separator + "odilon-data" + File.separator + "drive0");
            arrayList.add("c:" + File.separator + "odilon-data" + File.separator + "drive1");
            arrayList.add("c:" + File.separator + "odilon-data" + File.separator + "drive2");
            return arrayList;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getRedundancyLevel() == RedundancyLevel.RAID_1 || this.getRedundancyLevel() == RedundancyLevel.RAID_0) {
            arrayList.add(File.separator + "var" + File.separator + "lib" + File.separator + "odilon-data" + File.separator + "drive0");
            return arrayList;
        }
        arrayList.add(File.separator + "opt" + File.separator + "odilon-data" + File.separator + "drive0");
        arrayList.add(File.separator + "opt" + File.separator + "odilon-data" + File.separator + "drive1");
        arrayList.add(File.separator + "opt" + File.separator + "odilon-data" + File.separator + "drive2");
        return arrayList;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String string) {
        this.keyAlgorithm = string;
    }

    public String getVersion() {
        return this.version;
    }

    public double getLockRateMillisecs() {
        return this.lockRateMillisecs;
    }

    public RedundancyLevel getRedundancyLevel() {
        return this.redundancyLevel;
    }

    public String getRoleId() {
        return this.vaultRoleId;
    }

    public String getSecretId() {
        return this.vaultSecretId;
    }

    public Optional<String> getVaultUrl() {
        return this.o_vaultUrl;
    }

    public String getVaultKeyId() {
        return this.vaultKeyId;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public String getEncryptionIV() {
        return this.encryptionIV;
    }

    public void setRecovery(boolean bl) {
        this.recovery = bl;
    }

    public boolean isRecovery() {
        return this.recovery;
    }

    public boolean isVaultEnabled() {
        return this.vaultEnabled;
    }

    public boolean isUseVaultNewFiles() {
        return this.isVaultNewFiles;
    }

    public String[] getAppCharacterName() {
        return OdilonVersion.getAppCharacterName();
    }

    public boolean isIntegrityCheck() {
        return this.integrityCheck;
    }

    public int getDispatcherPoolSize() {
        return this.schedulerThreads;
    }

    public int getMaxTrafficTokens() {
        return this.t_tokens;
    }

    public int getIntegrityCheckThreads() {
        return this.integrityCheckThreads;
    }

    public int getIntegrityCheckDays() {
        return this.integrityCheckDays;
    }

    public String getIntegrityCheckCronExpression() {
        return this.integrityCheckCronExpression;
    }

    public long getSchedulerSiestaSecs() {
        return this.schedulerSiestaSecs;
    }

    public String getStandbyUrl() {
        return this.standbyUrl;
    }

    public void setStandbyUrl(String string) {
        this.standbyUrl = string;
    }

    public int getStandbyPort() {
        return this.standbyPort;
    }

    public void setStandbyPort(int n) {
        this.standbyPort = n;
    }

    public String getStandbyAccessKey() {
        return this.standbyAccessKey;
    }

    public void setStandbyAccessKey(String string) {
        this.standbyAccessKey = string;
    }

    public String getStandbySecretKey() {
        return this.standbySecretKey;
    }

    public String getServerMode() {
        return this.serverMode;
    }

    public void setStandbySecretKey(String string) {
        this.standbySecretKey = string;
    }

    public void setStandBy(boolean bl) {
        this.isStandByEnabled = bl;
    }

    public boolean isStandbySyncForce() {
        return this.standbySyncForce;
    }

    public int getStandbySyncThreads() {
        return this.standbySyncThreads;
    }

    public int getFileCacheInitialCapacity() {
        return this.fileCacheIntialCapacity;
    }

    public long getRetryFailedSeconds() {
        return this.retryFailedSeconds;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public int getObjectCacheInitialCapacity() {
        return this.objectCacheInitialCapacity;
    }

    public int getTotalDisks() {
        return this.totalDisks;
    }

    public synchronized OdilonServerInfo getDefaultOdilonServerInfo() {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        OdilonServerInfo odilonServerInfo = new OdilonServerInfo();
        odilonServerInfo.setCreationDate(offsetDateTime);
        odilonServerInfo.setName("Odilon");
        odilonServerInfo.setVersionControl(this.isVersionControl());
        odilonServerInfo.setEncryptionIntialized(false);
        if (this.isVersionControl()) {
            odilonServerInfo.setVersionControlDate(offsetDateTime);
        }
        odilonServerInfo.setServerMode(this.getServerMode());
        odilonServerInfo.setId(this.randomString(16));
        odilonServerInfo.setStandByEnabled(this.isStandByEnabled());
        odilonServerInfo.setStandbyUrl(this.getStandbyUrl());
        odilonServerInfo.setStandbyPort(this.getStandbyPort());
        odilonServerInfo.setStandBySyncedDate(null);
        odilonServerInfo.setRedundancyLevel(this.getRedundancyLevel().getName());
        if (this.isStandByEnabled()) {
            odilonServerInfo.setStandByStartDate(offsetDateTime);
        }
        return odilonServerInfo;
    }

    public long getObjectCacheCapacity() {
        return this.objectCacheMaxCapacity;
    }

    public long getObjectCacheExpireDays() {
        return this.objectExpireDays;
    }

    public long getFileCacheMaxCapacity() {
        return this.fileCacheMaxCapacity;
    }

    public long getFileCacheDurationDays() {
        return this.fileCacheDurationDays;
    }

    public boolean isRAID6ConfigurationValid(int n, int n2) {
        return n == 32 && n2 == 16 || n == 16 && n2 == 8 || n == 8 && n2 == 4 || n == 4 && n2 == 2 || n == 2 && n2 == 1;
    }

    public DataStorage getDataStorage() {
        return this.dataStorage;
    }

    public boolean isPingEnabled() {
        return this.pingEnabled;
    }

    protected String randomString(int n) {
        return idGenerator.randomString(n);
    }

    private void exit(String string) {
        logger.error(new String[]{"---------------------------------"});
        logger.error(new String[]{string});
        logger.error(new String[]{"check file ." + File.separator + "config" + File.separator + "odilon.properties"});
        logger.error(new String[]{"---------------------------------"});
        System.exit(1);
    }

    public String getPresignedSalt() {
        return this.presignedSalt;
    }

    public int getR6BufferPoolSize() {
        return this.raidSixBuffers;
    }

    public int getR6BufferSizeMB() {
        return 0x2000000;
    }

    private boolean isWindows() {
        return System.getenv("OS") != null && System.getenv("OS").toLowerCase().contains("windows");
    }
}

