/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.service;

import io.odilon.log.Logger;
import io.odilon.util.Check;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Timer
implements Runnable {
    public static Logger logger = Logger.getLogger((String)Timer.class.getName());
    private AtomicBoolean exit = new AtomicBoolean(false);
    private Thread thread;

    public abstract void onTimeUp();

    public boolean exit() {
        return this.exit.get();
    }

    public void sendExitSignal() {
        this.exit.set(true);
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public long getSleepTimeMillis() {
        return 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Check.checkTrue((this.getSleepTimeMillis() > 100L ? 1 : 0) != 0, (String)("sleep time must be > 100 milisecs -> " + String.valueOf(this.getSleepTimeMillis())));
        this.thread = Thread.currentThread();
        Timer timer = this;
        synchronized (timer) {
            while (!this.exit()) {
                try {
                    Thread.sleep(this.getSleepTimeMillis());
                    this.onTimeUp();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

