/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.traffic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.json.OdilonObjectMapper;
import io.odilon.log.Logger;
import io.odilon.model.JSONObject;
import io.odilon.traffic.TrafficPass;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OdilonTrafficPass
implements TrafficPass,
JSONObject {
    private static Logger logger = Logger.getLogger((String)OdilonTrafficPass.class.getName());
    private static final ObjectMapper mapper = new OdilonObjectMapper();
    private static final long serialVersionUID = 1L;
    private final int id;
    private String caller;
    private OffsetDateTime started;

    public OdilonTrafficPass(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void setCaller(String string) {
        this.caller = string;
    }

    public Optional<String> getCaller() {
        return this.caller == null ? Optional.empty() : Optional.of(this.caller);
    }

    public String toJSON() {
        try {
            return this.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return "\"error\":\"" + exception.getClass().getName() + " | " + exception.getMessage() + "\"";
        }
    }

    @JsonIgnore
    public ObjectMapper getObjectMapper() {
        return mapper;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    public OffsetDateTime getStarted() {
        return this.started;
    }

    public void setStarted(OffsetDateTime offsetDateTime) {
        this.started = offsetDateTime;
    }
}

