/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.traffic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.traffic.OdilonTrafficPass;
import io.odilon.traffic.TrafficPass;
import jakarta.annotation.PostConstruct;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrafficControlService
extends BaseService {
    private static Logger logger = Logger.getLogger((String)TrafficControlService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    private Set<TrafficPass> passes = null;
    @JsonIgnore
    private Set<TrafficPass> passesInUse = null;
    @JsonProperty(value="waittimeout")
    private long waittimeout = 6000L;
    @JsonProperty(value="tokens")
    private int tokens = 12;
    @JsonProperty(value="timeOutPassMin")
    private int timeOutPassMin = 3;

    public TrafficControlService(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrafficPass getPass(String string) {
        TrafficPass trafficPass2 = null;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        boolean bl = false;
        while (trafficPass2 == null) {
            TrafficControlService trafficControlService = this;
            synchronized (trafficControlService) {
                if (!this.passes.isEmpty()) {
                    trafficPass2 = (TrafficPass)this.passes.iterator().next();
                    this.passes.remove(trafficPass2);
                    trafficPass2.setCaller(string);
                    trafficPass2.setStarted(OffsetDateTime.now());
                    this.passesInUse.add(trafficPass2);
                }
            }
            if (trafficPass2 != null) continue;
            l2 = System.currentTimeMillis() - l;
            if (l2 > this.waittimeout) {
                boolean bl2 = true;
                logger.error(new String[]{"TimeoutException  | Waited " + String.valueOf(l2) + " ms | passes = " + this.passes.toString()});
                logger.error(new String[]{"Passes in use -> "});
                this.passesInUse.forEach(trafficPass -> logger.error(new String[]{trafficPass.toString()}));
                logger.error(new String[]{"Passes available  -> "});
                this.passes.forEach(trafficPass -> logger.error(new String[]{trafficPass.toString()}));
                for (TrafficPass trafficPass3 : this.passesInUse) {
                    if (!trafficPass3.getStarted().isBefore(OffsetDateTime.now().minusMinutes(this.timeOutPassMin))) continue;
                    logger.error(new String[]{"Traffic pass taking over " + String.valueOf(this.timeOutPassMin) + " min, probably lost called by -> " + String.valueOf(trafficPass3.getCaller())});
                    logger.debug("Adding traffic pass to the pool");
                    this.passes.add(new OdilonTrafficPass(this.passes.size()));
                    bl2 = false;
                }
                if (bl2) {
                    throw new RuntimeException("TimeoutException | could not get a pass | passes -> " + this.passes.toString());
                }
            }
            trafficControlService = this;
            synchronized (trafficControlService) {
                try {
                    if (!bl) {
                        bl = true;
                    }
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return trafficPass2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(TrafficPass trafficPass) {
        if (trafficPass == null) {
            return;
        }
        TrafficControlService trafficControlService = this;
        synchronized (trafficControlService) {
            this.passes.add(trafficPass);
            this.passesInUse.remove(trafficPass);
            this.notify();
        }
    }

    public void setTimeout(long l) {
        this.waittimeout = l;
    }

    @PostConstruct
    protected synchronized void onInitialize() {
        this.setStatus(ServiceStatus.STARTING);
        this.tokens = this.serverSettings.getMaxTrafficTokens();
        this.createPasses();
        this.setStatus(ServiceStatus.RUNNING);
        startuplogger.debug("Started -> " + TrafficControlService.class.getSimpleName());
    }

    protected synchronized void createPasses() {
        this.passes = Collections.synchronizedSet(new HashSet(this.tokens));
        this.passesInUse = Collections.synchronizedSet(new HashSet(this.tokens));
        for (int i = 0; i < this.tokens; ++i) {
            this.passes.add(new OdilonTrafficPass(i));
        }
        logger.debug("Created Traffic passes -> " + String.valueOf(this.tokens));
    }
}

