/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.cache.ObjectMetadataCacheService;
import io.odilon.encryption.EncryptionService;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.error.OdilonServerAPIException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.json.OdilonObjectMapper;
import io.odilon.log.Logger;
import io.odilon.model.BucketMetadata;
import io.odilon.model.BucketStatus;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.RedundancyLevel;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.query.BucketIteratorService;
import io.odilon.replication.ReplicationService;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.SchedulerService;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.service.ServerSettings;
import io.odilon.service.util.ByteToString;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.BucketPath;
import io.odilon.virtualFileSystem.Context;
import io.odilon.virtualFileSystem.OdilonBucket;
import io.odilon.virtualFileSystem.OdilonDrive;
import io.odilon.virtualFileSystem.OdilonVirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveBucket;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class BaseIODriver
implements IODriver,
ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)BaseIODriver.class.getName());
    private static Logger std_logger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    public static final int MAX_CACHE_SIZE = 4000000;
    @JsonIgnore
    private static ObjectMapper mapper = new OdilonObjectMapper();
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystem;
    @JsonIgnore
    private LockService lockService;
    @JsonIgnore
    private List<Drive> drivesEnabled;
    @JsonIgnore
    private List<Drive> drivesAll;
    @JsonIgnore
    private ApplicationContext applicationContext;

    public abstract void rollback(VirtualFileSystemOperation var1, Object var2, boolean var3);

    public BaseIODriver(VirtualFileSystemService virtualFileSystemService, LockService lockService) {
        this.virtualFileSystem = virtualFileSystemService;
        this.lockService = lockService;
    }

    public abstract RedundancyLevel getRedundancyLevel();

    public boolean existsBucket(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        this.bucketReadLock(string);
        try {
            boolean bl = this.existsCacheBucket(string);
            return bl;
        }
        finally {
            this.bucketReadUnLock(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerBucket createBucket(String string) {
        OdilonBucket odilonBucket;
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        if (!string.matches("[A-Za-z0-9\\-_]+")) {
            throw new IllegalArgumentException("bucketName contains invalid character | regular expression is -> [A-Za-z0-9\\-_]+ |  b:" + string);
        }
        BucketMetadata bucketMetadata = new BucketMetadata(string);
        bucketMetadata.setStatus(BucketStatus.ENABLED);
        bucketMetadata.setAppVersion("1.15");
        bucketMetadata.setId(this.getVirtualFileSystemService().getNextBucketId());
        OdilonBucket odilonBucket2 = new OdilonBucket(bucketMetadata);
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        this.bucketWriteLock(string);
        try {
            this.checkNotExistsBucket((ServerBucket)odilonBucket2);
            virtualFileSystemOperation = this.getJournalService().createBucket(bucketMetadata);
            OffsetDateTime offsetDateTime = OffsetDateTime.now();
            bucketMetadata.setCreationDate(offsetDateTime);
            bucketMetadata.setLastModified(offsetDateTime);
            for (Drive drive : this.getDrivesAll()) {
                try {
                    drive.createBucket(bucketMetadata);
                }
                catch (Exception exception) {
                    bl = false;
                    bl2 = true;
                    throw new InternalCriticalException(exception, this.objectInfo(drive));
                }
            }
            bl = virtualFileSystemOperation.commit((Object)odilonBucket2);
            odilonBucket = odilonBucket2;
        }
        catch (Throwable throwable) {
            try {
                if (!bl) {
                    this.rollback(virtualFileSystemOperation, (Object)odilonBucket2);
                }
            }
            catch (Exception exception) {
                if (!bl2) {
                    if (exception instanceof InternalCriticalException) {
                        throw exception;
                    }
                    throw new InternalCriticalException(exception, this.objectInfo(bucketMetadata));
                }
                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            }
            finally {
                this.bucketWriteUnLock(string);
            }
            throw throwable;
        }
        try {
            if (!bl) {
                this.rollback(virtualFileSystemOperation, (Object)odilonBucket2);
            }
        }
        catch (Exception exception) {
            if (!bl2) {
                if (exception instanceof InternalCriticalException) {
                    throw exception;
                }
                throw new InternalCriticalException(exception, this.objectInfo(bucketMetadata));
            }
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
        finally {
            this.bucketWriteUnLock(string);
        }
        return odilonBucket;
    }

    public ServerBucket getBucket(String string) {
        Check.requireNonNullArgument((Object)string, (String)"bucket is null");
        this.bucketReadLock(string);
        try {
            this.checkExistsBucket(string);
            ServerBucket serverBucket = this.getCacheBucket(string);
            return serverBucket;
        }
        finally {
            this.bucketReadUnLock(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerBucket renameBucket(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        BucketMetadata bucketMetadata = null;
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        String string2 = serverBucket.getName();
        this.bucketWriteLock(string2);
        try {
            ServerBucket serverBucket2;
            this.bucketWriteLock(string);
            try {
                this.checkExistsBucket(serverBucket);
                this.checkNotExistsBucket(string);
                virtualFileSystemOperation = this.getJournalService().updateBucket(serverBucket, string);
                this.backupBucketMetadata(serverBucket);
                bucketMetadata = serverBucket.getBucketMetadata();
                bucketMetadata.setLastModified(offsetDateTime);
                bucketMetadata.setBucketName(string);
                for (Drive drive : this.getDrivesAll()) {
                    try {
                        drive.updateBucket(bucketMetadata);
                    }
                    catch (IOException iOException) {
                        bl = false;
                        throw new InternalCriticalException((Exception)iOException, this.objectInfo(drive));
                    }
                    catch (Exception exception) {
                        bl = false;
                        throw new InternalCriticalException(exception, this.objectInfo(drive));
                    }
                }
                bl = virtualFileSystemOperation.commit((Object)serverBucket);
                serverBucket2 = serverBucket;
            }
            catch (Throwable throwable) {
                try {
                    if (!bl) {
                        this.rollback(virtualFileSystemOperation);
                    }
                }
                finally {
                    this.bucketWriteUnLock(string);
                }
                throw throwable;
            }
            try {
                if (!bl) {
                    this.rollback(virtualFileSystemOperation);
                }
            }
            finally {
                this.bucketWriteUnLock(string);
            }
            return serverBucket2;
        }
        finally {
            this.bucketWriteUnLock(string2);
        }
    }

    public void removeBucket(ServerBucket serverBucket) {
        this.removeBucket(serverBucket, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBucket(ServerBucket serverBucket, boolean bl) {
        block15: {
            Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null");
            boolean bl2 = false;
            VirtualFileSystemOperation virtualFileSystemOperation = null;
            this.bucketWriteLock(serverBucket);
            try {
                block14: {
                    try {
                        this.checkExistsBucket(serverBucket);
                        if (!bl && !this.isEmpty(serverBucket)) {
                            throw new OdilonServerAPIException("bucket must be empty to be deleted -> b:" + serverBucket.getName());
                        }
                        virtualFileSystemOperation = this.getJournalService().deleteBucket(serverBucket);
                        for (Drive drive : this.getDrivesAll()) {
                            try {
                                drive.markAsDeletedBucket(serverBucket);
                            }
                            catch (Exception exception) {
                                bl2 = false;
                                throw new InternalCriticalException(exception);
                            }
                        }
                        bl2 = virtualFileSystemOperation.commit((Object)serverBucket);
                        if (!bl2) break block14;
                        if (serverBucket == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            if (serverBucket != null) {
                                for (Drive drive : this.getDrivesAll()) {
                                    ((OdilonDrive)drive).forceDeleteBucketById(serverBucket.getId());
                                }
                            }
                        } else {
                            this.rollback(virtualFileSystemOperation);
                        }
                        throw throwable;
                    }
                    for (Drive drive : this.getDrivesAll()) {
                        ((OdilonDrive)drive).forceDeleteBucketById(serverBucket.getId());
                    }
                    break block15;
                }
                this.rollback(virtualFileSystemOperation);
            }
            finally {
                this.bucketWriteUnLock(serverBucket);
            }
        }
    }

    public boolean isEmpty(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)(ServerBucket.class.getSimpleName() + " is null"));
        this.bucketReadLock(serverBucket);
        try {
            this.checkExistsBucket(serverBucket);
            for (Drive drive : this.getDrivesEnabled()) {
                if (drive.isEmpty(serverBucket)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (exception instanceof InternalCriticalException) {
                throw exception;
            }
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket));
        }
        finally {
            this.bucketReadUnLock(serverBucket);
        }
    }

    protected boolean generalRollbackJournal(VirtualFileSystemOperation virtualFileSystemOperation) {
        Long l = virtualFileSystemOperation.getBucketId();
        try {
            if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_BUCKET) {
                this.removeCacheBucket(l);
                for (Drive drive : this.getDrivesAll()) {
                    ((OdilonDrive)drive).forceDeleteBucketById(l);
                }
                return true;
            }
            if (virtualFileSystemOperation.getOperationCode() == OperationCode.DELETE_BUCKET) {
                BucketMetadata bucketMetadata = null;
                for (Drive drive : this.getDrivesAll()) {
                    drive.markAsEnabledBucket(this.getCacheBucket(l));
                    if (bucketMetadata != null) continue;
                    bucketMetadata = drive.getBucketMetadataById(l);
                    break;
                }
                if (bucketMetadata != null) {
                    OdilonBucket odilonBucket = new OdilonBucket(bucketMetadata);
                    this.addCacheBucket((ServerBucket)odilonBucket);
                }
                return true;
            }
            if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_BUCKET) {
                this.restoreBucketMetadata(this.getCacheBucket(l));
                BucketMetadata bucketMetadata = null;
                for (Drive drive : this.getDrivesAll()) {
                    if (bucketMetadata != null) continue;
                    bucketMetadata = drive.getBucketMetadataById(l);
                    break;
                }
                if (bucketMetadata != null) {
                    OdilonBucket odilonBucket = new OdilonBucket(bucketMetadata);
                    this.addCacheBucket((ServerBucket)odilonBucket);
                }
                return true;
            }
            if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_SERVER_MASTERKEY) {
                for (Drive drive : this.getDrivesAll()) {
                    File file = drive.getSysFile("key.enc");
                    if (file == null || !file.exists()) continue;
                    FileUtils.forceDelete((File)file);
                }
                return true;
            }
            if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_SERVER_METADATA) {
                if (virtualFileSystemOperation.getObjectName() != null) {
                    for (Drive drive : this.getDrivesAll()) {
                        drive.removeSysFile(virtualFileSystemOperation.getObjectName());
                    }
                }
                return true;
            }
            if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_SERVER_METADATA) {
                logger.debug("no action yet, rollback -> " + OperationCode.UPDATE_SERVER_METADATA.getName());
                return true;
            }
        }
        catch (InternalCriticalException internalCriticalException) {
            throw internalCriticalException;
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public ObjectMetadata getObjectMetadataPreviousVersion(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName can not be null | b:" + serverBucket.getName()));
        this.objectReadLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                this.checkExistsBucket(serverBucket);
                List list = this.getObjectMetadataVersionAll(serverBucket, string);
                if (list != null && !list.isEmpty()) {
                    ObjectMetadata objectMetadata = (ObjectMetadata)list.get(list.size() - 1);
                    return objectMetadata;
                }
                ObjectMetadata objectMetadata = null;
                return objectMetadata;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    public void putObject(ServerBucket serverBucket, String string, File file) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName can not be null | b:" + serverBucket.getName()));
        Check.requireNonNullArgument((Object)file, (String)("file is null | b:" + serverBucket.getName()));
        Path path = file.toPath();
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("'" + file.getName() + "' -> not a regular file");
        }
        String string2 = null;
        try {
            string2 = Files.probeContentType(path);
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(serverBucket, string));
        }
        try {
            this.putObject(serverBucket, string, (InputStream)new BufferedInputStream(new FileInputStream(file)), file.getName(), string2, Optional.empty());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InternalCriticalException((Exception)fileNotFoundException, this.objectInfo(serverBucket, string));
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public synchronized List<ServiceRequest> getSchedulerPendingRequests(String string2) {
        ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
        HashMap<String, File> hashMap = new HashMap<String, File>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        for (Drive drive2 : this.getDrivesEnabled()) {
            hashMap3.put(drive2, new HashMap());
            for (File file2 : drive2.getSchedulerRequests(string2)) {
                ((Map)hashMap3.get(drive2)).put(file2.getName(), file2);
            }
        }
        Drive drive3 = (Drive)this.getDrivesEnabled().get(0);
        ((Map)hashMap3.get(drive3)).forEach((string, file) -> {
            boolean bl = true;
            for (Drive drive2 : this.getDrivesEnabled()) {
                if (drive2.equals((Object)drive3) || ((Map)hashMap3.get(drive2)).containsKey(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                hashMap.put((String)string, (File)file);
            } else {
                hashMap2.put(string, file);
            }
        });
        hashMap.forEach((string, file) -> {
            try {
                AbstractServiceRequest abstractServiceRequest = (AbstractServiceRequest)this.getObjectMapper().readValue(file, AbstractServiceRequest.class);
                arrayList.add((ServiceRequest)abstractServiceRequest);
            }
            catch (IOException iOException) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException iOException2) {
                    logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                }
            }
        });
        this.getDrivesEnabled().forEach(drive -> ((Map)hashMap3.get(drive)).forEach((string, file) -> {
            if (!hashMap.containsKey(string)) {
                try {
                    Files.delete(file.toPath());
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                }
            }
        }));
        return arrayList;
    }

    public List<VirtualFileSystemOperation> getJournalPending(JournalService journalService) {
        ArrayList<VirtualFileSystemOperation> arrayList = new ArrayList<VirtualFileSystemOperation>();
        for (Drive drive : this.getDrivesEnabled()) {
            File[] fileArray;
            File file = new File(drive.getJournalDirPath());
            if (!file.exists()) {
                return arrayList;
            }
            if (!file.isDirectory()) {
                return arrayList;
            }
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) continue;
                Path path = Paths.get(file2.getAbsolutePath(), new String[0]);
                try {
                    String string = Files.readString(path);
                    OdilonVirtualFileSystemOperation odilonVirtualFileSystemOperation = (OdilonVirtualFileSystemOperation)this.getObjectMapper().readValue(string, OdilonVirtualFileSystemOperation.class);
                    odilonVirtualFileSystemOperation.setJournalService(this.getJournalService());
                    if (arrayList.contains(odilonVirtualFileSystemOperation)) continue;
                    arrayList.add((VirtualFileSystemOperation)odilonVirtualFileSystemOperation);
                }
                catch (IOException iOException) {
                    try {
                        Files.delete(file2.toPath());
                    }
                    catch (IOException iOException2) {
                        logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                    }
                }
            }
        }
        std_logger.debug("Total operations that will rollback -> " + String.valueOf(arrayList.size()));
        return arrayList;
    }

    public OdilonServerInfo getServerInfo() {
        File file = ((Drive)this.getDrivesEnabled().get(0)).getSysFile("odilon.json");
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            this.getLockService().getServerLock().readLock().lock();
            OdilonServerInfo odilonServerInfo = (OdilonServerInfo)this.getObjectMapper().readValue(file, OdilonServerInfo.class);
            return odilonServerInfo;
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException);
        }
        finally {
            this.getLockService().getServerLock().readLock().unlock();
        }
    }

    public void setServerInfo(OdilonServerInfo odilonServerInfo) {
        Check.requireNonNullArgument((Object)odilonServerInfo, (String)"serverInfo is null");
        if (this.getServerInfo() == null) {
            this.saveNewServerInfo(odilonServerInfo);
        } else {
            this.updateServerInfo(odilonServerInfo);
        }
    }

    public byte[] getServerMasterKey() {
        this.getLockService().getServerLock().readLock().lock();
        try {
            byte[] byArray;
            File file = ((Drive)this.getDrivesEnabled().get(0)).getSysFile("key.enc");
            if (file == null || !file.exists()) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray3 = FileUtils.readFileToByteArray((File)file);
            String string = this.getVirtualFileSystemService().getServerSettings().getEncryptionKey();
            String string2 = this.getVirtualFileSystemService().getServerSettings().getEncryptionIV();
            if (string == null || string2 == null) {
                throw new InternalCriticalException(" encryption Key or IV is null");
            }
            byte[] byArray4 = ByteToString.hexStringToByte((String)string);
            byte[] byArray5 = ByteToString.hexStringToByte((String)(string + string2));
            try {
                byArray = this.getVirtualFileSystemService().HMAC(byArray5, byArray4);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                throw new InternalCriticalException((Exception)generalSecurityException, "can not calculate HMAC for 'odilon.properties' encryption key");
            }
            byte[] byArray6 = this.getVirtualFileSystemService().getMasterKeyEncryptorService().decryptKey(byArray3);
            byte[] byArray7 = new byte[32];
            System.arraycopy(byArray6, 0, byArray7, 0, byArray7.length);
            if (!Arrays.equals(byArray, byArray7)) {
                logger.error(new String[]{"HMAC of 'encryption.key' in 'odilon.properties' does not match with HMAC in 'key.enc'  -> encryption.key=" + string + string2});
                throw new InternalCriticalException("HMAC of 'encryption.key' in 'odilon.properties' does not match with HMAC in 'key.enc'  -> encryption.key=" + string + string2);
            }
            byte[] byArray8 = new byte[16];
            System.arraycopy(byArray6, byArray7.length, byArray8, 0, byArray8.length);
            byte[] byArray9 = byArray8;
            return byArray9;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (internalCriticalException.getCause() != null && internalCriticalException.getCause() instanceof BadPaddingException) {
                logger.error(new String[]{"possible cause -> the value of 'encryption.key' in 'odilon.properties' is incorrect"});
            }
            throw internalCriticalException;
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, "getServerMasterKey");
        }
        finally {
            this.getLockService().getServerLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveServerMasterKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Check.requireNonNullArgument((Object)byArray, (String)"key is null");
        Check.requireNonNullArgument((Object)byArray4, (String)"salt is null");
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        this.getLockService().getServerLock().writeLock().lock();
        try {
            Object object2222222;
            for (Object object2222222 : this.getDrivesAll()) {
            }
            virtualFileSystemOperation = this.getJournalService().saveServerKey();
            bl2 = true;
            Object object3 = null;
            object2222222 = new byte[byArray2.length + byArray3.length + byArray.length + byArray4.length];
            System.arraycopy(byArray2, 0, object2222222, 0, byArray2.length);
            System.arraycopy(byArray, 0, object2222222, byArray2.length, byArray.length);
            System.arraycopy(byArray3, 0, object2222222, byArray2.length + byArray.length, byArray3.length);
            System.arraycopy(byArray4, 0, object2222222, byArray2.length + byArray3.length + byArray.length, byArray4.length);
            byte[] byArray5 = this.getVirtualFileSystemService().getMasterKeyEncryptorService().encryptKey((byte[])object2222222, byArray3);
            for (Drive drive : this.getDrivesAll()) {
                try {
                    File file = drive.getSysFile("key.enc");
                    FileUtils.writeByteArrayToFile((File)file, (byte[])byArray5);
                }
                catch (Exception exception) {
                    object3 = new InternalCriticalException(exception, this.objectInfo(drive));
                    break;
                }
            }
            if (object3 != null) {
                throw object3;
            }
            bl = virtualFileSystemOperation.commit();
        }
        catch (InternalCriticalException internalCriticalException) {
            try {
                throw internalCriticalException;
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) throw new InternalCriticalException(exception, "saveServerMasterKey");
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    throw new InternalCriticalException(exception, "saveServerMasterKey");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bl) throw throwable;
                    if (!bl2) {
                        virtualFileSystemOperation.cancel();
                        throw throwable;
                    }
                    this.rollback(virtualFileSystemOperation);
                    throw throwable;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    throw throwable;
                }
                finally {
                    this.getLockService().getServerLock().writeLock().unlock();
                }
            }
        }
        try {
            if (bl) return;
            if (!bl2) {
                virtualFileSystemOperation.cancel();
                return;
            }
            this.rollback(virtualFileSystemOperation);
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return;
        }
        finally {
            this.getLockService().getServerLock().writeLock().unlock();
        }
    }

    public synchronized List<Drive> getDrivesEnabled() {
        if (this.drivesEnabled != null) {
            return this.drivesEnabled;
        }
        this.drivesEnabled = new ArrayList();
        this.getVirtualFileSystemService().getMapDrivesEnabled().forEach((string, drive) -> this.drivesEnabled.add(drive));
        this.drivesEnabled.sort(new /* Unavailable Anonymous Inner Class!! */);
        return this.drivesEnabled;
    }

    public synchronized List<Drive> getDrivesAll() {
        if (this.drivesAll != null) {
            return this.drivesAll;
        }
        this.drivesAll = new ArrayList();
        this.getVirtualFileSystemService().getMapDrivesAll().forEach((string, drive) -> this.drivesAll.add(drive));
        this.drivesAll.sort(new /* Unavailable Anonymous Inner Class!! */);
        return this.drivesAll;
    }

    public boolean isEncrypt() {
        return this.getVirtualFileSystemService().isEncrypt();
    }

    public void saveScheduler(ServiceRequest serviceRequest, String string) {
        for (Drive drive : this.getDrivesEnabled()) {
            drive.saveScheduler(serviceRequest, string);
        }
    }

    public void removeScheduler(ServiceRequest serviceRequest, String string) {
        for (Drive drive : this.getDrivesEnabled()) {
            drive.removeScheduler(serviceRequest, string);
        }
    }

    public void saveJournal(VirtualFileSystemOperation virtualFileSystemOperation) {
        for (Drive drive : this.getDrivesEnabled()) {
            drive.saveJournal(virtualFileSystemOperation);
        }
    }

    public void removeJournal(String string) {
        for (Drive drive : this.getDrivesEnabled()) {
            drive.removeJournal(string);
        }
    }

    public boolean isStandByEnabled() {
        return this.getVirtualFileSystemService().getServerSettings().isStandByEnabled();
    }

    public void rollback(VirtualFileSystemOperation virtualFileSystemOperation) {
        if (virtualFileSystemOperation == null) {
            return;
        }
        if (this.isStandByEnabled()) {
            this.getReplicationService().cancel(virtualFileSystemOperation);
        }
        this.rollback(virtualFileSystemOperation, null, false);
    }

    public void rollback(VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        if (virtualFileSystemOperation == null) {
            return;
        }
        if (this.isStandByEnabled()) {
            this.getReplicationService().cancel(virtualFileSystemOperation);
        }
        this.rollback(virtualFileSystemOperation, null, bl);
    }

    public void rollback(VirtualFileSystemOperation virtualFileSystemOperation, Object object) {
        if (virtualFileSystemOperation == null) {
            return;
        }
        if (this.isStandByEnabled()) {
            this.getReplicationService().cancel(virtualFileSystemOperation);
        }
        this.rollback(virtualFileSystemOperation, object, false);
    }

    public ObjectMapper getObjectMapper() {
        return mapper;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public JournalService getJournalService() {
        return this.getVirtualFileSystemService().getJournalService();
    }

    public SchedulerService getSchedulerService() {
        return this.getVirtualFileSystemService().getSchedulerService();
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        return this.virtualFileSystem;
    }

    public void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        this.virtualFileSystem = virtualFileSystemService;
    }

    public String opInfo(VirtualFileSystemOperation virtualFileSystemOperation) {
        return "op:" + (virtualFileSystemOperation != null ? virtualFileSystemOperation.toString() : "null");
    }

    public String objectInfo(BucketMetadata bucketMetadata) {
        if (bucketMetadata == null) {
            return "b: null";
        }
        return "b_id:" + (bucketMetadata.getId() != null ? bucketMetadata.getId().toString() : "null") + " bn:" + (bucketMetadata.getBucketName() != null ? bucketMetadata.getBucketName() : "null");
    }

    public String objectInfo(Drive drive) {
        if (drive == null) {
            return "d: null";
        }
        return "d:" + drive.getName();
    }

    public String objectInfo(ServerBucket serverBucket) {
        if (serverBucket == null) {
            return "b: null";
        }
        return "b_id:" + (serverBucket.getId() != null ? serverBucket.getId().toString() : "null") + " bn:" + (serverBucket.getName() != null ? serverBucket.getName() : "null");
    }

    public String objectInfo(Long l, String string) {
        return "b_id:" + (l != null ? l.toString() : "null") + " o:" + (string != null ? string : "null");
    }

    public String objectInfo(String string) {
        return "bn:" + (string != null ? string : "null");
    }

    public String objectInfo(String string, String string2) {
        return "bn:" + (string != null ? string : "null") + " o:" + (string2 != null ? string2 : "null");
    }

    public String objectInfo(ServerBucket serverBucket, String string, int n) {
        if (serverBucket == null) {
            return this.objectInfo("null", string);
        }
        return this.objectInfo(serverBucket.getName(), string, n);
    }

    public String objectInfo(String string, String string2, int n) {
        return "bn:" + (string != null ? string : "null") + " o:" + (string2 != null ? string2 : "null") + "v:" + String.valueOf(n);
    }

    public String objectInfo(ServerBucket serverBucket, String string, Drive drive) {
        return "bn:" + (serverBucket != null ? serverBucket.getName() : "null") + " o:" + (string != null ? string : "null") + " d:" + (drive != null ? drive.getName() : "null");
    }

    public String objectInfo(ServerBucket serverBucket, Drive drive) {
        return "bn:" + (serverBucket != null ? serverBucket.getName() : "null") + " d:" + (drive != null ? drive.getName() : "null");
    }

    public String objectInfo(ServerBucket serverBucket, String string) {
        if (serverBucket == null) {
            return this.objectInfo("null", string);
        }
        return this.objectInfo(serverBucket.getName(), string);
    }

    public String objectInfo(ServerBucket serverBucket, String string, String string2) {
        if (serverBucket == null) {
            return this.objectInfo("null", string, string2);
        }
        return this.objectInfo(serverBucket.getName(), string, string2);
    }

    public String objectInfo(ObjectMetadata objectMetadata) {
        if (objectMetadata == null) {
            return "om: null";
        }
        if (objectMetadata.getBucketName() != null) {
            return this.objectInfo(objectMetadata.getBucketName(), objectMetadata.getObjectName());
        }
        return this.objectInfo(objectMetadata.getBucketId(), objectMetadata.getObjectName());
    }

    public String objectInfo(String string, String string2, String string3) {
        return "bn:" + (string != null ? string.toString() : "null") + " o:" + (string2 != null ? string2 : "null") + (String)(string3 != null ? " f:" + string3 : "");
    }

    public int getTotalDisks() {
        return this.getVirtualFileSystemService().getServerSettings().getTotalDisks();
    }

    protected abstract Drive getObjectMetadataReadDrive(ServerBucket var1, String var2);

    protected ObjectMetadata getMetadata(ServerBucket serverBucket, String string) {
        return this.getDriverObjectMetadataInternal(serverBucket, string, true);
    }

    protected ObjectMetadata getDriverObjectMetadataInternal(ServerBucket serverBucket, String string, boolean bl) {
        if (!this.getServerSettings().isUseObjectCache()) {
            ObjectMetadata objectMetadata = this.getObjectMetadataReadDrive(serverBucket, string).getObjectMetadata(serverBucket, string);
            objectMetadata.setBucketName(serverBucket.getName());
            return objectMetadata;
        }
        if (this.getObjectMetadataCacheService().containsKey(serverBucket, string)) {
            this.getSystemMonitorService().getCacheObjectHitCounter().inc();
            ObjectMetadata objectMetadata = this.getObjectMetadataCacheService().get(serverBucket, string);
            objectMetadata.setBucketName(serverBucket.getName());
            return objectMetadata;
        }
        ObjectMetadata objectMetadata = this.getObjectMetadataReadDrive(serverBucket, string).getObjectMetadata(serverBucket, string);
        if (objectMetadata == null) {
            return objectMetadata;
        }
        objectMetadata.setBucketName(serverBucket.getName());
        this.getVirtualFileSystemService().getSystemMonitorService().getCacheObjectMissCounter().inc();
        if (bl) {
            this.getObjectMetadataCacheService().put(serverBucket, string, objectMetadata);
        }
        return objectMetadata;
    }

    protected Map<String, ServerBucket> getBucketsMap() {
        Integer n;
        Object object;
        HashMap<String, ServerBucket> hashMap = new HashMap<String, ServerBucket>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        int n2 = this.getDrivesEnabled().size();
        for (Object object2 : this.getDrivesEnabled()) {
            for (Object object3 : object2.getBuckets()) {
                if (!object3.getStatus().isAccesible()) continue;
                object = object3.getName();
                n = hashMap2.containsKey(object) ? Integer.valueOf((Integer)hashMap2.get(object) + 1) : Integer.valueOf(1);
                hashMap2.put((String)object, n);
            }
        }
        Drive drive = (Drive)this.getDrivesEnabled().get(Double.valueOf(Math.abs(Math.random() * 1000.0)).intValue() % this.getDrivesEnabled().size());
        for (DriveBucket driveBucket : drive.getBuckets()) {
            Object object3;
            object3 = driveBucket.getName();
            if (!hashMap2.containsKey(object3) || (Integer)(object = (Integer)hashMap2.get(object3)) != n2) continue;
            n = new OdilonBucket(driveBucket);
            hashMap.put(n.getName(), (ServerBucket)n);
        }
        return hashMap;
    }

    protected void restoreBucketMetadata(ServerBucket serverBucket) {
        try {
            for (Drive drive : this.getDrivesAll()) {
                BucketPath bucketPath = new BucketPath(drive, serverBucket);
                Path path = bucketPath.bucketMetadata(Context.BACKUP);
                drive.updateBucket((BucketMetadata)this.getObjectMapper().readValue(path.toFile(), BucketMetadata.class));
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket));
        }
    }

    protected void backupBucketMetadata(ServerBucket serverBucket) {
        try {
            for (Drive drive : this.getDrivesAll()) {
                BucketMetadata bucketMetadata = drive.getBucketMetadata(serverBucket);
                BucketPath bucketPath = new BucketPath(drive, serverBucket);
                Path path = bucketPath.bucketMetadata(Context.BACKUP);
                Files.writeString(path, (CharSequence)this.getObjectMapper().writeValueAsString((Object)bucketMetadata), new OpenOption[0]);
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket));
        }
    }

    protected EncryptionService getEncryptionService() {
        return this.getVirtualFileSystemService().getEncryptionService();
    }

    protected BucketIteratorService getBucketIteratorService() {
        return this.getVirtualFileSystemService().getBucketIteratorService();
    }

    protected ServerSettings getServerSettings() {
        return this.getVirtualFileSystemService().getServerSettings();
    }

    protected ReplicationService getReplicationService() {
        return this.getVirtualFileSystemService().getReplicationService();
    }

    protected SystemMonitorService getSystemMonitorService() {
        return this.getVirtualFileSystemService().getSystemMonitorService();
    }

    protected void objectReadLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).readLock().lock();
    }

    protected void objectReadUnLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).readLock().unlock();
    }

    protected void objectWriteLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).writeLock().lock();
    }

    protected void objectWriteUnLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).writeLock().unlock();
    }

    protected void bucketReadLock(ServerBucket serverBucket) {
        this.getLockService().getBucketLock(serverBucket).readLock().lock();
    }

    protected void bucketReadLock(String string) {
        this.getLockService().getBucketLock(string).readLock().lock();
    }

    protected void bucketReadUnLock(String string) {
        this.getLockService().getBucketLock(string).readLock().unlock();
    }

    protected void bucketWriteLock(String string) {
        this.getLockService().getBucketLock(string).writeLock().lock();
    }

    protected void bucketWriteUnLock(String string) {
        this.getLockService().getBucketLock(string).writeLock().unlock();
    }

    protected void bucketReadUnLock(ServerBucket serverBucket) {
        this.getLockService().getBucketLock(serverBucket).readLock().unlock();
    }

    protected void bucketWriteLock(ServerBucket serverBucket) {
        this.getLockService().getBucketLock(serverBucket).writeLock().lock();
    }

    protected void bucketWriteUnLock(ServerBucket serverBucket) {
        this.getLockService().getBucketLock(serverBucket).writeLock().unlock();
    }

    protected void bucketWriteLock(BucketMetadata bucketMetadata) {
        this.getLockService().getBucketLock(bucketMetadata.getId()).writeLock().lock();
    }

    protected void bucketWriteUnLock(BucketMetadata bucketMetadata) {
        this.getLockService().getBucketLock(bucketMetadata.getId()).writeLock().unlock();
    }

    protected void checkExistBucket(ServerBucket serverBucket) {
        if (!this.existsCacheBucket(serverBucket)) {
            throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
        }
    }

    protected void addCacheBucket(ServerBucket serverBucket) {
        this.getVirtualFileSystemService().getBucketCache().add(serverBucket);
    }

    protected void updateCacheBucket(String string, OdilonBucket odilonBucket) {
        this.getVirtualFileSystemService().getBucketCache().update(string, (ServerBucket)odilonBucket);
    }

    protected void removeCacheBucket(ServerBucket serverBucket) {
        this.getVirtualFileSystemService().getBucketCache().remove(serverBucket.getId());
    }

    protected void removeCacheBucket(Long l) {
        this.getVirtualFileSystemService().getBucketCache().remove(l);
    }

    protected ServerBucket getCacheBucket(Long l) {
        return this.getVirtualFileSystemService().getBucketCache().get(l);
    }

    protected ServerBucket getCacheBucket(String string) {
        return this.getVirtualFileSystemService().getBucketCache().get(string);
    }

    protected boolean existsCacheBucket(String string) {
        return this.getVirtualFileSystemService().getBucketCache().contains(string);
    }

    protected boolean existsCacheBucket(Long l) {
        return this.getVirtualFileSystemService().getBucketCache().contains(l);
    }

    protected boolean existsCacheBucket(ServerBucket serverBucket) {
        return this.getVirtualFileSystemService().getBucketCache().contains(serverBucket);
    }

    protected ObjectMetadataCacheService getObjectMetadataCacheService() {
        return this.getVirtualFileSystemService().getObjectMetadataCacheService();
    }

    protected void checkIsAccesible(ServerBucket serverBucket) {
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible (ie. " + BucketStatus.ENABLED.getName() + " or " + BucketStatus.ENABLED.getName() + "  | b:" + serverBucket.getName()));
    }

    protected void checkNotExistsBucket(ServerBucket serverBucket) {
        if (this.existsCacheBucket(serverBucket)) {
            throw new IllegalArgumentException("bucket already exists -> " + this.objectInfo(serverBucket));
        }
    }

    protected void checkNotExistsBucket(String string) {
        if (this.getVirtualFileSystemService().getBucketCache().contains(string)) {
            throw new IllegalArgumentException("bucket already exists -> " + string);
        }
    }

    protected void checkExistsBucket(ServerBucket serverBucket) {
        if (!this.existsCacheBucket(serverBucket)) {
            throw new OdilonObjectNotFoundException("bucket does not exist -> " + this.objectInfo(serverBucket));
        }
    }

    protected void checkExistsBucket(String string) {
        if (!this.getVirtualFileSystemService().getBucketCache().contains(string)) {
            throw new IllegalArgumentException("bucket does not exist -> " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveNewServerInfo(OdilonServerInfo odilonServerInfo) {
        boolean bl = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        this.getLockService().getServerLock().writeLock().lock();
        try {
            virtualFileSystemOperation = this.getJournalService().createServerMetadata();
            String string = this.getObjectMapper().writeValueAsString((Object)odilonServerInfo);
            for (Drive drive : this.getDrivesAll()) {
                try {
                    drive.putSysFile("odilon.json", string);
                }
                catch (Exception exception) {
                    bl = false;
                    throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                }
            }
            bl = virtualFileSystemOperation.commit();
        }
        catch (Exception exception) {
            try {
                throw new InternalCriticalException(exception, odilonServerInfo.toString());
            }
            catch (Throwable throwable) {
                try {
                    if (bl) throw throwable;
                    this.rollback(virtualFileSystemOperation);
                    throw throwable;
                }
                catch (Exception exception2) {
                    logger.error((Throwable)exception2, new String[]{"---- not thrown ----"});
                    throw throwable;
                }
                finally {
                    this.getLockService().getServerLock().writeLock().unlock();
                }
            }
        }
        try {
            if (bl) return;
            this.rollback(virtualFileSystemOperation);
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return;
        }
        finally {
            this.getLockService().getServerLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateServerInfo(OdilonServerInfo odilonServerInfo) {
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        this.getLockService().getServerLock().writeLock().lock();
        try {
            virtualFileSystemOperation = this.getJournalService().updateServerMetadata();
            String string = this.getObjectMapper().writeValueAsString((Object)odilonServerInfo);
            for (Drive drive : this.getDrivesAll()) {
            }
            bl2 = true;
            for (Drive drive : this.getDrivesAll()) {
                try {
                    drive.putSysFile("odilon.json", string);
                }
                catch (Exception exception) {
                    bl = false;
                    throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                }
            }
            bl = virtualFileSystemOperation.commit();
        }
        catch (Exception exception) {
            try {
                throw new InternalCriticalException(exception, odilonServerInfo.toString());
            }
            catch (Throwable throwable) {
                try {
                    if (!bl2) {
                        virtualFileSystemOperation.cancel();
                        throw throwable;
                    }
                    if (bl) throw throwable;
                    this.rollback(virtualFileSystemOperation);
                    throw throwable;
                }
                catch (Exception exception2) {
                    logger.error((Throwable)exception2, new String[]{"---- not thrown ----"});
                    throw throwable;
                }
                finally {
                    this.getLockService().getServerLock().writeLock().unlock();
                }
            }
        }
        try {
            if (!bl2) {
                virtualFileSystemOperation.cancel();
                return;
            }
            if (bl) return;
            this.rollback(virtualFileSystemOperation);
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return;
        }
        finally {
            this.getLockService().getServerLock().writeLock().unlock();
        }
    }
}

