/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import io.odilon.cache.ObjectMetadataCacheService;
import io.odilon.encryption.EncryptionService;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.model.BaseObject;
import io.odilon.model.BucketMetadata;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.RedundancyLevel;
import io.odilon.replication.ReplicationService;
import io.odilon.scheduler.SchedulerService;
import io.odilon.service.ServerSettings;
import io.odilon.virtualFileSystem.BucketCache;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.File;

public abstract class BaseRAIDHandler
extends BaseObject {
    public abstract IODriver getDriver();

    protected abstract Drive getObjectMetadataReadDrive(ServerBucket var1, String var2);

    protected VirtualFileSystemOperation deleteObject(ServerBucket serverBucket, String string, int n) {
        return this.getJournalService().deleteObject(serverBucket, string, n);
    }

    protected VirtualFileSystemOperation createObject(ServerBucket serverBucket, String string) {
        return this.getJournalService().createObject(serverBucket, string);
    }

    protected VirtualFileSystemOperation updateObject(ServerBucket serverBucket, String string, int n) {
        return this.getJournalService().updateObject(serverBucket, string, n);
    }

    protected VirtualFileSystemOperation deleteObjectPreviousVersions(ServerBucket serverBucket, String string, int n) {
        return this.getJournalService().deleteObjectPreviousVersions(serverBucket, string, n);
    }

    protected SchedulerService getSchedulerService() {
        return this.getVirtualFileSystemService().getSchedulerService();
    }

    protected ServerSettings getServerSettings() {
        return this.getVirtualFileSystemService().getServerSettings();
    }

    protected BucketCache getBucketCache() {
        return this.getVirtualFileSystemService().getBucketCache();
    }

    protected String getKey(ServerBucket serverBucket, String string) {
        return serverBucket.getId().toString() + File.separator + string;
    }

    protected boolean isVersionControl() {
        return this.getServerSettings().isVersionControl();
    }

    protected void checkExistsBucket(ServerBucket serverBucket) {
        if (!this.existsCacheBucket(serverBucket)) {
            throw new OdilonObjectNotFoundException("bucket does not exist -> " + this.objectInfo(serverBucket));
        }
    }

    protected void checkExistsBucket(Long l) {
        if (!this.existsCacheBucket(l)) {
            throw new IllegalArgumentException("bucket does not exist -> " + l.toString());
        }
    }

    protected ServerBucket getCacheBucket(Long l) {
        return this.getVirtualFileSystemService().getBucketCache().get(l);
    }

    protected boolean existsCacheBucket(String string) {
        return this.getBucketCache().contains(string);
    }

    protected boolean existsCacheBucket(Long l) {
        return this.getBucketCache().contains(l);
    }

    protected boolean existsCacheBucket(ServerBucket serverBucket) {
        return this.getBucketCache().contains(serverBucket);
    }

    protected boolean existsCacheObject(ServerBucket serverBucket, String string) {
        return this.getVirtualFileSystemService().getObjectMetadataCacheService().containsKey(serverBucket, string);
    }

    protected ObjectMetadata getMetadata(ServerBucket serverBucket, String string) {
        return this.getMetadata(serverBucket, string, true);
    }

    protected ObjectMetadata getMetadata(ServerBucket serverBucket, String string, boolean bl) {
        if (!this.getServerSettings().isUseObjectCache()) {
            return this.getObjectMetadataReadDrive(serverBucket, string).getObjectMetadata(serverBucket, string);
        }
        if (this.getObjectMetadataCacheService().containsKey(serverBucket, string)) {
            this.getVirtualFileSystemService().getSystemMonitorService().getCacheObjectHitCounter().inc();
            ObjectMetadata objectMetadata = this.getObjectMetadataCacheService().get(serverBucket, string);
            objectMetadata.setBucketName(serverBucket.getName());
            return objectMetadata;
        }
        ObjectMetadata objectMetadata = this.getObjectMetadataReadDrive(serverBucket, string).getObjectMetadata(serverBucket, string);
        if (objectMetadata == null) {
            return objectMetadata;
        }
        objectMetadata.setBucketName(serverBucket.getName());
        this.getVirtualFileSystemService().getSystemMonitorService().getCacheObjectMissCounter().inc();
        if (bl) {
            this.getObjectMetadataCacheService().put(serverBucket, string, objectMetadata);
        }
        return objectMetadata;
    }

    protected EncryptionService getEncryptionService() {
        return this.getVirtualFileSystemService().getEncryptionService();
    }

    public JournalService getJournalService() {
        return this.getDriver().getJournalService();
    }

    public LockService getLockService() {
        return this.getDriver().getLockService();
    }

    protected boolean isEncrypt() {
        return this.getDriver().isEncrypt();
    }

    protected ReplicationService getReplicationService() {
        return this.getVirtualFileSystemService().getReplicationService();
    }

    protected boolean isStandByEnabled() {
        return this.getVirtualFileSystemService().getServerSettings().isStandByEnabled();
    }

    public RedundancyLevel getRedundancyLevel() {
        return this.getDriver().getRedundancyLevel();
    }

    protected String opInfo(VirtualFileSystemOperation virtualFileSystemOperation) {
        return this.getDriver().opInfo(virtualFileSystemOperation);
    }

    protected String objectInfo(ServerBucket serverBucket, String string, String string2) {
        return this.getDriver().objectInfo(serverBucket, string, string2);
    }

    protected String objectInfo(String string, String string2, String string3) {
        return this.getDriver().objectInfo(string, string2, string3);
    }

    protected String objectInfo(ObjectMetadata objectMetadata) {
        return this.getDriver().objectInfo(objectMetadata);
    }

    protected String objectInfo(ServerBucket serverBucket, String string) {
        return this.getDriver().objectInfo(serverBucket, string);
    }

    protected String objectInfo(String string, String string2) {
        return this.getDriver().objectInfo(string, string2);
    }

    protected void objectReadLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).readLock().lock();
    }

    protected void objectReadUnLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).readLock().unlock();
    }

    protected void objectWriteLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).writeLock().lock();
    }

    protected void objectWriteUnLock(ServerBucket serverBucket, String string) {
        this.getLockService().getObjectLock(serverBucket, string).writeLock().unlock();
    }

    protected void objectWriteLock(Long l, String string) {
        this.getLockService().getObjectLock(l, string).writeLock().lock();
    }

    protected void objectWriteUnLock(Long l, String string) {
        this.getLockService().getObjectLock(l, string).writeLock().unlock();
    }

    protected void objectWriteLock(ObjectMetadata objectMetadata) {
        this.getLockService().getObjectLock(objectMetadata.getBucketId(), objectMetadata.getObjectName()).writeLock().lock();
    }

    protected void objectWriteUnLock(ObjectMetadata objectMetadata) {
        this.getLockService().getObjectLock(objectMetadata.getBucketId(), objectMetadata.getObjectName()).writeLock().unlock();
    }

    protected void bucketReadLock(String string) {
        this.getLockService().getBucketLock(string).readLock().lock();
    }

    protected void bucketReadLock(Long l) {
        this.getLockService().getBucketLock(l).readLock().lock();
    }

    protected void bucketReadUnLock(Long l) {
        this.getLockService().getBucketLock(l).readLock().unlock();
    }

    protected void bucketReadUnLock(String string) {
        this.getLockService().getBucketLock(string).readLock().lock();
    }

    protected void bucketReadLock(ServerBucket serverBucket) {
        this.getLockService().getBucketLock(serverBucket).readLock().lock();
    }

    protected void bucketReadUnLock(ServerBucket serverBucket) {
        this.getLockService().getBucketLock(serverBucket).readLock().unlock();
    }

    protected void bucketWriteLock(BucketMetadata bucketMetadata) {
        this.getLockService().getBucketLock(bucketMetadata).writeLock().lock();
    }

    protected void bucketWriteUnLock(BucketMetadata bucketMetadata) {
        this.getLockService().getBucketLock(bucketMetadata).writeLock().unlock();
    }

    protected String objectInfo(ServerBucket serverBucket) {
        return this.getDriver().objectInfo(serverBucket);
    }

    protected boolean isUseVaultNewFiles() {
        return this.getVirtualFileSystemService().isUseVaultNewFiles();
    }

    protected VirtualFileSystemService getVirtualFileSystemService() {
        return this.getDriver().getVirtualFileSystemService();
    }

    protected ObjectMetadataCacheService getObjectMetadataCacheService() {
        return this.getVirtualFileSystemService().getObjectMetadataCacheService();
    }
}

