/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.model.BaseObject;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.ServerBucket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BucketCache
extends BaseObject {
    private Map<String, ServerBucket> buckets_by_name = new ConcurrentHashMap();
    @JsonIgnore
    private Map<Long, ServerBucket> buckets_by_id = new ConcurrentHashMap();
    @JsonIgnore
    private ReentrantReadWriteLock bucketCacheLock = new ReentrantReadWriteLock();

    public ServerBucket get(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"id is null");
        return (ServerBucket)this.getIdMap().get(l);
    }

    public ServerBucket get(String string) {
        Check.requireNonNullArgument((Object)string, (String)"name is null");
        return (ServerBucket)this.getNameMap().get(string);
    }

    public void add(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        ServerBucket serverBucket2 = null;
        this.lock();
        try {
            if (this.getIdMap().containsKey(serverBucket.getId())) {
                serverBucket2 = (ServerBucket)this.getIdMap().get(serverBucket.getId());
            }
            this.getIdMap().put(serverBucket.getId(), serverBucket);
            this.getNameMap().put(serverBucket.getName(), serverBucket);
        }
        catch (Exception exception) {
            this.restore(serverBucket2, serverBucket);
            throw exception;
        }
        finally {
            this.unLock();
        }
    }

    public void update(String string, ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        ServerBucket serverBucket2 = null;
        this.lock();
        try {
            if (this.getIdMap().containsKey(serverBucket.getId())) {
                serverBucket2 = (ServerBucket)this.getIdMap().get(serverBucket.getId());
            }
            this.getNameMap().remove(string);
            this.getNameMap().put(serverBucket.getName(), serverBucket);
            this.getIdMap().put(serverBucket.getId(), serverBucket);
        }
        catch (Exception exception) {
            this.restore(serverBucket2, serverBucket);
            throw exception;
        }
        finally {
            this.unLock();
        }
    }

    public void remove(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        this.remove(serverBucket.getId());
    }

    public void remove(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"bucket is null");
        ServerBucket serverBucket = null;
        this.lock();
        try {
            if (this.getIdMap().containsKey(l)) {
                serverBucket = (ServerBucket)this.getIdMap().get(l);
                this.getNameMap().remove(((ServerBucket)this.getIdMap().get(l)).getName());
                this.getIdMap().remove(l);
            }
        }
        catch (Exception exception) {
            this.restore(serverBucket, null);
            throw exception;
        }
        finally {
            this.unLock();
        }
    }

    public void remove(String string) {
        Check.requireNonNullArgument((Object)string, (String)"name is null");
        ServerBucket serverBucket = null;
        this.lock();
        try {
            if (this.getNameMap().containsKey(string)) {
                serverBucket = (ServerBucket)this.getNameMap().get(string);
                this.getIdMap().remove(((ServerBucket)this.getNameMap().get(string)).getId());
                this.getNameMap().remove(string);
            }
        }
        catch (Exception exception) {
            this.restore(serverBucket, null);
            throw exception;
        }
        finally {
            this.unLock();
        }
    }

    public boolean contains(String string) {
        Check.requireNonNullArgument((Object)string, (String)"name is null");
        return this.getNameMap().containsKey(string);
    }

    public boolean contains(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"id is null");
        return this.getIdMap().containsKey(l);
    }

    public boolean contains(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.getIdMap().containsKey(serverBucket.getId());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    protected Map<String, ServerBucket> getNameMap() {
        return this.buckets_by_name;
    }

    protected Map<Long, ServerBucket> getIdMap() {
        return this.buckets_by_id;
    }

    private void restore(ServerBucket serverBucket, ServerBucket serverBucket2) {
        if (serverBucket2 != null) {
            this.getIdMap().remove(serverBucket2.getId());
            this.getNameMap().remove(serverBucket2.getName());
        }
        if (serverBucket != null) {
            this.getIdMap().put(serverBucket.getId(), serverBucket);
            this.getNameMap().put(serverBucket.getName(), serverBucket);
        }
    }

    private void lock() {
        this.bucketCacheLock().writeLock().lock();
    }

    private void unLock() {
        this.bucketCacheLock().writeLock().unlock();
    }

    private ReentrantReadWriteLock bucketCacheLock() {
        return this.bucketCacheLock;
    }
}

