/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.model.BaseObject;
import io.odilon.model.BucketMetadata;
import io.odilon.model.BucketStatus;
import io.odilon.virtualFileSystem.model.DriveBucket;
import io.odilon.virtualFileSystem.model.ServerBucket;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OdilonBucket
extends BaseObject
implements ServerBucket {
    @JsonProperty(value="bucketMetadata")
    private final BucketMetadata meta;

    public OdilonBucket(DriveBucket driveBucket) {
        this.meta = driveBucket.getBucketMetadata();
    }

    public OdilonBucket(BucketMetadata bucketMetadata) {
        this.meta = bucketMetadata;
    }

    public boolean isAccesible() {
        return this.meta.status == BucketStatus.ENABLED || this.meta.status == BucketStatus.ARCHIVED;
    }

    public String getName() {
        return this.meta.bucketName;
    }

    public OffsetDateTime getCreationDate() {
        return this.meta.creationDate;
    }

    public OffsetDateTime getLastModifiedDate() {
        return this.meta.lastModified;
    }

    public BucketStatus getStatus() {
        return this.meta.status;
    }

    public BucketMetadata getBucketMetadata() {
        return this.meta;
    }

    public Long getId() {
        return this.meta.id;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }
}

