/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.cache.CacheEvent;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.BucketMetadata;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.ServiceStatus;
import io.odilon.replication.ReplicationService;
import io.odilon.scheduler.SchedulerService;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.Action;
import io.odilon.virtualFileSystem.BucketEvent;
import io.odilon.virtualFileSystem.OdilonVirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@ThreadSafe
public class OdilonJournalService
extends BaseService
implements JournalService {
    private static Logger logger = Logger.getLogger((String)OdilonJournalService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    private Map<String, VirtualFileSystemOperation> operations = new ConcurrentHashMap();
    @JsonIgnore
    private Map<String, String> ops_aborted = new ConcurrentHashMap();
    @JsonIgnore
    private boolean isStandBy;
    @JsonIgnore
    @Autowired
    private ReplicationService replicationService;
    @JsonIgnore
    @Autowired
    private SchedulerService schedulerService;
    @Autowired
    @JsonIgnore
    private ServerSettings serverSettings;
    @Autowired
    @JsonIgnore
    private ApplicationEventPublisher applicationEventPublisher;

    public VirtualFileSystemOperation saveServerKey() {
        return this.createNew(OperationCode.CREATE_SERVER_MASTERKEY, Optional.empty(), Optional.empty(), Optional.of("key.enc"), Optional.empty());
    }

    public VirtualFileSystemOperation createServerMetadata() {
        return this.createNew(OperationCode.CREATE_SERVER_METADATA, Optional.empty(), Optional.empty(), Optional.of("odilon.json"), Optional.empty());
    }

    public VirtualFileSystemOperation updateServerMetadata() {
        return this.createNew(OperationCode.UPDATE_SERVER_METADATA, Optional.empty(), Optional.empty(), Optional.of("odilon.json"), Optional.empty());
    }

    public VirtualFileSystemOperation createBucket(BucketMetadata bucketMetadata) {
        Check.requireNonNullArgument((Object)bucketMetadata, (String)"meta is null");
        return this.createNew(OperationCode.CREATE_BUCKET, Optional.of(bucketMetadata.getId()), Optional.of(bucketMetadata.getBucketName()), Optional.empty(), Optional.empty());
    }

    public VirtualFileSystemOperation updateBucket(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.createNew(OperationCode.UPDATE_BUCKET, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.of(string), Optional.empty());
    }

    public VirtualFileSystemOperation deleteBucket(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.createNew(OperationCode.DELETE_BUCKET, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.empty(), Optional.empty());
    }

    public VirtualFileSystemOperation deleteObjectPreviousVersions(ServerBucket serverBucket, String string, int n) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.createNew(OperationCode.DELETE_OBJECT_PREVIOUS_VERSIONS, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.ofNullable(string), Optional.of(n));
    }

    public VirtualFileSystemOperation syncObject(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.createNew(OperationCode.SYNC_OBJECT_NEW_DRIVE, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.ofNullable(string), Optional.empty());
    }

    public VirtualFileSystemOperation deleteObject(ServerBucket serverBucket, String string, int n) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.createNew(OperationCode.DELETE_OBJECT, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.ofNullable(string), Optional.of(n));
    }

    public VirtualFileSystemOperation restoreObjectPreviousVersion(ServerBucket serverBucket, String string, int n) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.createNew(OperationCode.RESTORE_OBJECT_PREVIOUS_VERSION, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.ofNullable(string), Optional.of(n));
    }

    public VirtualFileSystemOperation createObject(ServerBucket serverBucket, String string) {
        return this.createNew(OperationCode.CREATE_OBJECT, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.ofNullable(string), Optional.of(0));
    }

    public VirtualFileSystemOperation updateObject(ServerBucket serverBucket, String string, int n) {
        return this.createNew(OperationCode.UPDATE_OBJECT, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.ofNullable(string), Optional.of(n));
    }

    public VirtualFileSystemOperation updateObjectMetadata(ServerBucket serverBucket, String string, int n) {
        return this.createNew(OperationCode.UPDATE_OBJECT_METADATA, Optional.of(serverBucket.getId()), Optional.of(serverBucket.getName()), Optional.ofNullable(string), Optional.of(n));
    }

    public boolean commit(VirtualFileSystemOperation virtualFileSystemOperation) {
        return this.commit(virtualFileSystemOperation, null);
    }

    public boolean commit(VirtualFileSystemOperation virtualFileSystemOperation, Object object) {
        if (virtualFileSystemOperation == null) {
            return true;
        }
        OdilonJournalService odilonJournalService = this;
        synchronized (odilonJournalService) {
            boolean bl = false;
            try {
                if (this.isStandBy()) {
                    this.getReplicationService().enqueue(virtualFileSystemOperation);
                }
                this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new CacheEvent(virtualFileSystemOperation, Action.COMMIT));
                if (object != null && object instanceof ServerBucket) {
                    this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new BucketEvent(virtualFileSystemOperation, Action.COMMIT, (ServerBucket)object));
                }
                this.getVirtualFileSystemService().removeJournal(virtualFileSystemOperation.getId());
                this.getOperations().remove(virtualFileSystemOperation.getId());
                bl = true;
                return bl;
            }
            catch (Exception exception) {
                if (this.isStandBy()) {
                    this.getOpsAborted().put(virtualFileSystemOperation.getId(), virtualFileSystemOperation.getId());
                    this.getReplicationService().cancel(virtualFileSystemOperation);
                }
                throw exception;
            }
        }
    }

    public boolean cancel(VirtualFileSystemOperation virtualFileSystemOperation) {
        return this.cancel(virtualFileSystemOperation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(VirtualFileSystemOperation virtualFileSystemOperation, Object object) {
        if (virtualFileSystemOperation == null) {
            return true;
        }
        OdilonJournalService odilonJournalService = this;
        synchronized (odilonJournalService) {
            try {
                CacheEvent cacheEvent = new CacheEvent(virtualFileSystemOperation, Action.ROLLBACK);
                this.getApplicationEventPublisher().publishEvent((ApplicationEvent)cacheEvent);
                if (object instanceof ServerBucket) {
                    this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new BucketEvent(virtualFileSystemOperation, Action.ROLLBACK, (ServerBucket)object));
                }
                this.getVirtualFileSystemService().removeJournal(virtualFileSystemOperation.getId());
            }
            catch (InternalCriticalException internalCriticalException) {
                logger.error((Throwable)internalCriticalException, new String[]{"the operation was saved in just some of the drives due to a crash", "---- not thrown ----"});
            }
            logger.debug("Cancel ->" + virtualFileSystemOperation.toString());
            this.getOperations().remove(virtualFileSystemOperation.getId());
        }
        return true;
    }

    public synchronized String newOperationId() {
        return String.valueOf(System.nanoTime());
    }

    public boolean isExecuting(String string) {
        return this.getOperations().containsKey(string);
    }

    public boolean isAborted(String string) {
        return this.getOpsAborted().containsKey(string);
    }

    public void removeAborted(String string) {
        this.getOpsAborted().remove(string);
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        if (this.virtualFileSystemService == null) {
            logger.error(new String[]{VirtualFileSystemService.class.getSimpleName() + " must be set during the @PostConstruct method of the " + JournalService.class.getSimpleName() + " instance. It can not be injected via AutoWired beacause of circular dependencies."});
            throw new IllegalStateException(VirtualFileSystemService.class.getSimpleName() + " is null. it must be setted during the @PostConstruct method of the " + JournalService.class.getSimpleName() + " instance");
        }
        return this.virtualFileSystemService;
    }

    public synchronized void setVirtualFileSystemService(VirtualFileSystemService virtualFileSystemService) {
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public ReplicationService getReplicationService() {
        return this.replicationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        OdilonJournalService odilonJournalService = this;
        synchronized (odilonJournalService) {
            this.setStatus(ServiceStatus.STARTING);
            this.isStandBy = this.getServerSettings().isStandByEnabled();
            startuplogger.debug("Started -> " + JournalService.class.getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }

    private synchronized VirtualFileSystemOperation createNew(OperationCode operationCode, Optional<Long> optional, Optional<String> optional2, Optional<String> optional3, Optional<Integer> optional4) {
        OdilonVirtualFileSystemOperation odilonVirtualFileSystemOperation = new OdilonVirtualFileSystemOperation(this.newOperationId(), operationCode, optional, optional2, optional3, optional4, this.getRedundancyLevel(), (JournalService)this);
        this.getVirtualFileSystemService().saveJournal((VirtualFileSystemOperation)odilonVirtualFileSystemOperation);
        this.getOperations().put(odilonVirtualFileSystemOperation.getId(), odilonVirtualFileSystemOperation);
        return odilonVirtualFileSystemOperation;
    }

    private RedundancyLevel getRedundancyLevel() {
        return this.getVirtualFileSystemService().getRedundancyLevel();
    }

    private Map<String, VirtualFileSystemOperation> getOperations() {
        return this.operations;
    }

    private Map<String, String> getOpsAborted() {
        return this.ops_aborted;
    }

    private ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    private boolean isStandBy() {
        return this.isStandBy;
    }
}

