/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.log.Logger;
import io.odilon.model.BucketMetadata;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.service.Timer;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.OdilonVirtualFileSystemService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OdilonLockService
extends BaseService
implements LockService {
    private static Logger logger = Logger.getLogger((String)OdilonLockService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static final DecimalFormat formatter = new DecimalFormat("###,###,###");
    private static final long minTimeToSleepMillisec = 5000L;
    private static final long maxTimeToSleepMillisec = 120000L;
    private static final long deltaTimeToSleep = 115000L;
    @JsonProperty(value="ratePerMillisec")
    private double ratePerMillisec = 2.0;
    @JsonIgnore
    ReentrantReadWriteLock serverLock = new ReentrantReadWriteLock();
    @JsonIgnore
    private ConcurrentMap<String, ReentrantReadWriteLock> objectLocks = new ConcurrentHashMap(1000);
    @JsonIgnore
    private ConcurrentMap<String, ReentrantReadWriteLock> fileCacheLocks = new ConcurrentHashMap(1000);
    @JsonIgnore
    private ConcurrentMap<String, ReentrantReadWriteLock> bucketLocks = new ConcurrentHashMap(1000);
    @JsonIgnore
    private Timer cleaner;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;

    @Autowired
    public OdilonLockService(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public ReadWriteLock getBucketLock(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.getBucketLocks().computeIfAbsent(serverBucket.getName(), string -> new ReentrantReadWriteLock());
    }

    public ReadWriteLock getBucketLock(BucketMetadata bucketMetadata) {
        Check.requireNonNullArgument((Object)bucketMetadata, (String)"BucketMetadata is null");
        return this.getBucketLock(bucketMetadata.getBucketName());
    }

    public ReadWriteLock getBucketLock(String string2) {
        Check.requireNonNullArgument((Object)string2, (String)"bucketName is null");
        return this.getBucketLocks().computeIfAbsent(string2, string -> new ReentrantReadWriteLock());
    }

    public ReadWriteLock getBucketLock(Long l) {
        return this.getBucketLocks().computeIfAbsent(this.getVirtualFileSystemService().getBucketCache().get(l).getName(), string -> new ReentrantReadWriteLock());
    }

    public ReadWriteLock getObjectLock(ServerBucket serverBucket, String string2) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string2, (String)"objectName is null");
        return this.getObjectLocks().computeIfAbsent(this.getKey(serverBucket.getId(), string2), string -> new ReentrantReadWriteLock());
    }

    public ReadWriteLock getObjectLock(Long l, String string2) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        Check.requireNonNullArgument((Object)string2, (String)"objectName is null");
        return this.getObjectLocks().computeIfAbsent(this.getKey(l, string2), string -> new ReentrantReadWriteLock());
    }

    public ReadWriteLock getFileCacheLock(Long l, String string2, Optional<Integer> optional) {
        return this.getFileCacheLocks().computeIfAbsent(this.getFileKey(l, string2, optional), string -> new ReentrantReadWriteLock());
    }

    public boolean isLocked(ServerBucket serverBucket) {
        return this.isLocked(serverBucket);
    }

    public boolean isLocked(String string) {
        if (!this.getBucketLocks().containsKey(string)) {
            return false;
        }
        if (((ReentrantReadWriteLock)this.getBucketLocks().get(string)).isWriteLocked()) {
            return true;
        }
        return ((ReentrantReadWriteLock)this.getBucketLocks().get(string)).getReadLockCount() > 0;
    }

    public ReadWriteLock getServerLock() {
        return this.serverLock;
    }

    public ConcurrentMap<String, ReentrantReadWriteLock> getObjectLocks() {
        return this.objectLocks;
    }

    public void setObjectLocks(ConcurrentMap<String, ReentrantReadWriteLock> concurrentMap) {
        this.objectLocks = concurrentMap;
    }

    public ConcurrentMap<String, ReentrantReadWriteLock> getFileCacheLocks() {
        return this.fileCacheLocks;
    }

    public void setFileCacheLocks(ConcurrentMap<String, ReentrantReadWriteLock> concurrentMap) {
        this.fileCacheLocks = concurrentMap;
    }

    public ConcurrentMap<String, ReentrantReadWriteLock> getBucketLocks() {
        return this.bucketLocks;
    }

    public void setBucketLocks(ConcurrentMap<String, ReentrantReadWriteLock> concurrentMap) {
        this.bucketLocks = concurrentMap;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        if (this.virtualFileSystemService == null) {
            logger.error(new String[]{"The instance of " + VirtualFileSystemService.class.getSimpleName() + " must be setted during the @PostConstruct method of the " + this.getClass().getName() + " instance. It can not be injected via AutoWired beacause of circular dependencies."});
            throw new IllegalStateException(VirtualFileSystemService.class.getSimpleName() + " instance is null. it must be asigned during the @PostConstruct method of the " + this.getClass().getName() + " instance");
        }
        return this.virtualFileSystemService;
    }

    public void setVirtualFileSystemService(OdilonVirtualFileSystemService odilonVirtualFileSystemService) {
        try {
            this.virtualFileSystemService = odilonVirtualFileSystemService;
        }
        finally {
            this.setStatus(ServiceStatus.RUNNING);
            startuplogger.debug("Started -> " + LockService.class.getSimpleName());
        }
    }

    public String toJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"maxLockCreationRateSec\":" + formatter.format(this.ratePerMillisec * 1000.0).trim().trim());
        stringBuilder.append(", \"minTimeToSleepMillisec\":" + formatter.format(5000L).trim() + "}");
        return stringBuilder.toString();
    }

    @PostConstruct
    protected synchronized void onInitialize() {
        this.setStatus(ServiceStatus.STARTING);
        this.ratePerMillisec = this.getServerSettings().getLockRateMillisecs();
        this.cleaner = new /* Unavailable Anonymous Inner Class!! */;
        Thread thread = new Thread((Runnable)this.cleaner);
        thread.setDaemon(true);
        thread.setName(LockService.class.getSimpleName() + "Cleaner-" + Double.valueOf(Math.abs(Math.random() * 1000000.0)).intValue());
        thread.start();
        this.setStatus(ServiceStatus.RUNNING);
        startuplogger.debug("Started -> " + LockService.class.getSimpleName());
    }

    @PreDestroy
    private void preDestroy() {
        this.getPoolCleaner().sendExitSignal();
    }

    private String getKey(Long l, String string) {
        return l.toString() + "$" + string;
    }

    private String getFileKey(Long l, String string, Optional<Integer> optional) {
        return l.toString() + "$" + string + (String)(optional.isEmpty() ? "" : "$" + String.valueOf(optional.get()));
    }

    private ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    private Timer getPoolCleaner() {
        return this.cleaner;
    }

    private double getRatePerMillisec() {
        return this.ratePerMillisec;
    }
}

