/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.json.OdilonObjectMapper;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.ServerBucket;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;

public abstract class BucketIterator
implements Iterator<Path> {
    private static final Logger logger = Logger.getLogger((String)BucketIterator.class.getName());
    private static ObjectMapper mapper = new OdilonObjectMapper();
    @JsonProperty(value="cumulativeIndex")
    private long cumulativeIndex = 0L;
    @JsonIgnore
    private int relativeIndex = 0;
    @JsonProperty(value="prefix")
    private String prefix = null;
    @JsonProperty(value="agentId")
    private String agentId = null;
    @JsonProperty(value="offset")
    private Long offset = 0L;
    @JsonProperty(value="bucketId")
    private final Long bucketId;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonIgnore
    private boolean initiated = false;
    @JsonIgnore
    private List<Path> buffer;
    @JsonIgnore
    private IODriver driver;
    @JsonIgnore
    private final ServerBucket bucket;

    public BucketIterator(IODriver iODriver, ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)iODriver, (String)"driver is null");
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        this.setDriver(iODriver);
        this.bucket = serverBucket;
        this.bucketId = serverBucket.getId();
        this.bucketName = serverBucket.getName();
    }

    protected abstract boolean fetch();

    protected abstract void init();

    @Override
    public synchronized boolean hasNext() {
        if (!this.isInitiated()) {
            this.init();
            return this.fetch();
        }
        if (this.getRelativeIndex() < this.getBuffer().size()) {
            return true;
        }
        return this.fetch();
    }

    @Override
    public synchronized Path next() {
        if (this.getRelativeIndex() < this.getBuffer().size()) {
            Path path = (Path)this.getBuffer().get(this.getRelativeIndex());
            this.setRelativeIndex(this.getRelativeIndex() + 1);
            this.incCumulativeIndex();
            return path;
        }
        boolean bl = this.fetch();
        if (!bl) {
            throw new IndexOutOfBoundsException("No more items available. hasNext() should be called before this method.[returned so far -> " + String.valueOf(this.getCumulativeIndex()) + "]");
        }
        Path path = (Path)this.getBuffer().get(this.getRelativeIndex());
        this.incRelativeIndex();
        this.incCumulativeIndex();
        return path;
    }

    public void close() throws IOException {
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String string) {
        this.agentId = string;
    }

    public ServerBucket getBucket() {
        return this.bucket;
    }

    public Long getBucketId() {
        return this.bucket.getId();
    }

    public Long getOffset() {
        return this.offset;
    }

    public Long setOffset(Long l) {
        this.offset = l;
        return l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "{");
        stringBuilder.append(this.toJSON());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String toJSON() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.error((Throwable)jsonProcessingException, new String[]{"---- not thrown ----"});
            return "\"error\":\"" + ((Object)((Object)jsonProcessingException)).getClass().getName() + " | " + jsonProcessingException.getMessage() + "\"";
        }
    }

    protected int defaultBufferSize() {
        return 1000;
    }

    protected void setDriver(IODriver iODriver) {
        this.driver = iODriver;
    }

    protected IODriver getDriver() {
        return this.driver;
    }

    protected boolean isValidState(Path path) {
        return true;
    }

    protected boolean isObjectStateEnabled(Path path) {
        ObjectMetadata objectMetadata = this.getDriver().getObjectMetadata(this.getBucket(), path.toFile().getName());
        if (objectMetadata == null) {
            return false;
        }
        return objectMetadata.getStatus() == ObjectStatus.ENABLED;
    }

    protected boolean isInitiated() {
        return this.initiated;
    }

    protected void setInitiated(boolean bl) {
        this.initiated = bl;
    }

    protected List<Path> getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(List<Path> list) {
        this.buffer = list;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected void setPrefix(String string) {
        this.prefix = string;
    }

    protected int getRelativeIndex() {
        return this.relativeIndex;
    }

    protected void incRelativeIndex() {
        ++this.relativeIndex;
    }

    protected void setRelativeIndex(int n) {
        this.relativeIndex = n;
    }

    protected void incCumulativeIndex() {
        ++this.cumulativeIndex;
    }

    protected long getCumulativeIndex() {
        return this.cumulativeIndex;
    }

    protected void setCumulativeIndex(long l) {
        this.cumulativeIndex = l;
    }
}

