/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.odilon.log.Logger;
import io.odilon.model.BucketMetadata;
import io.odilon.model.BucketStatus;
import io.odilon.virtualFileSystem.model.Drive;
import java.io.IOException;
import java.time.OffsetDateTime;

public class DriveBucket {
    private static Logger logger = Logger.getLogger((String)DriveBucket.class.getName());
    private static ObjectMapper objectMapper = new ObjectMapper();
    private BucketMetadata meta;
    @JsonIgnore
    private Drive drive;

    public DriveBucket(Drive drive, BucketMetadata bucketMetadata) throws IOException {
        this.drive = drive;
        this.meta = bucketMetadata.clone();
    }

    @JsonIgnore
    public Drive getDrive() {
        return this.drive;
    }

    public String getName() {
        return this.meta.bucketName;
    }

    public Long getId() {
        return this.meta.id;
    }

    public OffsetDateTime getCreationDate() {
        return this.meta.creationDate;
    }

    public BucketMetadata getBucketMetadata() {
        return this.meta;
    }

    public BucketStatus getStatus() {
        return this.meta.status;
    }

    @JsonIgnore
    public boolean isDeleted() {
        if (this.meta.status == null) {
            return false;
        }
        return this.meta.status == BucketStatus.DELETED;
    }

    @JsonIgnore
    public boolean isAccesible() {
        if (this.meta.status == null) {
            return false;
        }
        return this.meta.status == BucketStatus.ENABLED || this.meta.status == BucketStatus.ARCHIVED;
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

