/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.model;

import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;

public interface IODriver {
    public static final boolean IS_HEAD = true;

    public boolean existsBucket(String var1);

    public ServerBucket createBucket(String var1);

    public void removeBucket(ServerBucket var1);

    public void removeBucket(ServerBucket var1, boolean var2);

    public ServerBucket renameBucket(ServerBucket var1, String var2);

    public ServerBucket getBucket(String var1);

    public boolean isEmpty(ServerBucket var1);

    public ObjectMetadata getObjectMetadata(ServerBucket var1, String var2);

    public void putObjectMetadata(ObjectMetadata var1);

    public void putObject(ServerBucket var1, String var2, InputStream var3, String var4, String var5, Optional<List<String>> var6);

    public void putObject(ServerBucket var1, String var2, File var3);

    public VirtualFileSystemObject getObject(ServerBucket var1, String var2);

    public boolean exists(ServerBucket var1, String var2);

    public void delete(ServerBucket var1, String var2);

    public InputStream getInputStream(ServerBucket var1, String var2) throws IOException;

    public DataList<Item<ObjectMetadata>> listObjects(ServerBucket var1, Optional<Long> var2, Optional<Integer> var3, Optional<String> var4, Optional<String> var5);

    public void postObjectDeleteTransaction(ObjectMetadata var1, int var2);

    public void postObjectPreviousVersionDeleteAllTransaction(ObjectMetadata var1, int var2);

    public void saveJournal(VirtualFileSystemOperation var1);

    public void removeJournal(String var1);

    public void rollback(VirtualFileSystemOperation var1);

    public void rollback(VirtualFileSystemOperation var1, boolean var2);

    public void rollback(VirtualFileSystemOperation var1, Object var2, boolean var3);

    public List<VirtualFileSystemOperation> getJournalPending(JournalService var1);

    public JournalService getJournalService();

    public void saveScheduler(ServiceRequest var1, String var2);

    public void removeScheduler(ServiceRequest var1, String var2);

    public boolean checkIntegrity(ServerBucket var1, String var2, boolean var3);

    public boolean setUpDrives();

    public OdilonServerInfo getServerInfo();

    public void setServerInfo(OdilonServerInfo var1);

    public boolean isEncrypt();

    public RedundancyLevel getRedundancyLevel();

    public void saveServerMasterKey(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public byte[] getServerMasterKey();

    public LockService getLockService();

    public VirtualFileSystemService getVirtualFileSystemService();

    public List<ServiceRequest> getSchedulerPendingRequests(String var1);

    public ObjectMetadata getObjectMetadataPreviousVersion(ServerBucket var1, String var2);

    public ObjectMetadata getObjectMetadataVersion(ServerBucket var1, String var2, int var3);

    public List<ObjectMetadata> getObjectMetadataVersionAll(ServerBucket var1, String var2);

    public InputStream getObjectVersionInputStream(ServerBucket var1, String var2, int var3);

    public void deleteObjectAllPreviousVersions(ServerBucket var1, String var2);

    public void deleteBucketAllPreviousVersions(ServerBucket var1);

    public void wipeAllPreviousVersions();

    public ObjectMetadata restorePreviousVersion(ServerBucket var1, String var2);

    public boolean hasVersions(ServerBucket var1, String var2);

    public void syncObject(ObjectMetadata var1);

    public String objectInfo(ServerBucket var1);

    public String objectInfo(ServerBucket var1, String var2);

    public String objectInfo(String var1, String var2);

    public String objectInfo(ServerBucket var1, String var2, String var3);

    public String objectInfo(String var1, String var2, String var3);

    public String objectInfo(ObjectMetadata var1);

    public String opInfo(VirtualFileSystemOperation var1);

    public List<Drive> getDrivesEnabled();

    public List<Drive> getDrivesAll();
}

