/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.model;

import io.odilon.cache.FileCacheService;
import io.odilon.cache.ObjectMetadataCacheService;
import io.odilon.encryption.EncryptionService;
import io.odilon.encryption.MasterKeyService;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.query.BucketIteratorService;
import io.odilon.replication.ReplicationService;
import io.odilon.scheduler.SchedulerService;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.service.ServerSettings;
import io.odilon.service.SystemService;
import io.odilon.virtualFileSystem.BucketCache;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.BufferPoolService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;

public interface VirtualFileSystemService
extends SystemService {
    public static final int BUFFER_SIZE = 8192;
    public static final String DATA = "data";
    public static final String METADATA = "metadata";
    public static final String DRIVE_INFO = "driveInfo.json";
    public static final String SERVER_METADATA_FILE = "odilon.json";
    public static final String ENCRYPTION_KEY_FILE = "key.enc";
    public static final String SYS = ".odilon.sys";
    public static final String BUCKETS = "buckets";
    public static final String WORK = "work";
    public static final String CACHE = "cache";
    public static final String SCHEDULER = "scheduler";
    public static final String JOURNAL = "journal";
    public static final String TEMP = "tmp";
    public static final String VERSION_DIR = "version";
    public static final String VERSION_EXTENSION = ".v";
    public static final int BITS_PER_BYTE = 8;

    public IODriver createVFSIODriver();

    public OdilonServerInfo getOdilonServerInfo();

    public void setOdilonServerInfo(OdilonServerInfo var1);

    public Map<String, Drive> getMapDrivesAll();

    public Map<String, Drive> getMapDrivesEnabled();

    public Map<Integer, Drive> getMapDrivesRSDecode();

    public void updateDriveStatus(Drive var1);

    public List<ServerBucket> listAllBuckets();

    public ServerBucket createBucket(String var1) throws IOException;

    public void removeBucket(String var1);

    public ServerBucket renameBucketName(String var1, String var2);

    public ServerBucket getBucketByName(String var1);

    public boolean existsBucket(String var1);

    public boolean isEmpty(ServerBucket var1);

    public void forceRemoveBucket(String var1);

    public Long getNextBucketId();

    public String ping();

    public void putObject(ServerBucket var1, String var2, File var3);

    public void putObject(ServerBucket var1, String var2, InputStream var3, String var4, String var5);

    public void putObject(ServerBucket var1, String var2, InputStream var3, String var4, String var5, Optional<List<String>> var6);

    public void putObject(String var1, String var2, InputStream var3, String var4, String var5, Optional<List<String>> var6);

    public VirtualFileSystemObject getObject(ServerBucket var1, String var2);

    public VirtualFileSystemObject getObject(String var1, String var2);

    public ObjectMetadata getObjectMetadata(ServerBucket var1, String var2);

    public boolean existsObject(ServerBucket var1, String var2);

    public boolean existsObject(String var1, String var2);

    public void deleteObject(ServerBucket var1, String var2);

    public InputStream getObjectStream(ServerBucket var1, String var2) throws IOException;

    public InputStream getObjectStream(String var1, String var2) throws IOException;

    public boolean hasVersions(String var1, String var2);

    public List<ObjectMetadata> getObjectMetadataAllVersions(String var1, String var2);

    public ObjectMetadata getObjectMetadataVersion(String var1, String var2, int var3);

    public ObjectMetadata getObjectMetadataPreviousVersion(String var1, String var2);

    public InputStream getObjectVersion(String var1, String var2, int var3);

    public ObjectMetadata restorePreviousVersion(String var1, String var2);

    public void deleteObjectAllPreviousVersions(String var1, String var2);

    public void deleteBucketAllPreviousVersions(String var1);

    public void wipeAllPreviousVersions();

    public DataList<Item<ObjectMetadata>> listObjects(String var1, Optional<Long> var2, Optional<Integer> var3, Optional<String> var4, Optional<String> var5);

    public DataList<Item<ObjectMetadata>> listObjects(String var1);

    public void saveJournal(VirtualFileSystemOperation var1);

    public void removeJournal(String var1);

    public List<VirtualFileSystemOperation> getJournalPendingOperations();

    public void saveScheduler(ServiceRequest var1, String var2);

    public void removeScheduler(ServiceRequest var1, String var2);

    public List<ServiceRequest> getSchedulerPendingRequests(String var1);

    public boolean isEncrypt();

    public boolean isUseVaultNewFiles();

    public OffsetDateTime getStarted();

    public EncryptionService getEncryptionService();

    public JournalService getJournalService();

    public SchedulerService getSchedulerService();

    public ServerSettings getServerSettings();

    public RedundancyLevel getRedundancyLevel();

    public boolean isEmptyBucket(String var1);

    public BucketIteratorService getBucketIteratorService();

    public boolean checkIntegrity(String var1, String var2, boolean var3);

    public ReplicationService getReplicationService();

    public ObjectMetadataCacheService getObjectMetadataCacheService();

    public FileCacheService getFileCacheService();

    public SystemMonitorService getSystemMonitorService();

    public LockService getLockService();

    public MasterKeyService getMasterKeyEncryptorService();

    public byte[] HMAC(byte[] var1, byte[] var2) throws NoSuchAlgorithmException, InvalidKeyException;

    public ApplicationContext getApplicationContext();

    public BucketCache getBucketCache();

    public ApplicationEventPublisher getApplicationEventPublisher();

    public ExecutorService getExecutorService();

    public BufferPoolService getBufferPoolService();
}

