/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.virtualFileSystem.model.BucketIterator;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RAIDZeroBucketIterator
extends BucketIterator
implements Closeable {
    @JsonIgnore
    private Map<Drive, Iterator<Path>> itMap;
    @JsonIgnore
    private Map<Drive, Stream<Path>> streamMap;
    @JsonIgnore
    private List<Drive> drives;

    public RAIDZeroBucketIterator(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, Optional<Long> optional, Optional<String> optional2) {
        this(rAIDZeroDriver, serverBucket, optional, optional2, Optional.empty());
    }

    public RAIDZeroBucketIterator(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, Optional<Long> optional, Optional<String> optional2, Optional<String> optional3) {
        super((IODriver)rAIDZeroDriver, serverBucket);
        optional.ifPresent(l -> this.setOffset(l));
        optional3.ifPresent(string -> this.setAgentId(string));
        optional2.ifPresent(string -> this.setPrefix(string.toLowerCase().trim()));
        this.drives = new ArrayList();
        this.drives.addAll(this.getDriver().getDrivesEnabled());
        this.streamMap = new HashMap();
        this.itMap = new HashMap();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.getStreamMap() != null) {
            this.getStreamMap().forEach((drive, stream) -> stream.close());
        }
    }

    protected void init() {
        for (Drive drive : this.getDrives()) {
            Path path2 = new File(drive.getBucketMetadataDirPath(this.getBucket())).toPath();
            Stream<Path> stream = null;
            try {
                stream = Files.walk(path2, 1, new FileVisitOption[0]).skip(1L).filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(path -> this.getPrefix() == null || path.getFileName().toString().toLowerCase().trim().startsWith(this.getPrefix())).filter(path -> this.isValidState(path));
                this.getStreamMap().put(drive, stream);
            }
            catch (IOException iOException) {
                throw new InternalCriticalException((Exception)iOException);
            }
            Iterator iterator = stream.iterator();
            this.getItMap().put(drive, iterator);
        }
        this.skipOffset();
        this.setInitiated(true);
    }

    protected boolean fetch() {
        this.setRelativeIndex(0);
        this.setBuffer(new ArrayList());
        boolean bl = false;
        if (this.getDrives().isEmpty()) {
            return false;
        }
        for (Drive drive : this.getDrives()) {
            if (!((Iterator)this.getItMap().get(drive)).hasNext()) continue;
            bl = true;
            break;
        }
        int n = 0;
        while (bl && this.getBuffer().size() < this.defaultBufferSize()) {
            int n2 = n++ % this.getDrives().size();
            Drive drive = (Drive)this.getDrives().get(n2);
            Iterator iterator = (Iterator)this.getItMap().get(drive);
            if (iterator.hasNext()) {
                this.getBuffer().add((Path)iterator.next());
                continue;
            }
            ((Stream)this.getStreamMap().get(drive)).close();
            this.getItMap().remove(drive);
            this.getDrives().remove(n2);
            bl = !this.getDrives().isEmpty();
        }
        return !this.getBuffer().isEmpty();
    }

    private void skipOffset() {
        if (this.getOffset() == 0L) {
            return;
        }
        boolean bl = false;
        for (Drive drive : this.getDrives()) {
            if (!((Iterator)this.getItMap().get(drive)).hasNext()) continue;
            bl = true;
            break;
        }
        long l = this.getCumulativeIndex();
        while (bl && l < this.getOffset()) {
            int n = 0;
            int n2 = n++ % this.getDrives().size();
            Drive drive = (Drive)this.getDrives().get(n2);
            Iterator iterator = (Iterator)this.getItMap().get(drive);
            if (iterator.hasNext()) {
                iterator.next();
                ++l;
                continue;
            }
            ((Stream)this.getStreamMap().get(drive)).close();
            this.getItMap().remove(drive);
            this.getDrives().remove(n2);
            bl = !this.getDrives().isEmpty();
        }
    }

    private Map<Drive, Iterator<Path>> getItMap() {
        return this.itMap;
    }

    private Map<Drive, Stream<Path>> getStreamMap() {
        return this.streamMap;
    }

    private List<Drive> getDrives() {
        return this.drives;
    }
}

