/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.scheduler.AfterDeleteObjectServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroTransactionObjectHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.OffsetDateTime;
import org.apache.commons.io.FileUtils;

public class RAIDZeroDeleteObjectAllPreviousVersionsHandler
extends RAIDZeroTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroDeleteObjectAllPreviousVersionsHandler.class.getName());

    public RAIDZeroDeleteObjectAllPreviousVersionsHandler(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, String string) {
        super(rAIDZeroDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete() {
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        ObjectMetadata objectMetadata = null;
        this.objectWriteLock();
        try {
            int n;
            block50: {
                this.bucketReadLock();
                this.checkExistsBucket();
                this.checkExistObject();
                objectMetadata = this.getMetadata();
                if (objectMetadata.getVersion() != 0) break block50;
                try {
                    if (!bl2) {
                        try {
                            this.rollback(virtualFileSystemOperation);
                            return;
                        }
                        catch (InternalCriticalException internalCriticalException) {
                            if (!bl) {
                                throw internalCriticalException;
                            }
                            logger.error((Throwable)internalCriticalException, new String[]{this.info(), "---- not thrown ----"});
                            return;
                        }
                        catch (Exception exception) {
                            if (!bl) {
                                throw new InternalCriticalException(exception, this.info());
                            }
                            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                            return;
                        }
                    }
                    try {
                        int n2 = 0;
                        while (true) {
                            if (n2 >= objectMetadata.getVersion()) {
                                FileUtils.deleteQuietly((File)this.getObjectPath().metadataWorkFilePath().toFile());
                                this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(AfterDeleteObjectServiceRequest.class, new Object[]{virtualFileSystemOperation.getOperationCode(), objectMetadata, objectMetadata.getVersion()}));
                                return;
                            }
                            FileUtils.deleteQuietly((File)this.getObjectPath().dataFileVersionPath(n2).toFile());
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                        return;
                    }
                }
                finally {
                    this.bucketReadUnLock();
                }
            }
            FileUtils.copyDirectory((File)this.getObjectPath().metadataDirPath().toFile(), (File)this.getObjectPath().metadataBackupDirPath().toFile());
            virtualFileSystemOperation = this.deleteObjectPreviousVersions(objectMetadata.getVersion());
            for (n = 0; n < objectMetadata.getVersion(); ++n) {
                FileUtils.deleteQuietly((File)this.getObjectPath().metadataFileVersionPath(n).toFile());
            }
            objectMetadata.addSystemTag("delete versions");
            objectMetadata.setLastModified(OffsetDateTime.now());
            Files.writeString(this.getObjectPath().metadataFilePath(), (CharSequence)this.getObjectMapper().writeValueAsString((Object)objectMetadata), new OpenOption[0]);
            bl2 = virtualFileSystemOperation.commit();
            try {
                if (!bl2) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                        return;
                    }
                    catch (InternalCriticalException internalCriticalException) {
                        if (!bl) {
                            throw internalCriticalException;
                        }
                        logger.error((Throwable)internalCriticalException, new String[]{this.info(), "---- not thrown ----"});
                        return;
                    }
                    catch (Exception exception) {
                        if (!bl) {
                            throw new InternalCriticalException(exception, this.info());
                        }
                        logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                        return;
                    }
                }
                try {
                    n = 0;
                    while (true) {
                        if (n >= objectMetadata.getVersion()) {
                            FileUtils.deleteQuietly((File)this.getObjectPath().metadataWorkFilePath().toFile());
                            this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(AfterDeleteObjectServiceRequest.class, new Object[]{virtualFileSystemOperation.getOperationCode(), objectMetadata, objectMetadata.getVersion()}));
                            return;
                        }
                        FileUtils.deleteQuietly((File)this.getObjectPath().dataFileVersionPath(n).toFile());
                        ++n;
                    }
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                    return;
                }
            }
            finally {
                this.bucketReadUnLock();
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl = true;
                        throw new InternalCriticalException(exception, this.info());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl2) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                                throw throwable;
                            }
                            catch (InternalCriticalException internalCriticalException2) {
                                if (!bl) {
                                    throw internalCriticalException2;
                                }
                                logger.error((Throwable)internalCriticalException2, new String[]{this.info(), "---- not thrown ----"});
                                throw throwable;
                            }
                            catch (Exception exception) {
                                if (!bl) {
                                    throw new InternalCriticalException(exception, this.info());
                                }
                                logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                                throw throwable;
                            }
                        }
                        try {
                            int n3 = 0;
                            while (true) {
                                if (n3 >= objectMetadata.getVersion()) {
                                    FileUtils.deleteQuietly((File)this.getObjectPath().metadataWorkFilePath().toFile());
                                    this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(AfterDeleteObjectServiceRequest.class, new Object[]{virtualFileSystemOperation.getOperationCode(), objectMetadata, objectMetadata.getVersion()}));
                                    throw throwable;
                                }
                                FileUtils.deleteQuietly((File)this.getObjectPath().dataFileVersionPath(n3).toFile());
                                ++n3;
                            }
                        }
                        catch (Exception exception) {
                            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                            throw throwable;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
            }
        }
        finally {
            this.objectWriteUnLock();
        }
    }

    private VirtualFileSystemOperation deleteObjectPreviousVersions(int n) {
        return this.deleteObjectPreviousVersions(this.getBucket(), this.getObjectName(), n);
    }
}

