/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.Files;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.BucketMetadata;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.virtualFileSystem.DriveInfo;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.IODriveSetup;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RAIDZeroDriveSetupSync
implements IODriveSetup {
    private static Logger logger = Logger.getLogger((String)RAIDZeroDriveSetupSync.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private RAIDZeroDriver driver;
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong moved = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytesMoved = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytesCleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong cleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);
    @JsonIgnore
    int maxProcessingThread;
    @JsonIgnore
    private long start_ms;
    @JsonIgnore
    private long start_move;
    @JsonIgnore
    private long start_cleanup;
    @JsonIgnore
    private List<Drive> listEnabledBefore = new ArrayList();
    @JsonIgnore
    private List<Drive> listAllBefore = new ArrayList();

    public RAIDZeroDriveSetupSync(RAIDZeroDriver rAIDZeroDriver) {
        this.driver = rAIDZeroDriver;
        this.maxProcessingThread = Double.valueOf(Double.valueOf(Runtime.getRuntime().availableProcessors() - 1) / 2.0).intValue() + 1;
    }

    public boolean setup() {
        String string;
        this.start_ms = System.currentTimeMillis();
        this.getDriver().getDrivesEnabled().forEach(drive -> this.listEnabledBefore.add(drive));
        this.getDriver().getDrivesAll().forEach(drive -> this.listAllBefore.add(drive));
        startuplogger.info("This process is blocking for RAID 0");
        startuplogger.info("It may take some time to complete. It has tow steps:");
        startuplogger.info("1. Copy files to the new Drives");
        startuplogger.info("2. After completing the copy process, it will clean up duplicates");
        OdilonServerInfo odilonServerInfo = this.getDriver().getServerInfo();
        File file = ((Drive)this.getDriver().getDrivesEnabled().get(0)).getSysFile("key.enc");
        try {
            string = this.getDriver().getObjectMapper().writeValueAsString((Object)odilonServerInfo);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new InternalCriticalException((Exception)((Object)jsonProcessingException));
        }
        startuplogger.info("1. Copying -> odilon.json");
        this.getDriver().getDrivesAll().forEach(drive -> {
            File file = drive.getSysFile("odilon.json");
            if (!(drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC || file != null && file.exists())) {
                try {
                    drive.putSysFile("odilon.json", string);
                }
                catch (Exception exception) {
                    throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                }
            }
        });
        if (file != null && file.exists()) {
            startuplogger.info("2. Copying -> key.enc");
            this.getDriver().getDrivesAll().forEach(drive -> {
                File file2 = drive.getSysFile("key.enc");
                if (!(drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC || file2 != null && file2.exists())) {
                    try {
                        Files.copy((File)file, (File)file2);
                    }
                    catch (Exception exception) {
                        throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                    }
                }
            });
        } else {
            startuplogger.info("2. Copying -> key.enc | file not exist. skipping");
        }
        this.createBuckets();
        if (this.errors.get() > 0L || this.notAvailable.get() > 0L) {
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            startuplogger.error(new String[]{"---------------------------------"});
            return false;
        }
        this.copy();
        if (this.errors.get() > 0L || this.notAvailable.get() > 0L) {
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            startuplogger.error(new String[]{"---------------------------------"});
            return false;
        }
        this.updateDrives();
        try {
            this.cleanUp();
        }
        catch (Exception exception) {
            startuplogger.debug((Object)exception);
            startuplogger.info("Although the Cleanup process did not complete normally, the server can operate normally.");
            startuplogger.info("Cleanup will be executed again automatically in the future to release unused storage");
        }
        startuplogger.info("---------------------------------");
        startuplogger.info(this.getClass().getSimpleName() + " Process completed");
        startuplogger.info("Drive setup completed successfully.");
        startuplogger.debug("Threads: " + String.valueOf(this.maxProcessingThread));
        startuplogger.info("Total objects processed: " + String.valueOf(this.counter.get()));
        startuplogger.info("Total objects required move to another disk: " + String.valueOf(this.moved.get()));
        startuplogger.info("Total storage moved: " + String.format("%16.6f", Double.valueOf(this.totalBytesMoved.get()) / 1.073741824E9).trim() + " GB");
        if (this.errors.get() > 0L) {
            startuplogger.info("Errors: " + String.valueOf(this.errors.get()));
        }
        if (this.notAvailable.get() > 0L) {
            startuplogger.debug("Not Available: " + String.valueOf(this.notAvailable.get()));
        }
        startuplogger.debug("Duration copy: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_move) / Double.valueOf(1000.0)) + " secs");
        startuplogger.debug("Duration clean up: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_cleanup) / Double.valueOf(1000.0)) + " secs");
        startuplogger.info("Duration Total: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_ms) / Double.valueOf(1000.0)) + " secs");
        startuplogger.info("---------------------------------");
        return true;
    }

    protected RAIDZeroDriver getDriver() {
        return this.driver;
    }

    protected List<ServerBucket> listAllBuckets() {
        return this.getDriver().getVirtualFileSystemService().listAllBuckets();
    }

    private void updateDrives() {
        for (Drive drive : this.getDriver().getDrivesAll()) {
            if (drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
            DriveInfo driveInfo = drive.getDriveInfo();
            driveInfo.setStatus(DriveStatus.ENABLED);
            driveInfo.setOrder(drive.getConfigOrder());
            drive.setDriveInfo(driveInfo);
            this.getDriver().getVirtualFileSystemService().updateDriveStatus(drive);
            startuplogger.info("drive added -> " + drive.getRootDirPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        ExecutorService executorService = null;
        startuplogger.info("5. Starting clean up step");
        startuplogger.info("The new Drives are already operational");
        startuplogger.info("This process eliminates duplicates");
        try {
            this.start_cleanup = System.currentTimeMillis();
            this.counter = new AtomicLong(0L);
            this.cleaned = new AtomicLong(0L);
            this.totalBytesCleaned = new AtomicLong(0L);
            executorService = Executors.newFixedThreadPool(this.maxProcessingThread);
            for (ServerBucket serverBucket : this.listAllBuckets()) {
                Integer n = 1000;
                Long l = 0L;
                String string = null;
                boolean bl = false;
                while (!bl) {
                    DataList dataList = this.getDriver().getVirtualFileSystemService().listObjects(serverBucket.getName(), Optional.of(l), Optional.ofNullable(n), Optional.empty(), Optional.ofNullable(string));
                    if (string == null) {
                        string = dataList.getAgentId();
                    }
                    ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(dataList.getList().size());
                    for (Item item : dataList.getList()) {
                        arrayList.add(() -> {
                            try {
                                this.counter.getAndIncrement();
                                if ((this.counter.get() + 1L) % 50L == 0L) {
                                    logger.debug("scanned (clean up) so far -> " + String.valueOf(this.counter.get()));
                                }
                                if (item.isOk()) {
                                    Drive drive = this.getCurrentDrive(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName());
                                    Drive drive2 = this.getNewDrive(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName());
                                    if (!drive2.equals((Object)drive)) {
                                        try {
                                            drive.deleteObjectMetadata(serverBucket, ((ObjectMetadata)item.getObject()).getObjectName());
                                            ObjectPath objectPath = new ObjectPath(drive, (ObjectMetadata)item.getObject());
                                            FileUtils.deleteQuietly((File)objectPath.dataFilePath().toFile());
                                            if (this.getDriver().getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                                                for (int i = 0; i < ((ObjectMetadata)item.getObject()).getVersion(); ++i) {
                                                    File file = drive.getObjectMetadataVersionFile(serverBucket, ((ObjectMetadata)item.getObject()).getObjectName(), i);
                                                    FileUtils.deleteQuietly((File)file);
                                                    FileUtils.deleteQuietly((File)objectPath.dataFileVersionPath(i).toFile());
                                                }
                                            }
                                            this.cleaned.getAndIncrement();
                                        }
                                        catch (Exception exception) {
                                            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                            this.errors.getAndIncrement();
                                        }
                                    }
                                } else {
                                    this.notAvailable.getAndIncrement();
                                }
                            }
                            catch (Exception exception) {
                                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                this.errors.getAndIncrement();
                            }
                            return null;
                        });
                    }
                    try {
                        executorService.invokeAll(arrayList, 10L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
                    }
                    l = l + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
                    bl = dataList.isEOD() || this.errors.get() > 0L;
                }
            }
            try {
                executorService.shutdown();
                executorService.awaitTermination(20L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            logger.debug("scanned (clean up) so far -> " + String.valueOf(this.counter.get()));
            startuplogger.info("cleanup completed -> " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_cleanup) / Double.valueOf(1000.0)) + " secs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy() {
        ExecutorService executorService = null;
        try {
            startuplogger.info("4. Starting to copy data");
            this.start_move = System.currentTimeMillis();
            this.errors = new AtomicLong(0L);
            this.totalBytesMoved = new AtomicLong(0L);
            this.counter = new AtomicLong(0L);
            executorService = Executors.newFixedThreadPool(this.maxProcessingThread);
            for (ServerBucket serverBucket : this.getDriver().getVirtualFileSystemService().listAllBuckets()) {
                Integer n = 1000;
                Long l = 0L;
                String string = null;
                boolean bl = false;
                while (!bl) {
                    DataList dataList = this.getDriver().getVirtualFileSystemService().listObjects(serverBucket.getName(), Optional.of(l), Optional.ofNullable(n), Optional.empty(), Optional.ofNullable(string));
                    if (string == null) {
                        string = dataList.getAgentId();
                    }
                    ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(dataList.getList().size());
                    for (Item item : dataList.getList()) {
                        arrayList.add(() -> {
                            block12: {
                                try {
                                    this.counter.getAndIncrement();
                                    if ((this.counter.get() + 1L) % 50L == 0L) {
                                        logger.debug("scanned (copy) so far -> " + String.valueOf(this.counter.get()));
                                    }
                                    if (item.isOk()) {
                                        Drive drive = this.getCurrentDrive(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName());
                                        Drive drive2 = this.getNewDrive(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName());
                                        if (drive2.equals((Object)drive)) break block12;
                                        try {
                                            File file = drive2.getObjectMetadataFile(serverBucket, ((ObjectMetadata)item.getObject()).getObjectName());
                                            if (!file.exists()) {
                                                ObjectPath objectPath = new ObjectPath(drive, ((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName());
                                                File file2 = objectPath.dataFilePath().toFile();
                                                if (file2.exists()) {
                                                    ((SimpleDrive)drive2).putObjectDataFile(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName(), file2);
                                                    this.totalBytesMoved.getAndAdd(file2.length());
                                                }
                                                ObjectMetadata objectMetadata = (ObjectMetadata)item.getObject();
                                                objectMetadata.drive = drive2.getName();
                                                drive2.saveObjectMetadata(objectMetadata);
                                                this.moved.getAndIncrement();
                                                File file3 = drive.getObjectMetadataFile(serverBucket, objectMetadata.getObjectName());
                                                if (file3.exists()) {
                                                    this.totalBytesMoved.getAndAdd(file3.length());
                                                }
                                                if (this.getDriver().getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                                                    for (int i = 0; i < ((ObjectMetadata)item.getObject()).getVersion(); ++i) {
                                                        File file4;
                                                        File file5 = drive.getObjectMetadataVersionFile(serverBucket, ((ObjectMetadata)item.getObject()).getObjectName(), i);
                                                        if (file5.exists()) {
                                                            drive2.putObjectMetadataVersionFile(serverBucket, ((ObjectMetadata)item.getObject()).getObjectName(), i, file5);
                                                            this.totalBytesMoved.getAndAdd(file5.length());
                                                        }
                                                        if (!(file4 = objectPath.dataFileVersionPath(i).toFile()).exists()) continue;
                                                        ((SimpleDrive)drive2).putObjectDataVersionFile(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName(), i, file4);
                                                        this.totalBytesMoved.getAndAdd(file4.length());
                                                    }
                                                }
                                            }
                                            break block12;
                                        }
                                        catch (Exception exception) {
                                            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                            this.errors.getAndIncrement();
                                            break block12;
                                        }
                                    }
                                    this.notAvailable.getAndIncrement();
                                }
                                catch (Exception exception) {
                                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                    this.errors.getAndIncrement();
                                }
                            }
                            return null;
                        });
                    }
                    try {
                        executorService.invokeAll(arrayList, 15L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
                    }
                    l = l + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
                    bl = dataList.isEOD() || this.errors.get() > 0L || this.notAvailable.get() > 0L;
                }
            }
            try {
                executorService.shutdown();
                executorService.awaitTermination(15L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            startuplogger.info("move completed -> " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_move) / Double.valueOf(1000.0)) + " secs");
        }
    }

    private Drive getCurrentDrive(Long l, String string) {
        return (Drive)this.listEnabledBefore.get(Math.abs(string.hashCode() % this.listEnabledBefore.size()));
    }

    private Drive getNewDrive(Long l, String string) {
        return (Drive)this.listAllBefore.get(Math.abs(string.hashCode() % this.listAllBefore.size()));
    }

    private void createBuckets() {
        List list = this.getDriver().getVirtualFileSystemService().listAllBuckets();
        startuplogger.info("3. Creating " + String.valueOf(list.size()) + " Bucket" + (list.size() > 1 ? "s" : ""));
        for (ServerBucket serverBucket : list) {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                if (drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
                try {
                    if (drive.existsBucketById(serverBucket.getId())) continue;
                    BucketMetadata bucketMetadata = serverBucket.getBucketMetadata();
                    drive.createBucket(bucketMetadata);
                }
                catch (Exception exception) {
                    this.errors.getAndIncrement();
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    return;
                }
            }
        }
    }
}

