/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackHandler;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class RAIDZeroRollbackRestorePreviousVersionHandler
extends RAIDZeroRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroRollbackRestorePreviousVersionHandler.class.getName());

    public RAIDZeroRollbackRestorePreviousVersionHandler(RAIDZeroDriver rAIDZeroDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDZeroDriver, virtualFileSystemOperation, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback() {
        boolean bl = false;
        try {
            File file;
            ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
            Drive drive = this.getWriteDrive(serverBucket, this.getOperation().getObjectName());
            ObjectPath objectPath = new ObjectPath(drive, serverBucket, this.getOperation().getObjectName());
            File file2 = objectPath.dataFileVersionPath(this.getOperation().getVersion()).toFile();
            if (file2.exists()) {
                ((SimpleDrive)drive).putObjectDataFile(serverBucket.getId(), this.getOperation().getObjectName(), file2);
                FileUtils.deleteQuietly((File)file2);
            }
            if ((file = drive.getObjectMetadataVersionFile(serverBucket, this.getOperation().getObjectName(), this.getOperation().getVersion())).exists()) {
                drive.putObjectMetadataFile(serverBucket, this.getOperation().getObjectName(), file);
                FileUtils.deleteQuietly((File)file);
            }
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error(new String[]{this.info(), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.info());
            }
            logger.error(new String[]{this.info(), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }
}

