/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackObjectHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackUpdateHandler;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class RAIDZeroRollbackUpdateHandler
extends RAIDZeroRollbackObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroRollbackUpdateHandler.class.getName());

    public RAIDZeroRollbackUpdateHandler(RAIDZeroDriver rAIDZeroDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDZeroDriver, virtualFileSystemOperation, bl);
    }

    protected void rollback() {
        switch (1.$SwitchMap$io$odilon$virtualFileSystem$model$OperationCode[this.getOperation().getOperationCode().ordinal()]) {
            case 1: {
                this.rollbackUpdate();
                break;
            }
            case 2: {
                this.rollbackUpdateMetadata();
                break;
            }
        }
    }

    private void rollbackUpdate() {
        boolean bl = false;
        try {
            this.restoreVersion();
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error(new String[]{this.info(), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.info());
            }
            logger.error(new String[]{this.info(), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private void rollbackUpdateMetadata() {
        boolean bl = false;
        try {
            FileUtils.copyDirectory((File)this.getObjectPath().metadataBackupDirPath().toFile(), (File)this.getObjectPath().metadataDirPath().toFile());
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error((Throwable)internalCriticalException, new String[]{this.info(), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.info());
            }
            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private void restoreVersion() {
        Object object;
        Drive drive;
        ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
        try {
            drive = this.getWriteDrive(serverBucket, this.getOperation().getObjectName());
            object = new ObjectPath(drive, serverBucket, this.getOperation().getObjectName());
            File file = object.dataFileVersionPath(this.getOperation().getVersion()).toFile();
            if (file.exists()) {
                ((SimpleDrive)drive).putObjectDataFile(serverBucket.getId(), this.getOperation().getObjectName(), file);
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.info());
        }
        try {
            drive = this.getWriteDrive(serverBucket, this.getOperation().getObjectName());
            object = drive.getObjectMetadataVersionFile(serverBucket, this.getOperation().getObjectName(), this.getOperation().getVersion());
            if (((File)object).exists()) {
                drive.putObjectMetadataFile(serverBucket, this.getOperation().getObjectName(), (File)object);
                FileUtils.deleteQuietly((File)object);
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.info());
        }
    }
}

